/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet;

import tigase.component.exceptions.ComponentException;
import tigase.eventbus.EventBus;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.UnregisterAware;
import tigase.kernel.beans.config.ConfigField;
import tigase.meet.IMeetLogic;
import tigase.meet.IMeetRepository;
import tigase.meet.IPresenceRepository;
import tigase.meet.Meet;
import tigase.meet.MeetComponent;
import tigase.meet.Participation;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="meetLogic", parent=MeetComponent.class, active=true)
public class DefaultMeetLogic
implements Initializable,
UnregisterAware,
IMeetLogic {
    @Inject(bean="service")
    private MeetComponent meetComponent;
    @Inject
    private EventBus eventBus;
    @Inject
    private IMeetRepository meetRepository;
    @ConfigField(desc="Maximal no. of publishers for each meeting")
    private Integer maxNoOfPublishers = 6;

    @Override
    public void checkCreatePermission(BareJID meetJid, JID senderJID) throws ComponentException {
        if (!meetJid.getDomain().equals(this.meetComponent.getName() + "." + senderJID.getDomain())) {
            throw new ComponentException(Authorization.FORBIDDEN);
        }
    }

    @Override
    public void checkPermission(Meet meet, JID senderJID, IMeetLogic.Action action) throws ComponentException {
        if (meet.isPublic()) {
            return;
        }
        if (!meet.isAllowed(senderJID.getBareJID())) {
            throw new ComponentException(Authorization.FORBIDDEN, "You are not authorized to " + action + " this meeting.");
        }
    }

    @Override
    public int getDefMaxNoOfPublishers() {
        return this.maxNoOfPublishers;
    }

    public void initialize() {
        this.eventBus.registerAll((Object)this);
    }

    public void beforeUnregister() {
        if (this.eventBus != null) {
            this.eventBus.unregisterAll((Object)this);
        }
    }

    @HandleEvent
    public void userDisappeared(IPresenceRepository.UserDisappearedEvent event) {
        try {
            Meet meet = this.meetRepository.getMeet(event.getMeetJid());
            Participation participation = meet.getParticipation(event.getJid());
            if (participation != null) {
                participation.leave(null);
            }
        }
        catch (ComponentException componentException) {
            // empty catch block
        }
    }
}

