/*
 * Decompiled with CFR 0.152.
 */
package tigase.meet;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import tigase.meet.AbstractMeet;
import tigase.meet.AbstractParticipation;
import tigase.meet.Session;
import tigase.meet.janus.JSEP;
import tigase.meet.janus.JanusPlugin;
import tigase.meet.janus.videoroom.LocalPublisher;
import tigase.meet.janus.videoroom.LocalSubscriber;
import tigase.xmpp.jid.JID;

public abstract class AbstractParticipationWithSession<P extends AbstractParticipationWithSession<P, M>, M extends AbstractMeet<P>>
extends AbstractParticipation<P, M> {
    private static final Logger a = Logger.getLogger(AbstractParticipationWithSession.class.getCanonicalName());
    private final JID b;
    private Optional<Session> c = Optional.empty();
    private Optional<Session> d = Optional.empty();

    public AbstractParticipationWithSession(M meet, JID jid, LocalPublisher localPublisher, LocalSubscriber localSubscriber) {
        super(meet, localPublisher, localSubscriber);
        this.b = jid;
    }

    public JID getJid() {
        return this.b;
    }

    public synchronized Optional<Session> getPublisherSession() {
        return this.d;
    }

    public Optional<String> getPublisherSessionId() {
        return this.d.map(Session::getId);
    }

    public synchronized Optional<Session> getSubscriberSession() {
        return this.c;
    }

    public Optional<String> getSubscriberSessionId() {
        return this.c.map(Session::getId);
    }

    public synchronized void startSubscriberSession(String subscriberSessionId) {
        this.c = Optional.of(new Session(subscriberSessionId));
    }

    public synchronized void startPublisherSession(String publisherSessionId) {
        this.d = Optional.of(new Session(publisherSessionId));
    }

    public synchronized void terminateSubscriberSession() {
        this.c = Optional.empty();
    }

    public synchronized void terminatePublisherSession() {
        this.d = Optional.empty();
    }

    @Override
    public void receivedPublisherSDP(JSEP jsep) {
        this.getPublisherSessionId().ifPresent(string -> this.receivedPublisherSDP((String)string, jsep));
    }

    protected abstract void receivedPublisherSDP(String var1, JSEP var2);

    @Override
    public void receivedPublisherCandidate(JanusPlugin.Candidate candidate) {
        this.getPublisherSessionId().ifPresent(string -> this.receivedPublisherCandidate((String)string, candidate));
    }

    protected abstract void receivedPublisherCandidate(String var1, JanusPlugin.Candidate var2);

    @Override
    public synchronized void receivedSubscriberSDP(JSEP jsep) {
        if (this.getSubscriberSessionId().isEmpty()) {
            this.startSubscriberSession(UUID.randomUUID().toString());
        }
        this.getSubscriberSessionId().ifPresent(string -> this.receivedSubscriberSDP((String)string, jsep));
    }

    protected abstract void receivedSubscriberSDP(String var1, JSEP var2);

    @Override
    public void receivedSubscriberCandidate(JanusPlugin.Candidate candidate) {
        this.getSubscriberSessionId().ifPresent(string -> this.receivedSubscriberCandidate((String)string, candidate));
    }

    protected abstract void receivedSubscriberCandidate(String var1, JanusPlugin.Candidate var2);

    @Override
    public synchronized CompletableFuture<Void> leave(Throwable ex) {
        this.terminatePublisherSession();
        this.terminateSubscriberSession();
        return super.leave(ex);
    }

    @Override
    public String toString() {
        return "AbstractParticipationWithSession{jid=" + this.b + ", meet=" + this.getMeet() + "}";
    }
}

