/*
 * Decompiled with CFR 0.152.
 */
package tigase.mix.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.component.PacketWriter;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.mix.Affiliations;
import tigase.mix.Mix;
import tigase.mix.MixComponent;
import tigase.mix.model.ChannelConfiguration;
import tigase.mix.model.IMixRepository;
import tigase.mix.model.IParticipant;
import tigase.mix.model.MixLogic;
import tigase.mix.model.Participant;
import tigase.pubsub.Affiliation;
import tigase.pubsub.CollectionItemsOrdering;
import tigase.pubsub.Subscription;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.modules.RetractItemModule;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IItems;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.ISubscriptions;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.pubsub.repository.cached.IAffiliationsCached;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.utils.Cache;
import tigase.pubsub.utils.LRUCacheWithFuture;
import tigase.server.DataForm;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="mixRepository", parent=MixComponent.class, active=true)
public class MixRepository<T>
implements IMixRepository,
IPubSubRepository.IListener,
CachedPubSubRepository.NodeAffiliationProvider<T> {
    private static final Logger log = Logger.getLogger(MixRepository.class.getCanonicalName());
    @Inject(nullAllowed=true)
    private MixLogic mixLogic;
    @Inject(nullAllowed=true)
    private PublishItemModule publishItemModule;
    @Inject
    private RetractItemModule retractItemModule;
    @Inject
    private IPubSubRepository pubSubRepository;
    @Inject
    private PacketWriter packetWriter;
    private final Cache<BareJID, ChannelConfiguration> channelConfigs = new LRUCacheWithFuture(1000);
    private final Cache<ParticipantKey, Participant> participants = new LRUCacheWithFuture(4000);

    @Override
    public Optional<List<BareJID>> getAllowed(BareJID channelJID) throws RepositoryException {
        IItems items = this.pubSubRepository.getNodeItems(channelJID, "urn:xmpp:mix:nodes:allowed");
        if (items == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(items.getItemsIds(CollectionItemsOrdering.byUpdateDate)).map(strings -> Arrays.stream(strings).map(BareJID::bareJIDInstanceNS).collect(Collectors.toList()));
    }

    @Override
    public Optional<List<BareJID>> getBanned(BareJID channelJID) throws RepositoryException {
        IItems items = this.pubSubRepository.getNodeItems(channelJID, "urn:xmpp:mix:nodes:banned");
        if (items == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(items.getItemsIds(CollectionItemsOrdering.byUpdateDate)).map(strings -> Arrays.stream(strings).map(BareJID::bareJIDInstanceNS).collect(Collectors.toList()));
    }

    @Override
    public IParticipant getParticipant(BareJID channelJID, BareJID participantRealJID) throws RepositoryException {
        String participantId = this.mixLogic.generateParticipantId(channelJID, participantRealJID);
        return this.getParticipant(channelJID, participantId);
    }

    @Override
    public IParticipant getParticipant(BareJID channelJID, String participantId) throws RepositoryException {
        return this.getParticipant(new ParticipantKey(channelJID, participantId));
    }

    protected IParticipant getParticipant(ParticipantKey key) throws RepositoryException {
        try {
            return (IParticipant)this.participants.computeIfAbsent((Object)key, () -> {
                try {
                    IItems items = this.pubSubRepository.getNodeItems(key.channelJID, "urn:xmpp:mix:nodes:participants");
                    if (items == null) {
                        return null;
                    }
                    IItems.IItem item = items.getItem(key.participantId);
                    if (item == null) {
                        return null;
                    }
                    return new Participant(key.participantId, item.getItem().getChild("participant", "urn:xmpp:mix:core:1"));
                }
                catch (RepositoryException ex) {
                    throw new Cache.CacheException((Throwable)ex);
                }
            });
        }
        catch (Cache.CacheException ex) {
            throw new RepositoryException(ex.getMessage(), (Throwable)ex);
        }
    }

    @Override
    public void removeParticiapnt(BareJID channelJID, BareJID participantJID) throws RepositoryException {
        String id = this.mixLogic.generateParticipantId(channelJID, participantJID);
        this.retractItemModule.retractItems(channelJID, "urn:xmpp:mix:nodes:participants", Collections.singletonList(id));
        this.participants.remove((Object)new ParticipantKey(channelJID, id));
    }

    @Override
    public IParticipant updateParticipant(BareJID channelJID, BareJID participantJID, String nick) throws RepositoryException, PubSubException {
        Participant participant = new Participant(this.mixLogic.generateParticipantId(channelJID, participantJID), participantJID, nick);
        Element itemEl = new Element("item");
        itemEl.setAttribute("id", participant.getParticipantId());
        itemEl.addChild((XMLNodeIfc)participant.toElement());
        this.publishItemModule.publishItems(channelJID, "urn:xmpp:mix:nodes:participants", JID.jidInstance((BareJID)participantJID), Collections.singletonList(itemEl), null);
        this.participants.put((Object)new ParticipantKey(channelJID, participant.getParticipantId()), (Object)participant);
        return participant;
    }

    @Override
    public IParticipant updateTempParticipant(BareJID channelJID, JID participantJID, String nick) throws RepositoryException, PubSubException {
        Participant participant = new Participant(this.mixLogic.generateTempParticipantId(channelJID, participantJID), participantJID.getBareJID(), nick);
        Element itemEl = new Element("item");
        itemEl.setAttribute("id", participant.getParticipantId());
        Element participantEl = participant.toElement();
        participantEl.addChild((XMLNodeIfc)new Element("resource", participantJID.getResource()).withAttribute("xmlns", "tigase:mix:muc:0"));
        itemEl.addChild((XMLNodeIfc)participantEl);
        this.publishItemModule.publishItems(channelJID, "urn:xmpp:mix:nodes:participants", participantJID, Collections.singletonList(itemEl), null);
        this.participants.put((Object)new ParticipantKey(channelJID, participant.getParticipantId()), (Object)participant);
        return participant;
    }

    @Override
    public void removeTempParticipant(BareJID channelJID, JID participantJID) throws RepositoryException {
        String id = this.mixLogic.generateTempParticipantId(channelJID, participantJID);
        this.retractItemModule.retractItems(channelJID, "urn:xmpp:mix:nodes:participants", Collections.singletonList(id));
        this.participants.remove((Object)new ParticipantKey(channelJID, id));
    }

    @Override
    public String getChannelName(BareJID channelJID) throws RepositoryException {
        IItems.IItem item;
        IItems items = this.pubSubRepository.getNodeItems(channelJID, "urn:xmpp:mix:nodes:info");
        if (items != null && (item = items.getLastItem(CollectionItemsOrdering.byUpdateDate)) != null) {
            return DataForm.getFieldValue((Element)item.getItem(), (String)"Name");
        }
        return null;
    }

    @Override
    public ChannelConfiguration getChannelConfiguration(BareJID channelJID) throws RepositoryException {
        try {
            ChannelConfiguration configuration = (ChannelConfiguration)this.channelConfigs.computeIfAbsent((Object)channelJID, () -> {
                try {
                    return this.loadChannelConfiguration(channelJID);
                }
                catch (RepositoryException ex) {
                    throw new Cache.CacheException((Throwable)ex);
                }
            });
            return configuration;
        }
        catch (Cache.CacheException ex) {
            throw new RepositoryException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected ChannelConfiguration loadChannelConfiguration(BareJID channelJID) throws RepositoryException {
        String lastID;
        IItems.IItem item;
        String[] ids;
        IItems items = this.pubSubRepository.getNodeItems(channelJID, "urn:xmpp:mix:nodes:config");
        if (items != null && (ids = items.getItemsIds(CollectionItemsOrdering.byUpdateDate)) != null && ids.length > 0 && (item = items.getItem(lastID = ids[ids.length - 1])) != null) {
            try {
                return new ChannelConfiguration(item.getItem());
            }
            catch (PubSubException ex) {
                throw new RepositoryException("Could not load channel " + channelJID + " configuration", (Throwable)ex);
            }
        }
        return null;
    }

    @Override
    public ISubscriptions getNodeSubscriptions(BareJID serviceJid, String nodeName) throws RepositoryException {
        return this.pubSubRepository.getNodeSubscriptions(serviceJid, nodeName);
    }

    public void serviceRemoved(BareJID userJid) {
        this.channelConfigs.remove((Object)userJid);
    }

    public void itemDeleted(BareJID serviceJID, String node, String id) {
        switch (node) {
            case "urn:xmpp:mix:nodes:allowed": {
                try {
                    if (id == null) break;
                    this.bannedParticipantFromChannel(serviceJID, BareJID.bareJIDInstanceNS((String)id));
                }
                catch (RepositoryException repositoryException) {}
                break;
            }
        }
    }

    public void itemWritten(BareJID serviceJID, String node, String id, String publisher, Element item, String uuid) {
        switch (node) {
            case "urn:xmpp:mix:nodes:config": {
                ChannelConfiguration oldConfig = null;
                ChannelConfiguration newConfig = null;
                try {
                    oldConfig = this.getChannelConfiguration(serviceJID);
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                this.updateChannelConfiguration(serviceJID, item);
                try {
                    newConfig = this.getChannelConfiguration(serviceJID);
                    if (newConfig == null || oldConfig == null) break;
                    this.mixLogic.generateAffiliationChangesNotifications(serviceJID, oldConfig, newConfig, arg_0 -> ((PacketWriter)this.packetWriter).write(arg_0));
                }
                catch (RepositoryException repositoryException) {}
                break;
            }
            case "urn:xmpp:mix:nodes:banned": {
                try {
                    if (id == null) break;
                    this.bannedParticipantFromChannel(serviceJID, BareJID.bareJIDInstanceNS((String)id));
                }
                catch (RepositoryException repositoryException) {}
                break;
            }
        }
    }

    public boolean validateItem(BareJID serviceJID, String node, String id, String publisher, Element item) throws PubSubException {
        if ("urn:xmpp:mix:nodes:config".equals(node)) {
            ChannelConfiguration config = new ChannelConfiguration(item);
            ChannelConfiguration.updateLastChangeMadeBy(item, JID.jidInstanceNS((String)publisher));
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "validated channel " + serviceJID + " configuration as valid: " + config.toElement("UNSET"));
            }
            return config != null && config.isValid();
        }
        if ("urn:xmpp:mix:nodes:info".equals(node)) {
            // empty if block
        }
        return true;
    }

    public Map<String, UsersAffiliation> getUserAffiliations(BareJID serviceJid, BareJID jid) throws RepositoryException {
        HashMap<String, UsersAffiliation> userAffiliations = new HashMap<String, UsersAffiliation>();
        String[] nodes = this.pubSubRepository.getRootCollection(serviceJid);
        if (nodes != null) {
            for (String node : nodes) {
                UsersAffiliation affiliation;
                IAffiliations affiliations = this.pubSubRepository.getNodeAffiliations(serviceJid, node);
                if (affiliations == null || (affiliation = affiliations.getSubscriberAffiliation(jid)).getAffiliation() == Affiliation.none) continue;
                userAffiliations.put(node, affiliation);
            }
        }
        return userAffiliations;
    }

    public IAffiliationsCached newNodeAffiliations(BareJID serviceJid, String nodeName, T nodeId, IPubSubRepository.RepositorySupplier<Map<BareJID, UsersAffiliation>> affiliationSupplier) throws RepositoryException {
        if (Mix.Nodes.ALL_NODES.contains(nodeName)) {
            return new Affiliations(serviceJid, nodeName, this);
        }
        return null;
    }

    protected void bannedParticipantFromChannel(BareJID channelJID, BareJID participantJID) throws RepositoryException {
        if (this.getParticipant(channelJID, participantJID) != null) {
            this.removeParticiapnt(channelJID, participantJID);
            Map userSubscriptions = this.pubSubRepository.getUserSubscriptions(channelJID, participantJID);
            for (String node : userSubscriptions.keySet()) {
                ISubscriptions subscriptions = this.pubSubRepository.getNodeSubscriptions(channelJID, node);
                subscriptions.changeSubscription(participantJID, Subscription.none);
                this.pubSubRepository.update(channelJID, node, subscriptions);
            }
        }
    }

    protected void invalidateChannelParticipant(BareJID channelJID, BareJID participantId) throws RepositoryException {
        this.participants.remove((Object)new ParticipantKey(channelJID, this.mixLogic.generateParticipantId(channelJID, participantId)));
    }

    protected void updateChannelConfiguration(BareJID serviceJID, Element item) {
        try {
            ChannelConfiguration configuration = new ChannelConfiguration(item);
            this.channelConfigs.put((Object)serviceJID, (Object)configuration);
        }
        catch (PubSubException ex) {
            log.log(Level.WARNING, "Could not parse new configuration of channel " + serviceJID, ex);
        }
    }

    protected static class ParticipantKey {
        private final BareJID channelJID;
        private final String participantId;

        public ParticipantKey(BareJID channelJID, String participantId) {
            this.channelJID = channelJID;
            this.participantId = participantId;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ParticipantKey)) {
                return false;
            }
            ParticipantKey that = (ParticipantKey)o;
            return this.channelJID.equals((Object)that.channelJID) && this.participantId.equals(that.participantId);
        }

        public int hashCode() {
            return Objects.hash(this.channelJID, this.participantId);
        }
    }
}

