/*
 * Tigase ACS - Tigase Advanced Clustering Strategy
 * Copyright (C) 2004 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.server.cluster.strategy;

import tigase.xmpp.jid.JID;

import java.util.logging.Level;
import java.util.logging.Logger;

import static org.junit.Assert.*;

/**
 * @author andrzej
 */
public class CacheContenerV2Test
		extends CacheContentAbstractTest {

	public CacheContenerV2Test() {
	}

	// Performance results for iterations
	//   1 000 000 =  0.45s
	// 100 000 000 = 19s
	//@Test
	public void performanceTest() {
		CacheContenerIfc container = new CacheContenerV2();
		super.performanceTest(container);
	}

	public void concurrencyTest1() throws InterruptedException {
		final CacheContenerIfc container = new CacheContenerV2();
		final JID node = JID.jidInstanceNS("test@localhost");
		final JID jid1 = JID.jidInstanceNS("user@localhost/test1");
		final JID jid2 = JID.jidInstanceNS("user@localhost/test2");
		new Thread() {
			public void run() {
				ConnectionRecordExt rec = new ConnectionRecordExt();
				rec.setRecordFields(node, jid1, jid1.toString(), jid1);
				container.usersConnected(rec);
			}
		}.start();
		new Thread() {
			public void run() {
				try {
					Thread.sleep(200);
				} catch (InterruptedException ex) {
					Logger.getLogger(CacheContenerV2Test.class.getName()).log(Level.SEVERE, null, ex);
				}
				ConnectionRecordExt rec = new ConnectionRecordExt();
				rec.setRecordFields(node, jid1, jid1.toString(), jid1);
				container.userDisconnected(rec);
			}
		}.start();
		new Thread() {
			public void run() {
				try {
					Thread.sleep(400);
				} catch (InterruptedException ex) {
					Logger.getLogger(CacheContenerV2Test.class.getName()).log(Level.SEVERE, null, ex);
				}
				ConnectionRecordExt rec = new ConnectionRecordExt();
				rec.setRecordFields(node, jid2, jid2.toString(), jid2);
				container.usersConnected(rec);
			}
		}.start();
		Thread.sleep(2000);
		assertTrue(container.containsJid(jid1.getBareJID()));
		assertNotNull(container.getConnectionRecord(jid1));
		assertNotNull(container.getConnectionRecord(jid2));
	}

	/**
	 * Concurrency test for case in which user from on node connects and in meanwhile it connections is broken (when
	 * packet is still processed) - ConnectionRecord should not be added
	 */
	public void concurrencyTest2() throws InterruptedException {
		final CacheContenerIfc container = new CacheContenerV2();
		final JID node = JID.jidInstanceNS("test@localhost");
		final JID jid1 = JID.jidInstanceNS("user@localhost/test1");
		final JID jid2 = JID.jidInstanceNS("user@localhost/test2");
		new Thread() {
			public void run() {
				ConnectionRecordExt rec = new ConnectionRecordExt();
				rec.setRecordFields(node, jid1, jid1.toString(), jid1);
				container.usersConnected(rec);
			}
		}.start();
		new Thread() {
			public void run() {
				try {
					Thread.sleep(200);
				} catch (InterruptedException ex) {
					Logger.getLogger(CacheContenerV2Test.class.getName()).log(Level.SEVERE, null, ex);
				}
				container.removeAllForNode(node);
			}
		}.start();
		new Thread() {
			public void run() {
				try {
					Thread.sleep(400);
				} catch (InterruptedException ex) {
					Logger.getLogger(CacheContenerV2Test.class.getName()).log(Level.SEVERE, null, ex);
				}
				ConnectionRecordExt rec = new ConnectionRecordExt();
				rec.setRecordFields(node, jid2, jid2.toString(), jid2);
				container.usersConnected(rec);
			}
		}.start();
		Thread.sleep(2000);
		assertTrue(container.containsJid(jid1.getBareJID()));
		assertNull(container.getConnectionRecord(jid1));
		assertNotNull(container.getConnectionRecord(jid2));
	}

}
