/*
 * Tigase ACS - Tigase Advanced Clustering Strategy
 * Copyright (C) 2004 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package tigase.server.cluster.strategy.cmd;

//~--- non-JDK imports --------------------------------------------------------

import tigase.cluster.api.ClusterCommandException;
import tigase.server.Packet;
import tigase.server.cluster.strategy.ConnectionRecordExt;
import tigase.server.cluster.strategy.OnlineUsersCachingStrategy;
import tigase.xml.Element;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.jid.JID;

import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

//~--- JDK imports ------------------------------------------------------------

/**
 * @author kobit
 */
public class UserPresenceCmd
		extends TrafficSyncCmdAbstract {

	private static final Logger log = Logger.getLogger(UserPresenceCmd.class.getName());

	protected static void updatePresence(OnlineUsersCachingStrategy strategy, ConnectionRecordExt rec, JID fromNode,
										 Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) {
		XMPPSession session = strategy.getSM().getXMPPSessions().get(rec.getUserJid().getBareJID());
		Element newConnectionPresence = packets.poll();

		// Notify strategy about presence update
		strategy.presenceUpdate(newConnectionPresence, rec);

		// Update all user's resources with the new presence
		if (session != null) {
			if (log.isLoggable(Level.FINEST)) {
				log.log(Level.FINEST, "User's {0} XMPPSession found: {1}",
						new Object[]{rec.getUserJid().getBareJID(), session});
			}
			for (XMPPResourceConnection conn : session.getActiveResources()) {
				Element existingConnectionPresence = conn.getPresence();

				if (conn.isAuthorized() && conn.isResourceSet() && (existingConnectionPresence != null)) {
					try {

						// Send user's presence from remote connection to local connection
						Element clone = newConnectionPresence.clone();
						// Set proper to attribute
						clone.setAttribute("to", conn.getJID().toString());
						Packet newConnectionPresencePacket = Packet.packetInstance(clone);
						newConnectionPresencePacket.setPacketTo(conn.getConnectionId());
						strategy.getSM().fastAddOutPacket(newConnectionPresencePacket);

						// Send user's presence from local connection to remote connection
						// but only if this was an initial presence
						if ((data != null) && PRESENCE_TYPE_INITIAL.equals(data.get(PRESENCE_TYPE_KEY))) {
							// Set proper to attribute
							existingConnectionPresence.setAttribute("to", String.valueOf(rec.getUserJid()));
							Packet existingPresencePacket = Packet.packetInstance(existingConnectionPresence);
							existingPresencePacket.setPacketTo(rec.getConnectionId());
							strategy.getSM().fastAddOutPacket(existingPresencePacket);
						}
					} catch (Exception ex) {

						// TODO Auto-generated catch block
						ex.printStackTrace();
					}
				}
			}
			strategy.getSM().processPresenceUpdate(session, newConnectionPresence);
		} else {
			if (log.isLoggable(Level.FINEST)) {
				log.log(Level.FINEST,
						"No user session for presence update: {0}, visitedNodes: {1}, data: {2}, packets: {3}",
						new Object[]{fromNode, visitedNodes, data, packets});
			}
		}
		if (log.isLoggable(Level.FINEST)) {
			log.log(Level.FINEST, "User presence jid: {0}, fromNode: {1}", new Object[]{rec.getUserJid(), fromNode});
		}
	}

	public UserPresenceCmd(String name, final OnlineUsersCachingStrategy strat) {
		super(name, strat);
	}

	@Override
	public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets)
			throws ClusterCommandException {
		incSyncInTraffic();
		if (log.isLoggable(Level.FINEST)) {
			log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}",
					new Object[]{fromNode, visitedNodes, data, packets});
		}

		ConnectionRecordExt rec = getConnectionRecord(fromNode, data);
		updatePresence(getStrategy(), rec, fromNode, visitedNodes, data, packets);
	}
}

//~ Formatted in Tigase Code Convention on 13/08/28
