/*
 * Tigase ACS - Tigase Advanced Clustering Strategy
 * Copyright (C) 2004 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package tigase.server.cluster.strategy.cmd;

//~--- non-JDK imports --------------------------------------------------------

import tigase.cluster.api.ClusterCommandException;
import tigase.server.cluster.strategy.ConnectionRecordExt;
import tigase.server.cluster.strategy.OnlineUsersCachingStrategy;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

//~--- JDK imports ------------------------------------------------------------

/**
 * @author kobit
 */
public class UserDisconnectedCmd
		extends TrafficSyncCmdAbstract {

	private static final Logger log = Logger.getLogger(UserDisconnectedCmd.class.getName());

	public UserDisconnectedCmd(String name, final OnlineUsersCachingStrategy strat) {
		super(name, strat);
	}

	@Override
	public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets)
			throws ClusterCommandException {
		incSyncInTraffic();
		if (log.isLoggable(Level.FINEST)) {
			log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}",
					new Object[]{fromNode, visitedNodes, data, packets});
		}

		ConnectionRecordExt rec = getConnectionRecord(fromNode, data);

		if (packets != null && !packets.isEmpty()) {
			UserPresenceCmd.updatePresence(getStrategy(), rec, fromNode, visitedNodes, data, packets);
		}

		getStrategy().userDisconnected(rec);
	}
}

//~ Formatted in Tigase Code Convention on 13/07/06
