/*
 * Tigase ACS - Tigase Advanced Clustering Strategy
 * Copyright (C) 2004 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package tigase.server.cluster.strategy.cmd;

//~--- non-JDK imports --------------------------------------------------------

import tigase.cluster.api.ClusterCommandException;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.server.cluster.strategy.ConnectionRecordExt;
import tigase.server.cluster.strategy.OnlineUsersCachingStrategy;
import tigase.xml.Element;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;
import tigase.xmpp.jid.JID;

import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

//~--- JDK imports ------------------------------------------------------------

/**
 * @author kobit
 */
public class UserConnectedCmd
		extends TrafficSyncCmdAbstract {

	private static final Logger log = Logger.getLogger(UserConnectedCmd.class.getName());

	public UserConnectedCmd(String name, final OnlineUsersCachingStrategy strat) {
		super(name, strat);
	}

	@Override
	public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets)
			throws ClusterCommandException {
		incSyncInTraffic();
		if (log.isLoggable(Level.FINEST)) {
			log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}",
					new Object[]{fromNode, visitedNodes, data, packets});
		}

		ConnectionRecordExt rec = getConnectionRecord(fromNode, data);

		getStrategy().usersConnected(rec);

		// There is one more thing....
		// If the new connection is for the same resource we have here then the
		// old connection must be destroyed.
		XMPPSession session = getStrategy().getSM().getXMPPSessions().get(rec.getUserJid().getBareJID());

		if (session != null) {
			XMPPResourceConnection conn = session.getResourceForResource(rec.getUserJid().getResource());

			if (conn != null) {
				if (log.isLoggable(Level.FINEST)) {
					log.log(Level.FINEST, "Duplicate resource connection, logingout the older connection: {0}", rec);
				}
				try {
					Packet cmd = Command.CLOSE.getPacket(getStrategy().getSM().getComponentId(), conn.getConnectionId(),
														 StanzaType.set, conn.nextStanzaId());
					Element err_el = new Element("conflict");

					err_el.setXMLNS("urn:ietf:params:xml:ns:xmpp-streams");
					cmd.getElement().getChild("command").addChild(err_el);
					getStrategy().getSM().fastAddOutPacket(cmd);
				} catch (Exception ex) {

					// TODO Auto-generated catch block
					ex.printStackTrace();
				}
			}
		}
		if (log.isLoggable(Level.FINEST)) {
			log.log(Level.FINEST, "User connected jid: {0}, fromNode: {1}", new Object[]{rec.getUserJid(), fromNode});
		}
	}
}

//~ Formatted in Tigase Code Convention on 13/07/06
