/*
 * Tigase ACS - Tigase Advanced Clustering Strategy
 * Copyright (C) 2004 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.server.cluster.strategy.cmd;

import tigase.cluster.api.ClusterCommandException;
import tigase.server.cluster.strategy.OnlineUsersCachingStrategy;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

import java.util.Map;
import java.util.Queue;
import java.util.Set;

/**
 * Created by andrzej on 02.07.2016.
 */
public class UserConnIdChangedCmd
		extends TrafficSyncCmdAbstract {

	public UserConnIdChangedCmd(String name, final OnlineUsersCachingStrategy strat) {
		super(name, strat);
	}

	@Override
	public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets)
			throws ClusterCommandException {

		BareJID userId = BareJID.bareJIDInstanceNS(data.get(USER_ID));
		JID oldConnectionId = JID.jidInstanceNS(data.get(CONNECTION_ID + "_old"));
		JID newConnectionId = JID.jidInstanceNS(data.get(CONNECTION_ID + "_new"));

		getStrategy().userChangedConnId(userId, oldConnectionId, newConnectionId);
	}
}
