/*
 * Tigase ACS - Tigase Advanced Clustering Strategy
 * Copyright (C) 2004 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package tigase.server.cluster.strategy.cmd;

//~--- non-JDK imports --------------------------------------------------------

import tigase.server.cluster.strategy.OnlineUsersCachingStrategy;

/**
 * @author kobit
 */
public abstract class TrafficSyncCmdAbstract
		extends CachingCmdAbstract {

	private static long syncInTraffic = 0;
	private static long syncOutTraffic = 0;

	public static long getSyncInTraffic() {
		return syncInTraffic;
	}

	public static long getSyncOutTraffic() {
		return syncOutTraffic;
	}

	public TrafficSyncCmdAbstract(String name, final OnlineUsersCachingStrategy strat) {
		super(name, strat);
	}

	@Override
	public synchronized void incSyncInTraffic() {
		++syncInTraffic;
	}

	@Override
	public synchronized void incSyncOutTraffic() {
		++syncOutTraffic;
	}
}

//~ Formatted in Tigase Code Convention on 13/07/06
