/*
 * Tigase ACS - Tigase Advanced Clustering Strategy
 * Copyright (C) 2004 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.server.cluster.strategy.cmd;

//~--- non-JDK imports --------------------------------------------------------

import tigase.cluster.api.ClusterCommandException;
import tigase.server.cluster.strategy.ConnectionRecordExt;
import tigase.server.cluster.strategy.OnlineUsersCachingStrategy;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * @author kobit
 */
public class RespondSyncOnlineCmd
		extends TrafficSyncCmdAbstract {

	private static final Logger log = Logger.getLogger(RespondSyncOnlineCmd.class.getName());

	//~--- constructors ---------------------------------------------------------

	public RespondSyncOnlineCmd(String name, final OnlineUsersCachingStrategy strat) {
		super(name, strat);
	}

	//~--- methods --------------------------------------------------------------

	/**
	 * Method is responsible for processing response to synchronisation request. For empty responses it simply sets
	 * status of the cache to synchronised state. For responses containing data, elements are processed and included
	 * into local connections cache subsequently marking it as synchronised.
	 *
	 * @param fromNode {@link JID} of the originating node from which response came.
	 * @param visitedNodes {@link Set} containing {@code JID} of all already visited nodes
	 * @param data additional data
	 * @param elements response data, either null for empty set or collection of containing information about Connection
	 * IDs (CIDs) of all users JIDs from the given original node.
	 */
	@Override
	public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> elements)
			throws ClusterCommandException {
		incSyncInTraffic();
		if (log.isLoggable(Level.FINEST)) {
			log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}",
					new Object[]{fromNode, visitedNodes, data, elements});
		}

		if (elements != null) {
			ArrayList<ConnectionRecordExt> usrConns = new ArrayList<>(elements.size());

			for (Element elem : elements) {
				ConnectionRecordExt rec = getStrategy().getConnectionRecordInstance();

				rec.setElement(elem);
				usrConns.add(rec);
			}
			getStrategy().usersConnected(usrConns.toArray(new ConnectionRecordExt[usrConns.size()]));
		}

		// Received response, set to synchronized state
		getStrategy().getCacheContener().setSync(true);

	}
}

//~ Formatted in Tigase Code Convention on 13/07/06
