/*
 * Tigase ACS - Tigase Advanced Clustering Strategy
 * Copyright (C) 2004 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.server.cluster.strategy.cmd;

//~--- non-JDK imports --------------------------------------------------------

import tigase.cluster.SessionManagerClustered;
import tigase.cluster.api.ClusterCommandException;
import tigase.server.cluster.strategy.ConnectionRecordExt;
import tigase.server.cluster.strategy.OnlineUsersCachingStrategy;
import tigase.xml.Element;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.jid.JID;

import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * @author kobit
 */
public class RequestSyncOnlineCmd
		extends TrafficSyncCmdAbstract {

	private static final Logger log = Logger.getLogger(RequestSyncOnlineCmd.class.getName());

	//~--- constructors ---------------------------------------------------------

	public RequestSyncOnlineCmd(String name, final OnlineUsersCachingStrategy strat) {
		super(name, strat);
	}

	//~--- methods --------------------------------------------------------------

	/**
	 * Method is responsible for processing request to synchronisation command. It creates a response packet(s)
	 * containing all users connection IDs (CIDs) on the given node and sends them back to node which originated the
	 * request. Records are split into smaller packet for performance reasons. If nor record is present a command with
	 * empty data is sent to allow setting correctly {@code synchronised} state.
	 *
	 * @param fromNode {@link JID} of the originating node from which request came.
	 * @param visitedNodes {@link Set} containing {@code JID} of all already visited nodes
	 * @param data additional data
	 * @param packets {@link Queue} holding all originally received packets.
	 */
	@Override
	public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets)
			throws ClusterCommandException {
		incSyncInTraffic();
		if (log.isLoggable(Level.FINEST)) {
			log.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}",
					new Object[]{fromNode, visitedNodes, data, packets});
		}

		// Send back all online users on this node
		LinkedList<Element> usrConns = new LinkedList<>();

		for (XMPPResourceConnection conn : getStrategy().getSM().getXMPPResourceConnections().values()) {
			try {
				if (conn.isResourceSet()) {
					ConnectionRecordExt cr = getStrategy().getConnectionRecordInstance();

					cr.setRecordFields(getStrategy().getSM().getComponentId(), conn.getJID(), conn.getSessionId(),
									   conn.getConnectionId());

					// cr.setLastPresence(conn.getPresence());
					usrConns.add(cr.toElement());
					if (usrConns.size() > SessionManagerClustered.SYNC_MAX_BATCH_SIZE) {
						incSyncOutTraffic();
						getStrategy().getCluster()
								.sendToNodes(OnlineUsersCachingStrategy.RESPOND_SYNCONLINE_CMD, usrConns,
											 getStrategy().getSM().getComponentId(), null, fromNode);
						usrConns = new LinkedList<>();
					}
				}
			} catch (NotAuthorizedException | NoConnectionIdException ex) {
				// Ignore, only authenticated connections are synchronized
			}
		}
		if (usrConns.size() > 0) {
			incSyncOutTraffic();
			getStrategy().getCluster()
					.sendToNodes(OnlineUsersCachingStrategy.RESPOND_SYNCONLINE_CMD, usrConns,
								 getStrategy().getSM().getComponentId(), null, fromNode);
		} else {
			getStrategy().getCluster()
					.sendToNodes(OnlineUsersCachingStrategy.RESPOND_SYNCONLINE_CMD,
								 getStrategy().getSM().getComponentId(), fromNode);
		}
	}
}

//~ Formatted in Tigase Code Convention on 13/07/06
