/*
 * Tigase ACS - Tigase Advanced Clustering Strategy
 * Copyright (C) 2004 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package tigase.server.cluster.strategy.cmd;

//~--- non-JDK imports --------------------------------------------------------

import tigase.cluster.api.CommandListenerAbstract;
import tigase.server.Priority;
import tigase.server.cluster.strategy.ConnectionRecordExt;
import tigase.server.cluster.strategy.OnlineUsersCachingStrategy;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

//~--- JDK imports ------------------------------------------------------------

/**
 * @author kobit
 */
public abstract class CachingCmdAbstract
		extends CommandListenerAbstract {

	public static final String CONNECTION_ID = "connId";

	public static final String CREATION_TIME = "creation-t";

	public static final String LOGIN_TIME = "login_t";

	public static final String PRESENCE_TYPE_INITIAL = "initial";

	public static final String PRESENCE_TYPE_KEY = "pres-type";

	public static final String RESOURCE = "resource";

	public static final String SM_ID = "smId";

	public static final String USER_ID = "userId";

	public static final String XMPP_SESSION_ID = "xmppSessId";

	private static final Logger log = Logger.getLogger(CachingCmdAbstract.class.getName());

	//~--- fields ---------------------------------------------------------------

	private final OnlineUsersCachingStrategy strat;

	//~--- constructors ---------------------------------------------------------

	public CachingCmdAbstract(String name, final OnlineUsersCachingStrategy strat) {
		super(name, Priority.CLUSTER);
		this.strat = strat;
	}

	//~--- get methods ----------------------------------------------------------

	public OnlineUsersCachingStrategy getStrategy() {
		return strat;
	}

	/**
	 * Method takes the data received from other cluster node and creates a ConnectionRecord with all essential
	 * connection information. This might be used later to identify user's XMPPResourceConnection or use the clustering
	 * strategy API.
	 */
	protected ConnectionRecordExt getConnectionRecord(JID node, Map<String, String> data) {
		BareJID userId = BareJID.bareJIDInstanceNS(data.get(USER_ID));
		String resource = data.get(RESOURCE);
		JID jid = JID.jidInstanceNS(userId, resource);
		String sessionId = data.get(XMPP_SESSION_ID);
		JID connectionId = JID.jidInstanceNS(data.get(CONNECTION_ID));
		ConnectionRecordExt rec = getStrategy().getConnectionRecordInstance();
		long creationTime;
		long loginTime;

		try {
			creationTime = Long.parseLong((String) data.get(CREATION_TIME));
		} catch (Exception ex) {
			creationTime = 0;
		}
		try {
			loginTime = Long.parseLong((String) data.get(LOGIN_TIME));
		} catch (Exception ex) {
			loginTime = 0;
		}
		rec.setRecordFields(node, jid, sessionId, connectionId, creationTime, loginTime);
		if (log.isLoggable(Level.FINEST)) {
			log.log(Level.FINEST, "ConnectionRecord created: {0}", new Object[]{rec});
		}

		return rec;
	}
}

//~ Formatted in Tigase Code Convention on 13/08/28
