/*
 * Tigase ACS - Tigase Advanced Clustering Strategy
 * Copyright (C) 2004 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.acs;

import org.osgi.framework.*;
import tigase.osgi.ModulesManager;
import tigase.server.cluster.strategy.OnlineUsersCachingStrategy;

import java.util.logging.Logger;

/**
 * @author andrzej
 */
public class Activator
		implements BundleActivator, ServiceListener {

	private static final Logger log = Logger.getLogger(Activator.class.getCanonicalName());
	private BundleContext context = null;
	private Class<OnlineUsersCachingStrategy> onlineUsersCachingStrategy = null;
	private ModulesManager serviceManager = null;
	private ServiceReference serviceReference = null;

	@Override
	public void serviceChanged(ServiceEvent event) {
		if (event.getType() == ServiceEvent.REGISTERED) {
			if (serviceReference == null) {
				serviceReference = event.getServiceReference();
				serviceManager = (ModulesManager) context.getService(serviceReference);
				registerAddons();
			}
		} else if (event.getType() == ServiceEvent.UNREGISTERING) {
			if (serviceReference == event.getServiceReference()) {
				unregisterAddons();
				context.ungetService(serviceReference);
				serviceManager = null;
				serviceReference = null;
			}
		}
	}

	@Override
	public void start(BundleContext bc) throws Exception {
		synchronized (this) {
			context = bc;
			onlineUsersCachingStrategy = OnlineUsersCachingStrategy.class;
			bc.addServiceListener(this, "(&(objectClass=" + ModulesManager.class.getName() + "))");
			serviceReference = bc.getServiceReference(ModulesManager.class.getName());
			if (serviceReference != null) {
				serviceManager = (ModulesManager) bc.getService(serviceReference);
				registerAddons();
			}
		}
	}

	@Override
	public void stop(BundleContext bc) throws Exception {
		synchronized (this) {
			if (serviceManager != null) {
				unregisterAddons();
				context.ungetService(serviceReference);
				serviceManager = null;
				serviceReference = null;
			}
			onlineUsersCachingStrategy = null;
		}
	}

	private void registerAddons() {
		if (serviceManager != null) {
			serviceManager.registerClass(onlineUsersCachingStrategy);
			serviceManager.update();
		}
	}

	private void unregisterAddons() {
		if (serviceManager != null) {
			serviceManager.unregisterClass(onlineUsersCachingStrategy);
			serviceManager.update();
		}
	}
}
