/*
 * Decompiled with CFR 0.152.
 */
package tigase.stats.collector.provider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.stats.collector.ElementSigner;
import tigase.stats.collector.SignatureException;
import tigase.stats.collector.StatisticsData;
import tigase.stats.collector.provider.HTTPException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;

public class StatisticsUploader {
    private static final Logger a = Logger.getLogger(StatisticsUploader.class.getCanonicalName());
    private static final Timer b = new Timer();
    private final String c;
    public static final String ERROR_QUERY = "?returnError=true";
    private static final int d = (int)TimeUnit.MINUTES.toMillis(1L);
    private static final SimpleParser e = SingletonFactory.getParserInstance();
    private final ElementSigner f;

    /*
     * WARNING - void declaration
     */
    public StatisticsUploader(ElementSigner signer) {
        void var1_1;
        this.f = var1_1;
        this.c = "https://stats.tigase.software/upload";
    }

    /*
     * WARNING - void declaration
     */
    public StatisticsUploader(ElementSigner signer, String url, boolean returnError) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.f = var1_1;
        this.c = (String)(url != null ? var2_2 : "https://stats.tigase.software/upload") + (var3_3 != false ? ERROR_QUERY : "");
    }

    /*
     * WARNING - void declaration
     */
    public void upload(StatisticsData data, ResultCallback callback) {
        void var2_2;
        Object object = data.toElement();
        object = this.f.sign(object);
        object = object.toString();
        this.a((String)object, (ResultCallback)var2_2, 0);
    }

    private void a(String string, ResultCallback resultCallback, int n) {
        a.log(Level.FINEST, "queuing data for upload = {0} try no = {1}", new Object[]{string, n});
        b.schedule(new TimerTask(this, string, n, resultCallback){
            private /* synthetic */ String a;
            private /* synthetic */ int b;
            private /* synthetic */ ResultCallback c;
            private /* synthetic */ StatisticsUploader d;
            {
                this.d = statisticsUploader;
                this.a = string;
                this.b = n;
                this.c = resultCallback;
            }

            @Override
            public final void run() {
                block7: {
                    try {
                        boolean bl = false;
                        Element element = null;
                        Throwable throwable = null;
                        try {
                            element = StatisticsUploader.a(this.d, this.a);
                            element = this.d.f.verify(element);
                            bl = "result".equals(element.getAttribute("type"));
                        }
                        catch (IOException | SignatureException throwable2) {
                            a.log(Level.SEVERE, "exception uploading statistics", throwable2);
                            throwable = throwable2;
                        }
                        if (!bl) {
                            if (this.b >= 10) {
                                a.log(Level.WARNING, "could not upload statistics data, permanent upload failure");
                                this.c.onFailure((Exception)throwable);
                            } else {
                                a.log(Level.FINE, "could not upload statistics data, queuing for retry, attempt " + this.b + " out of 10");
                                this.d.a(this.a, this.c, this.b + 1);
                            }
                            break block7;
                        }
                        a.log(Level.FINER, "statistics data successfully uploaded");
                        this.c.onSuccess(element);
                        return;
                    }
                    catch (Exception exception) {
                        a.log(Level.SEVERE, "exception during processing upload request, should not happen", exception);
                    }
                }
            }
        }, TimeUnit.MINUTES.toMillis(n << 1));
    }

    static /* synthetic */ Element a(StatisticsUploader object, String charSequence) throws IOException {
        object = new URL(((StatisticsUploader)object).c);
        Object object2 = (HttpURLConnection)((URL)object).openConnection();
        ((URLConnection)object2).setConnectTimeout(d);
        ((URLConnection)object2).setReadTimeout(d * 5);
        ((URLConnection)object2).setDoOutput(true);
        ((HttpURLConnection)object2).setRequestMethod("POST");
        ((URLConnection)object2).setRequestProperty("Accept", "*/*");
        ((URLConnection)object2).setRequestProperty("Content-Type", "application/xml");
        ((URLConnection)object2).setRequestProperty("Content-Length", String.valueOf(((String)charSequence).length()));
        a.log(Level.FINE, "Sending data: {0} to url: {1}", new Object[]{charSequence, object});
        object = ((URLConnection)object2).getOutputStream();
        ((OutputStream)object).write(((String)charSequence).getBytes());
        ((OutputStream)object).flush();
        int n = ((HttpURLConnection)object2).getResponseCode();
        if (n / 100 != 2) {
            a.log(Level.FINE, "Server responded with the code: {0} and message: {1}", new Object[]{n, ((HttpURLConnection)object2).getResponseMessage()});
            throw new HTTPException(n);
        }
        Object object3 = new BufferedReader(new InputStreamReader(((URLConnection)object2).getInputStream()));
        charSequence = new StringBuffer();
        DomBuilderHandler domBuilderHandler = new DomBuilderHandler();
        while ((object2 = ((BufferedReader)object3).readLine()) != null) {
            ((StringBuffer)charSequence).append((String)object2);
            e.parse((SimpleHandler)domBuilderHandler, ((String)object2).toCharArray(), 0, ((String)object2).length());
        }
        a.log(Level.FINE, "Received: {0}", new Object[]{((StringBuffer)charSequence).toString()});
        object3 = domBuilderHandler.getParsedElements();
        if (object3.isEmpty()) {
            throw new IOException("No response");
        }
        return (Element)object3.poll();
    }

    public static interface ResultCallback {
        public void onSuccess(Element var1);

        public void onFailure(Exception var1);
    }
}

