/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.ClusteredComponentIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.component.exceptions.ComponentException;
import tigase.component.modules.StanzaProcessor;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Initializable;
import tigase.kernel.beans.Inject;
import tigase.kernel.beans.selector.ClusterModeRequired;
import tigase.kernel.beans.selector.ConfigType;
import tigase.kernel.beans.selector.ConfigTypeEnum;
import tigase.kernel.beans.selector.ServerBeanSelector;
import tigase.kernel.core.Kernel;
import tigase.licence.LicenceChecker;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.cluster.ClusterNodesAware;
import tigase.pubsub.cluster.IPubSubRepositoryClustered;
import tigase.pubsub.cluster.PartitionedStrategy;
import tigase.pubsub.cluster.PubSubComponentClusteredIfc;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.cluster.modules.PresenceCollectorModuleClustered;
import tigase.pubsub.exceptions.PubSubException;
import tigase.server.ComponentInfo;
import tigase.server.Packet;
import tigase.server.Permissions;
import tigase.server.Priority;
import tigase.stats.StatisticsList;
import tigase.sys.TigaseRuntime;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

@Bean(name="pubsub", parent=Kernel.class, active=true)
@ConfigType(value={ConfigTypeEnum.DefaultMode})
@ClusterModeRequired(active=true)
public class PubSubComponentClustered
extends PubSubComponent
implements ClusteredComponentIfc,
Initializable,
PubSubComponentClusteredIfc {
    private static final Logger a = Logger.getLogger(PubSubComponentClustered.class.getCanonicalName());
    private static final String b = "packet-forward-pubsub-cmd";
    private static final String c = "perm";
    private static final String d = PartitionedStrategy.class.getCanonicalName();
    private static final String e = "pubsub-strategy-class";
    private ClusterControllerIfc f;
    @Inject(nullAllowed=true)
    private List<ClusterNodesAware> clusterNodesAware = Collections.emptyList();
    private ComponentInfo g = null;
    @Inject
    private List<CommandListener> commandListeners;
    private long h = 0L;
    private long i = 0L;
    private long j = 0L;
    private long k = 0L;
    private long l = 0L;
    private long m = 0L;
    private long n = 0L;
    private LicenceChecker o;
    private long p = 0L;
    private long q = 0L;
    private long r = 0L;
    private long s = 0L;
    private long t = 0L;
    private long u = 0L;
    private long v = 0L;
    @Inject
    private PacketForwardCommand packetForwardCmd;
    @Inject
    private IPubSubRepositoryClustered pubSubRepository;
    @Inject
    private StrategyIfc strategy;

    public synchronized void everyHour() {
        super.everyHour();
        this.s = this.v - this.p;
        this.p = this.v;
        this.k = this.n - this.h;
        this.h = this.n;
    }

    public synchronized void everyMinute() {
        super.everyMinute();
        this.t = this.v - this.q;
        this.q = this.v;
        this.l = this.n - this.i;
        this.i = this.n;
    }

    public synchronized void everySecond() {
        super.everySecond();
        this.u = this.v - this.r;
        this.r = this.v;
        this.m = this.n - this.j;
        this.j = this.n;
    }

    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add(this.getName(), "Locally processed packets last hour", this.s, Level.FINE);
        list.add(this.getName(), "Locally processed packets last minute", this.t, Level.FINE);
        list.add(this.getName(), "Locally processed packets last second", this.u, Level.FINE);
        list.add(this.getName(), "Forwarded packets last hour", this.k, Level.FINE);
        list.add(this.getName(), "Forwarded packets last minute", this.l, Level.FINE);
        list.add(this.getName(), "Forwarded packets last second", this.m, Level.FINE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processPacket(Packet packet) {
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Received packet: {0}", packet);
        }
        try {
            Serializable serializable;
            List<JID> list = this.strategy.getNodesForPacket(packet);
            boolean bl = list.contains(this.strategy.getLocalNodeJid());
            if (a.isLoggable(Level.FINEST)) {
                serializable = new StringBuilder();
                for (JID jID : list) {
                    if (((StringBuilder)serializable).length() > 0) {
                        ((StringBuilder)serializable).append(", ");
                    }
                    ((StringBuilder)serializable).append(jID.toString());
                }
                a.log(Level.FINEST, "packet, processLocally: {0}, will be processed by nodes: [{1}]", new Object[]{bl, ((StringBuilder)serializable).toString()});
            }
            if (bl) {
                if (list.size() == 1) {
                    list = null;
                } else {
                    list = new ArrayList<JID>(list);
                    list.remove(this.strategy.getLocalNodeJid());
                }
            }
            if (list != null) {
                serializable = new HashMap();
                if (packet.getPermissions() != null) {
                    serializable.put(c, packet.getPermissions().name());
                }
                this.f.sendToNodes(b, (Map)((Object)serializable), packet.getElement(), bl ? this.strategy.getLocalNodeJid() : packet.getPacketFrom(), null, list.toArray(new JID[list.size()]));
                ++this.n;
            }
            if (bl) {
                super.processPacket(packet);
                this.pubSubRepository.clearRemoteNodes();
                this.strategy.packetProcessed();
                ++this.v;
            }
        }
        catch (PubSubException pubSubException) {
            ((StanzaProcessor)this.kernel.getInstance(StanzaProcessor.class)).sendException(packet, (ComponentException)pubSubException);
        }
        finally {
            this.strategy.packetProcessed();
        }
    }

    public void register(Kernel kernel) {
        if (!ServerBeanSelector.getClusterMode((Kernel)kernel)) {
            TigaseRuntime.getTigaseRuntime().shutdownTigase(new String[]{"You've tried using Clustered version of the component but cluster-mode is disabled", "Shutting down system!"});
        }
        super.register(kernel);
    }

    public ComponentInfo getComponentInfo() {
        this.g = super.getComponentInfo();
        this.g.getComponentData().put("PubSubClusteringStrategy", this.strategy != null ? this.strategy.getClass() : null);
        return this.g;
    }

    public String getDiscoDescription() {
        return super.getDiscoDescription() + " acs-clustered";
    }

    public void setClusterController(ClusterControllerIfc cl_controller) {
        super.setClusterController(cl_controller);
        if (this.f != null && this.commandListeners != null) {
            for (CommandListener commandListener : this.commandListeners) {
                this.f.removeCommandListener(commandListener);
            }
        }
        this.f = cl_controller;
        if (this.f != null && this.commandListeners != null) {
            for (CommandListener commandListener : this.commandListeners) {
                this.f.setCommandListener(commandListener);
            }
        }
        if (this.strategy != null) {
            this.strategy.setClusterController(cl_controller);
        }
        this.kernel.registerBean("clusterController").asInstance((Object)cl_controller).exec();
    }

    public void setCommandListeners(List<CommandListener> commandListeners) {
        if (this.f != null && this.commandListeners != null) {
            for (CommandListener commandListener : commandListeners) {
                this.f.removeCommandListener(commandListener);
            }
        }
        this.commandListeners = commandListeners;
        if (this.f != null && commandListeners != null) {
            for (CommandListener commandListener : commandListeners) {
                this.f.setCommandListener(commandListener);
            }
        }
    }

    public void setStrategy(StrategyIfc strategy) {
        if (this.strategy != null) {
            strategy.setClusterController(null);
        }
        this.strategy = strategy;
        if (this.strategy != null) {
            this.strategy.setClusterController(this.f);
        }
    }

    public void setClusterNodesAware(List<ClusterNodesAware> clusterNodesAware) {
        if (clusterNodesAware == null) {
            clusterNodesAware = Collections.emptyList();
        }
        this.clusterNodesAware = clusterNodesAware;
    }

    public void initialize() {
        super.initialize();
        this.o = LicenceChecker.getLicenceChecker((String)"acs");
    }

    protected boolean addOutPacket(Packet packet) {
        if (!this.strategy.filterOutPacket(packet)) {
            return super.addOutPacket(packet);
        }
        return false;
    }

    protected void onNodeConnected(JID jid) {
        super.onNodeConnected(jid);
        this.strategy.nodeConnected(jid);
        this.clusterNodesAware.forEach(clusterNodesAware -> clusterNodesAware.nodeConnected(jid));
    }

    protected void onNodeDisconnected(JID jid) {
        super.onNodeDisconnected(jid);
        this.strategy.nodeDisconnected(jid);
        this.clusterNodesAware.forEach(clusterNodesAware -> clusterNodesAware.nodeDisconnected(jid));
    }

    protected void registerModules(Kernel kernel) {
        super.registerModules(kernel);
        kernel.registerBean(PresenceCollectorModuleClustered.class).exec();
    }

    @Bean(name="packetForwardCmd", parent=PubSubComponentClustered.class, active=true)
    public static class PacketForwardCommand
    extends CommandListenerAbstract {
        @Inject(bean="service")
        private PubSubComponentClustered pubSubComponent;

        public PacketForwardCommand() {
            super(PubSubComponentClustered.b, Priority.HIGH);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            for (Element element : packets) {
                try {
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "processing forwarded packet = {0}", element.toString());
                    }
                    Packet packet = Packet.packetInstance((Element)element);
                    packet.setPacketFrom(fromNode);
                    if (data != null && data.get(PubSubComponentClustered.c) != null) {
                        Permissions permissions = Permissions.valueOf((String)data.get(PubSubComponentClustered.c));
                        packet.setPermissions(permissions);
                    }
                    if (this.pubSubComponent.addPacketNB(packet)) {
                        if (!a.isLoggable(Level.FINEST)) continue;
                        a.log(Level.FINEST, "forwarded packet added to processing queue of component = {0}", element.toString());
                        continue;
                    }
                    a.log(Level.FINE, "forwarded packet dropped due to component queue overflow = {0}", element.toString());
                }
                catch (TigaseStringprepException tigaseStringprepException) {
                    a.log(Level.FINEST, "Addressing problem, stringprep failed for packet: {0}", element);
                }
                catch (Throwable throwable) {
                    a.log(Level.SEVERE, "Exception processing forwarded packet = " + element.toString(), throwable);
                }
            }
        }
    }
}

