/*
 * Decompiled with CFR 0.152.
 */
package tigase.licence;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import tigase.licence.InstallationIdRetriever;
import tigase.licence.Licence;
import tigase.licence.LicenceCheckDailyTask;
import tigase.licence.LicenceCheckerUpdateCallback;
import tigase.licence.LicenceCheckerUpdateCallbackImpl;
import tigase.licence.LicenceCheckerUpdater;
import tigase.licence.LicenceLoader;
import tigase.licence.LicenceLoaderFactory;
import tigase.licence.LicenceRetriever;
import tigase.licence.b;
import tigase.licence.utils.VHostsRetriever;
import tigase.util.Base64;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.jid.JID;

public class LicenceChecker {
    public static final String INSTALLATION_ID_KEY = "installation-id";
    private static final Map<String, LicenceChecker> b = new ConcurrentHashMap<String, LicenceChecker>(5);
    private static final Logger c = Logger.getLogger("tigase.licence");
    private static final ScheduledExecutorService d = Executors.newSingleThreadScheduledExecutor();
    private static final String e = "statistics-log-level";
    private static final String f = "licence-library-test-mode";
    static String a = null;
    private static long g = (long)(ThreadLocalRandom.current().nextDouble(1.0, 16.0) * 60.0);
    private static LicenceCheckDailyTask h;
    private static long i;
    private static boolean j;
    private final File k;
    private final String l;
    private final SimpleDateFormat m = new SimpleDateFormat("yyyy-MM-dd'T'HHmm");
    private Licence n;
    private boolean o = false;
    private LicenceCheckerUpdateCallback p;
    private Date q;

    public static String getCodeForLicenceRetrieval(String component) throws Exception {
        if (LicenceCheckerUpdater.getStats() == null) {
            LicenceCheckerUpdater.init();
        }
        List<JID> list = VHostsRetriever.getManagedVHosts();
        LicenceRetriever licenceRetriever = new LicenceRetriever();
        Optional<Map<String, String>> optional = LicenceChecker.getLicenceChecker(component).d().getServerVerifiableMetrics();
        String string = licenceRetriever.a(a, component, list, optional.orElse(Collections.emptyMap()));
        return Base64.encode((byte[])string.getBytes("UTF-8"));
    }

    static String a(boolean bl) {
        if (bl && a == null) {
            a = InstallationIdRetriever.a().b();
        }
        return a;
    }

    public static String getInstallationId() {
        return LicenceChecker.a(false);
    }

    public static LicenceChecker getLicenceChecker(String cmpName) {
        return LicenceChecker.getLicenceChecker(cmpName, null);
    }

    public static LicenceChecker getLicenceChecker(String cmpName, LicenceCheckerUpdateCallback call) {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        String string = Arrays.stream(stackTraceElementArray).skip(1L).limit(5L).map(stackTraceElement -> stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName()).collect(Collectors.joining(" > "));
        c.log(Level.FINEST, "Getting logger for: {0} (from: {1}), callback: {2}, exists: {3}", new Object[]{cmpName, string, call, b.get(cmpName)});
        LicenceChecker licenceChecker = b.get(cmpName);
        if (licenceChecker == null) {
            if (call == null) {
                call = new LicenceCheckerUpdateCallbackImpl(cmpName);
            }
            licenceChecker = new LicenceChecker(cmpName, call);
            b.put(cmpName, licenceChecker);
        } else if (call != null) {
            licenceChecker.a(call);
        }
        return licenceChecker;
    }

    public static Set<String> getLicencedComponents() {
        return Collections.unmodifiableSet(b.keySet());
    }

    public static Element getLicencingDetails(String component) {
        Element element = new Element("licence-details");
        element.addChild((XMLNodeIfc)new Element(INSTALLATION_ID_KEY, LicenceChecker.a(true)));
        element.addChild((XMLNodeIfc)new Element("module", component));
        List<JID> list = VHostsRetriever.getManagedVHosts();
        if (list != null && !list.isEmpty()) {
            element.addChild((XMLNodeIfc)new Element("vhosts", list.stream().map(Object::toString).collect(Collectors.joining(","))));
        }
        return element;
    }

    static boolean a() {
        if (System.getProperty(f) != null && Boolean.valueOf(System.getProperty(f)).booleanValue()) {
            c.log(Level.WARNING, "Licence library running in demo mode (faster checks!)");
            g = 60L;
            i = TimeUnit.MINUTES.toSeconds(3L);
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        System.setProperty(f, "true");
        LicenceChecker.getLicenceChecker("acs");
    }

    private LicenceChecker(String cmpName, LicenceCheckerUpdateCallback call) {
        String string = System.getProperty(f);
        if (null != string && Boolean.valueOf(string).booleanValue()) {
            c.log(Level.WARNING, "Licence library running in demo mode (faster checks!)");
            j = true;
            g = 60L;
            i = TimeUnit.MINUTES.toSeconds(15L);
        }
        string = System.getProperty(e);
        Level level = Level.ALL;
        if (null != string) {
            level = Level.parse(string);
        }
        this.a(level);
        this.p = call;
        this.l = cmpName;
        if (h == null) {
            h = new LicenceCheckDailyTask(b);
            c.log(Level.FINEST, "initialCheckDelay: {0}, subsequentCheckDelay: {1}", new Object[]{g, i});
            d.scheduleAtFixedRate(h, g, i, TimeUnit.SECONDS);
        }
        c.log(Level.CONFIG, "Created licence checker for {0}", cmpName);
        this.k = new File("etc/" + this.l + ".licence");
    }

    public boolean isLicenceShown() {
        return this.o;
    }

    public Licence reloadLicenceFromServer() throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        return this.c(true);
    }

    public String getComponentName() {
        return this.l;
    }

    public String getLicenceDigest() {
        if (this.n != null) {
            return this.n.getLicenceDigest();
        }
        return null;
    }

    public Date getValidUntil() {
        return this.q;
    }

    public void setLicenceShown() {
        this.o = true;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("LicenceChecker{");
        stringBuilder.append("LICENCE_FILE=").append(this.k);
        stringBuilder.append(", componentName='").append(this.l).append('\'');
        stringBuilder.append(", initialCheckDelay=").append(g);
        stringBuilder.append(", subsequentCheckDelay=").append(i);
        stringBuilder.append(", updateCall=").append(this.p);
        stringBuilder.append(", lic=").append(this.n);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    boolean b() {
        return this.b(false);
    }

    boolean b(boolean bl) {
        try {
            this.n = this.c(bl);
            if (this.n == null) {
                c.log(Level.WARNING, "Missing licence file ({0})!", new Object[]{this.k});
                if (!bl && !this.isLicenceShown()) {
                    c.log(Level.WARNING, this.d().getMissingLicenseWarning());
                    this.setLicenceShown();
                }
                return false;
            }
            this.q = this.n.getPropertyAsDate("valid-until");
            try {
                switch (this.n.check()) {
                    case invalidDates: {
                        c.log(Level.WARNING, "Licence expired.");
                        return false;
                    }
                    case invalidVHosts: {
                        c.log(Level.WARNING, "VHost list does not match.");
                        return false;
                    }
                    case invalidSignature: {
                        c.log(Level.WARNING, "Licence file has been tempered with!");
                        return false;
                    }
                    case valid: {
                        c.log(Level.INFO, "Licence OK");
                    }
                }
            }
            catch (Exception exception) {
                c.log(Level.WARNING, "Licence invalid", exception);
                return false;
            }
            String string = this.n.getPropertyAsString("app-id");
            if (string == null || !string.equals(this.l)) {
                c.log(Level.WARNING, "This is not licence for {0} Component!", this.l);
                return false;
            }
        }
        catch (Exception exception) {
            c.log(Level.WARNING, "Can't load licence file. Error: {0}", new Object[]{exception.getMessage()});
            return false;
        }
        return true;
    }

    Licence c() {
        return this.n;
    }

    LicenceCheckerUpdateCallback d() {
        return this.p;
    }

    private void a(LicenceCheckerUpdateCallback licenceCheckerUpdateCallback) {
        this.p = licenceCheckerUpdateCallback;
    }

    private Licence a(LicenceLoader licenceLoader) {
        LicenceRetriever licenceRetriever = new LicenceRetriever();
        String string = licenceRetriever.a(this.l);
        if (c.isLoggable(Level.FINEST)) {
            c.log(Level.FINEST, "Loading licence for component: {0} from server, licenceData: {1}", new Object[]{this.l, string});
        }
        if (string == null || string.isEmpty()) {
            c.info("Cannot load licence from Server.");
            return null;
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
            Licence licence = licenceLoader.loadLicence(byteArrayInputStream);
            byteArrayInputStream.close();
            return licence;
        }
        catch (Exception exception) {
            c.log(Level.WARNING, "Cannot parse licence data.", exception);
            return null;
        }
    }

    private Licence b(LicenceLoader licenceLoader) {
        Licence licence = this.a(licenceLoader);
        if (licence != null && licence instanceof b) {
            try {
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.k), Charset.forName("UTF-8").newEncoder());
                ((b)licence).a(outputStreamWriter);
                ((Writer)outputStreamWriter).close();
            }
            catch (Exception exception) {
                c.log(Level.WARNING, "Cannot store licence in file " + this.k, exception);
            }
        }
        return licence;
    }

    private Licence c(boolean bl) throws NoSuchAlgorithmException, IOException, InvalidKeySpecException {
        Licence licence;
        LicenceLoader licenceLoader = LicenceLoaderFactory.create();
        if (c.isLoggable(Level.FINEST)) {
            c.log(Level.FINEST, "Trying to load licence file from file: {0} (exists: {1}, empty: {2}), forcing load from server: {3}", new Object[]{this.k, this.k.exists(), this.k.length() == 0L, bl});
        }
        if (bl && (licence = this.b(licenceLoader)) != null) {
            this.n = licence;
            return licence;
        }
        if (!this.k.exists() || this.k.length() == 0L) {
            c.log(Level.INFO, "Missing licence file ({0}), retrieving from the server!", new Object[]{this.k});
            if (!bl) {
                return this.b(licenceLoader);
            }
            return null;
        }
        licence = licenceLoader.loadLicence(this.k);
        try {
            Licence licence2;
            Date date = licence.getPropertyAsDate("valid-until");
            if (date != null && System.currentTimeMillis() > date.getTime() - 172800000L && (licence2 = this.b(licenceLoader)) != null) {
                licence = licence2;
            }
            if (licence.getPropertyAsString(INSTALLATION_ID_KEY) == null) {
                c.log(Level.FINEST, "Legacy Licence! Force reload from server!");
                licence2 = this.b(licenceLoader);
                if (licence2 != null) {
                    c.log(Level.FINEST, "Loaded new licence from server: " + licence2);
                    licence = licence2;
                }
            }
        }
        catch (ParseException parseException) {
            c.log(Level.WARNING, "Ouch! We can't load new licence from server! ", this.k);
        }
        return licence;
    }

    private void a(Level level) throws SecurityException {
        Logger logger = Logger.getLogger("tigase.stats.collector");
        c.setLevel(level);
        logger.setLevel(level);
        try {
            FileHandler fileHandler = new FileHandler("logs/statistics.log", 10000000, 5, true);
            fileHandler.setLevel(level);
            logger.addHandler(fileHandler);
            c.addHandler(fileHandler);
        }
        catch (IOException iOException) {
            c.log(Level.CONFIG, this.l);
        }
    }

    static {
        i = TimeUnit.DAYS.toSeconds(1L);
        j = false;
    }
}

