/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster.commands;

import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.component.exceptions.RepositoryException;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.pubsub.Affiliation;
import tigase.pubsub.Subscription;
import tigase.pubsub.cluster.AbstractStrategy;
import tigase.pubsub.cluster.IPubSubRepositoryClustered;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.repository.cached.Node;
import tigase.pubsub.repository.cached.NodeSubscriptions;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

@Bean(name="nodesChangedCmd", parent=AbstractStrategy.class, active=true)
public class NodesChangedCommand
extends CommandListenerAbstract {
    public static final String NODES_CHANGED_CMD = "nodes-changed-cmd";
    public static final String USER_REMOVED = "user-removed";
    public static final String CHILD_NODE_ADDED = "child-node-added";
    public static final String CHILD_NODE_REMOVED = "child-node-removed";
    public static final String ROOT_NODE_ADDED = "root-node-added";
    public static final String ROOT_NODE_REMOVED = "root-node-removed";
    public static final String NODE_CONFIG_CHANGED = "node-config-changed";
    public static final String NODE_AFFILIATION_CHANGED = "node-affiliation-changed";
    public static final String NODE_SUBSCRIPTION_CHANGED = "node-subscription-changed";
    public static final String NODE_ITEM_PUBLISHED = "item-published";
    public static final String NODE_ITEM_RETRACTED = "item-retracted";
    private static final Logger a = Logger.getLogger(NodesChangedCommand.class.getCanonicalName());
    @Inject
    private PublishItemModule publishItemModule;
    @Inject
    private IPubSubRepositoryClustered repo;
    @Inject
    private StrategyIfc strategy;

    public NodesChangedCommand() {
        super(NODES_CHANGED_CMD, Priority.HIGH);
    }

    public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
        Element element;
        block25: while ((element = packets.poll()) != null) {
            try {
                BareJID bareJID = BareJID.bareJIDInstanceNS((String)element.getAttributeStaticStr("service-jid"));
                String string = element.getAttributeStaticStr("node");
                switch (element.getName()) {
                    case "child-node-added": {
                        Node node = this.repo.getNodeFromCache(bareJID, string);
                        if (node != null) {
                            node.childNodeAdded(element.getAttributeStaticStr("child"));
                        }
                        this.repo.nodeAdded(bareJID, string);
                        continue block25;
                    }
                    case "child-node-removed": {
                        Node node = this.repo.getNodeFromCache(bareJID, string);
                        if (node != null) {
                            node.childNodeRemoved(element.getAttributeStaticStr("child"));
                        }
                        this.repo.nodeRemoved(bareJID, string);
                        continue block25;
                    }
                    case "root-node-added": {
                        this.repo.getRootCollectionSet(bareJID).add(string);
                        this.repo.nodeAdded(bareJID, string);
                        continue block25;
                    }
                    case "root-node-removed": {
                        this.repo.getRootCollectionSet(bareJID).remove(string);
                        this.repo.nodeRemoved(bareJID, string);
                        continue block25;
                    }
                    case "node-config-changed": {
                        this.repo.forgetConfiguration(bareJID, string);
                        continue block25;
                    }
                    case "node-affiliation-changed": {
                        Node node = this.repo.getNodeFromCache(bareJID, string);
                        if (node == null) continue block25;
                        BareJID bareJID2 = BareJID.bareJIDInstanceNS((String)element.getAttributeStaticStr("jid"));
                        Affiliation affiliation = Affiliation.valueOf((String)element.getAttributeStaticStr("aff"));
                        Object object = node.getNodeAffiliations();
                        object.changeAffiliation(bareJID2, affiliation);
                        object.merge();
                        continue block25;
                    }
                    case "node-subscription-changed": {
                        Object object;
                        Affiliation affiliation;
                        BareJID bareJID2;
                        Node node = this.repo.getNodeFromCache(bareJID, string);
                        if (node != null) {
                            bareJID2 = BareJID.bareJIDInstanceNS((String)element.getAttributeStaticStr("jid"));
                            affiliation = Subscription.valueOf((String)element.getAttributeStaticStr("sub"));
                            object = element.getAttributeStaticStr("id");
                            NodeSubscriptions nodeSubscriptions = node.getNodeSubscriptions();
                            if (nodeSubscriptions.getSubscriptionId(bareJID2) == null) {
                                nodeSubscriptions.getChanged().put(bareJID2, new UsersSubscription(bareJID2, (String)object, (Subscription)affiliation));
                            }
                            nodeSubscriptions.merge();
                        }
                    }
                    case "item-published": 
                    case "item-retracted": {
                        if (this.strategy.isLocalNode(bareJID, string)) {
                            this.publishItemModule.sendNotifications(bareJID, string, element.getChildren());
                        }
                    }
                    case "user-removed": {
                        this.repo.userRemoved(bareJID);
                        continue block25;
                    }
                }
                a.log(Level.FINER, "received unknown action: {0} as {1}", new Object[]{element.getName(), element});
            }
            catch (RepositoryException repositoryException) {
                a.log(Level.WARNING, "execution of command nodes-changed-cmd for " + element + " failed", repositoryException);
            }
        }
    }
}

