/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.adhoc.AdHocCommand;
import tigase.component.adhoc.AdHocCommandException;
import tigase.component.adhoc.AdHocResponse;
import tigase.component.adhoc.AdhHocRequest;
import tigase.form.Field;
import tigase.form.Form;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.cluster.ClusterNodeMap;
import tigase.xmpp.Authorization;
import tigase.xmpp.jid.JID;

public class ViewNodeLoadCommand
implements AdHocCommand {
    public static final Logger log = Logger.getLogger(ViewNodeLoadCommand.class.getName());
    private final PubSubConfig a;
    private final ClusterNodeMap b;

    public ViewNodeLoadCommand(PubSubConfig config, ClusterNodeMap nodeMap) {
        this.a = config;
        this.b = nodeMap;
    }

    public void execute(AdhHocRequest request, AdHocResponse response) throws AdHocCommandException {
        try {
            if (!this.a.isAdmin(request.getSender())) {
                throw new AdHocCommandException(Authorization.FORBIDDEN);
            }
            Form form = new Form("result", "Cluster nodes load", "Statistics of cluster nodes");
            for (Map.Entry<String, Integer> entry : this.b.getClusterNodesLoad().entrySet()) {
                Field field = Field.fieldTextSingle((String)("tigase#node-" + entry.getKey()), (String)entry.getValue().toString(), (String)entry.getKey());
                form.addField(field);
            }
            response.getElements().add(form.getElement());
            response.completeSession();
        }
        catch (AdHocCommandException adHocCommandException) {
            throw adHocCommandException;
        }
        catch (Exception exception) {
            log.log(Level.FINE, "Error processing vie node load packet", exception);
            throw new AdHocCommandException(Authorization.INTERNAL_SERVER_ERROR, exception.getMessage());
        }
    }

    public String getName() {
        return "View cluster load";
    }

    public String getNode() {
        return "cluster-load";
    }

    public boolean isAllowedFor(JID jid) {
        return Arrays.asList(this.a.getAdmins()).contains(jid.toString());
    }
}

