/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.component.exceptions.ComponentException;
import tigase.eventbus.HandleEvent;
import tigase.kernel.beans.Inject;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.LeafNodeConfig;
import tigase.pubsub.cluster.AbstractStrategy;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.cluster.commands.NodesChangedCommand;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.modules.RetractItemModule;
import tigase.pubsub.repository.NodeSubscriptions;
import tigase.pubsub.repository.stateless.UsersAffiliation;
import tigase.pubsub.repository.stateless.UsersSubscription;
import tigase.server.Packet;
import tigase.sys.TigaseRuntime;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class ClusteredNodeStrategy
extends AbstractStrategy
implements StrategyIfc {
    public static final String[] FORWARD_ELEMENTS = new String[]{"options", "default"};
    private static final Logger a = Logger.getLogger(ClusteredNodeStrategy.class.getCanonicalName());
    private static final String[] b = new String[]{"iq", "pubsub", "publish"};
    protected final ThreadLocal<ArrayDeque<Element>> nodesModifications = ThreadLocal.withInitial(() -> new ArrayDeque());
    private final ThreadLocal<String> c = new ThreadLocal();
    private final Set<String> d = new HashSet<String>(Arrays.asList(FORWARD_ELEMENTS));
    @Inject
    private NodesChangedCommand nodesChangedCommand;

    @Override
    public boolean filterOutPacket(Packet packet) {
        String string;
        if (packet.getElemName() == "iq" && (packet.getType() == StanzaType.result || packet.getType() == StanzaType.error) && (string = this.c.get()) != null) {
            boolean bl;
            String string2 = packet.getAttributeStaticStr("id");
            boolean bl2 = bl = string2 != null && string2.equals(string);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "filtering result: {0}, idToFilter: {1}, for packet: {2}", new Object[]{bl, string, packet});
            }
            return bl;
        }
        return false;
    }

    @Override
    public List<JID> getNodesForPacket(Packet packet) throws PubSubException {
        if (packet.getElemName() == "presence") {
            if (this.pubSubComponent != null && this.pubSubComponent.getName().equals(packet.getPacketFrom().getLocalpart())) {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "Presence packet from pubsub component, returning local node, packet: {0}", new Object[]{packet});
                }
                return Collections.singletonList(this.getLocalNodeJid());
            }
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "Presence packet - other, returning all nodes, packet: {0}", new Object[]{packet});
            }
            return this.getNodesConnectedWithLocal();
        }
        if (packet.getElemName() == "message") {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "Message packet, returning current node, packet: {0}", new Object[]{packet});
            }
            return Collections.singletonList(this.getLocalNodeJid());
        }
        if (packet.getElemName() == "iq") {
            JID jID = packet.getStanzaTo();
            List list = packet.getElemChildrenStaticStr(PUBSUB_PATH);
            Element element = list != null && !list.isEmpty() ? (Element)list.get(0) : null;
            Element element2 = packet.getElement().findChildStaticStr(new String[]{"iq", "command"});
            if (element == null) {
                Element element3;
                if (packet.getType() == StanzaType.result && (element3 = packet.getElement().getChild("query", "http://jabber.org/protocol/disco#info")) != null && element3.getAttributeStaticStr("node") != null) {
                    if (this.pubSubComponent != null && packet.getPacketFrom() != null && this.pubSubComponent.getName().equals(packet.getPacketFrom().getLocalpart())) {
                        if (a.isLoggable(Level.FINEST)) {
                            a.log(Level.FINEST, "IQ packet, forwarded disco#info for CAPS, returning local node, packet: {0}", new Object[]{packet});
                        }
                        return Collections.singletonList(this.getLocalNodeJid());
                    }
                    if (a.isLoggable(Level.FINEST)) {
                        a.log(Level.FINEST, "IQ packet, disco#info for CAPS, returning all nodes, packet: {0}", new Object[]{packet});
                    }
                    return this.getNodesConnectedWithLocal();
                }
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "IQ packet, other, returning current node, packet: {0}", new Object[]{packet});
                }
                return Collections.singletonList(this.getLocalNodeJid());
            }
            String string = element.getAttributeStaticStr("node");
            if (string == null) {
                JID jID2 = this.getNodeForServiceJid(jID);
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "IQ packet, configuration or related to nodes, returning dedicated node, nodeJid: {0}, packet: {1}", new Object[]{jID2, packet});
                }
                return Collections.singletonList(jID2);
            }
            boolean bl = false;
            List list2 = list;
            if (list2 != null) {
                for (Element element4 : list2) {
                    bl |= this.d.contains(element4.getName());
                }
            }
            if ((this.pubSubComponent == null || !this.pubSubComponent.getName().equals(packet.getPacketFrom().getLocalpart())) && bl) {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "IQ packet, forwarding to all nodes, forwardElementsMatch: {0}, packet: {1}", new Object[]{bl, packet});
                }
                return this.getNodesConnectedWithLocal();
            }
            if (bl && packet.getType() != StanzaType.get) {
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "adding packet to filterResponse, id: {0}, filterResponse: {1}", new Object[]{packet.getAttributeStaticStr("id"), this.c});
                }
                this.c.set(packet.getAttributeStaticStr("id"));
            }
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.ALL, "IQ other packet, local node, packet: {0}", packet);
            }
            return Collections.singletonList(this.getLocalNodeJid());
        }
        a.log(Level.SEVERE, "received unknown packet = {0}", packet);
        return null;
    }

    @Override
    public boolean isLocalNode(BareJID serviceJid, String node) {
        return true;
    }

    @Override
    public void nodeAddedToCollection(BareJID serviceJid, String nodeName, String collection) {
        this.nodesModifications.get().offer(new Element("child-node-added", new String[]{"service-jid", "node", "child"}, new String[]{serviceJid.toString(), collection, nodeName}));
    }

    @Override
    public void nodeAddedToRootCollection(BareJID serviceJid, String nodeName) {
        this.nodesModifications.get().offer(new Element("root-node-added", new String[]{"service-jid", "node"}, new String[]{serviceJid.toString(), nodeName}));
    }

    @Override
    public void nodeRemovedFromCollection(BareJID serviceJid, String nodeName, String collection) {
        this.nodesModifications.get().offer(new Element("child-node-removed", new String[]{"service-jid", "node", "child"}, new String[]{serviceJid.toString(), collection, nodeName}));
    }

    @Override
    public void nodeRemovedFromRootCollection(BareJID serviceJid, String nodeName) {
        this.nodesModifications.get().offer(new Element("root-node-removed", new String[]{"service-jid", "node"}, new String[]{serviceJid.toString(), nodeName}));
    }

    @Override
    public void nodeConfigurationChanged(BareJID serviceJid, String nodeName) {
        this.nodesModifications.get().offer(new Element("node-config-changed", new String[]{"service-jid", "node"}, new String[]{serviceJid.toString(), nodeName}));
    }

    @Override
    public void nodeAffiliationsChanged(BareJID serviceJid, String nodeName, Map<BareJID, UsersAffiliation> changedAffiliations) {
        Queue queue = this.nodesModifications.get();
        for (Map.Entry<BareJID, UsersAffiliation> entry : changedAffiliations.entrySet()) {
            queue.offer(new Element("node-affiliation-changed", new String[]{"service-jid", "node", "jid", "aff"}, new String[]{serviceJid.toString(), nodeName, entry.getKey().toString(), entry.getValue().getAffiliation().name()}));
        }
    }

    @Override
    public void nodeSubscriptionsChanged(BareJID serviceJid, String nodeName, Map<BareJID, UsersSubscription> changedSubscriptions) {
        Queue queue = this.nodesModifications.get();
        for (Map.Entry<BareJID, UsersSubscription> entry : changedSubscriptions.entrySet()) {
            UsersSubscription usersSubscription = entry.getValue();
            queue.offer(new Element("node-subscription-changed", new String[]{"service-jid", "node", "jid", "sub", "id"}, new String[]{serviceJid.toString(), nodeName, entry.getKey().toString(), usersSubscription.getSubscription().name(), usersSubscription.getSubid()}));
        }
    }

    public void notifyNodeConfigurationChanges() {
        List<JID> list = this.getNodesConnected();
        Queue queue = this.nodesModifications.get();
        this.nodesModifications.remove();
        Map<String, String> map = this.prepareCommandData(null, null);
        this.cl_controller.sendToNodes("nodes-changed-cmd", map, queue, this.getLocalNodeJid(), null, list.toArray(new JID[list.size()]));
    }

    @HandleEvent
    public void onItemPublishedEvent(PublishItemModule.ItemPublishedEvent event) {
        Element element = new Element("item-published", new String[]{"service_jid", "node"}, new String[]{event.serviceJid.toString(), event.node});
        element.addChildren(event.itemsToSend);
        this.nodesModifications.get().offer(element);
    }

    @HandleEvent
    public void onItemRetractedEvent(RetractItemModule.ItemRetractedEvent event) {
        Element element = new Element("item-retracted", new String[]{"service_jid", "node"}, new String[]{event.serviceJid.toString(), event.node});
        element.addChild((XMLNodeIfc)event.notification);
        this.nodesModifications.get().offer(element);
    }

    @Override
    public boolean sendException(Packet packet, ComponentException ex) {
        if (this.pubSubComponent.getName().equals(packet.getPacketFrom().getLocalpart()) && packet.getElement().findChildStaticStr(b) != null) {
            return false;
        }
        return super.sendException(packet, ex);
    }

    @Override
    public boolean isOnlineLocally(JID jid) {
        TigaseRuntime tigaseRuntime = TigaseRuntime.getTigaseRuntime();
        if (this.pubSubComponent.isLocalDomain(jid.getDomain()) && tigaseRuntime.isJidOnline(jid)) {
            return tigaseRuntime.isJidOnlineLocally(jid);
        }
        return this.a(jid.getBareJID());
    }

    @Override
    public AbstractNodeConfig wrapNodeConfig(BareJID serviceJid, String nodeName, AbstractNodeConfig config) {
        if (config instanceof LeafNodeConfig && this.c.get() != null) {
            config.setValue("pubsub#persist_items", false);
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "forcing item to ignore persistence setting for node {0} on request {1} as item it will be saved by other cluster node", new Object[]{nodeName, this.c.get()});
            }
        } else if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Not wrapping nodeConfig, filterResponse: {0}", this.c.get());
        }
        return config;
    }

    @Override
    public tigase.pubsub.repository.cached.NodeSubscriptions wrapNodeSubscriptions(NodeSubscriptions nodeSubscriptions) {
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "wrapNodeSubscriptions[1], nodeSubscriptions: {0}", nodeSubscriptions);
        }
        return new tigase.pubsub.repository.cached.NodeSubscriptions(nodeSubscriptions){

            public UsersSubscription[] getSubscriptionsForPublish() {
                UsersSubscription[] usersSubscriptionArray = super.getSubscriptionsForPublish();
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "wrapNodeSubscriptions[2], nodeSubscriptions(this): {0}, allSubs: {1}", new Object[]{this, Arrays.asList(usersSubscriptionArray)});
                }
                if (usersSubscriptionArray == null || usersSubscriptionArray.length == 0) {
                    return usersSubscriptionArray;
                }
                TigaseRuntime tigaseRuntime = TigaseRuntime.getTigaseRuntime();
                ArrayList<UsersSubscription> arrayList = new ArrayList<UsersSubscription>();
                for (int i = 0; i < usersSubscriptionArray.length; ++i) {
                    UsersSubscription usersSubscription = usersSubscriptionArray[i];
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.log(Level.FINEST, "procesing sub: {0}, isLocalDomain: {1}, jidOnline: {2}, onlineLocally: {3}, handleLocally: {4} ", new Object[]{usersSubscription, ClusteredNodeStrategy.this.pubSubComponent.isLocalDomain(usersSubscription.getJid().getDomain()), tigaseRuntime.isJidOnline(JID.jidInstance((BareJID)usersSubscription.getJid())), tigaseRuntime.isJidOnlineLocally(usersSubscription.getJid()), ClusteredNodeStrategy.this.a(usersSubscription.getJid())});
                    }
                    if (ClusteredNodeStrategy.this.pubSubComponent.isLocalDomain(usersSubscription.getJid().getDomain()) && tigaseRuntime.isJidOnline(JID.jidInstance((BareJID)usersSubscription.getJid()))) {
                        if (!tigaseRuntime.isJidOnlineLocally(usersSubscription.getJid())) continue;
                        arrayList.add(usersSubscription);
                        continue;
                    }
                    if (!ClusteredNodeStrategy.this.a(usersSubscription.getJid())) continue;
                    arrayList.add(usersSubscription);
                }
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.log(Level.FINEST, "wrapNodeSubscriptions[3], subs: {0}", arrayList);
                }
                return arrayList.toArray(new UsersSubscription[arrayList.size()]);
            }
        };
    }

    @Override
    public void packetProcessed() {
        this.c.remove();
        if (!this.nodesModifications.get().isEmpty()) {
            this.notifyNodeConfigurationChanges();
        }
        super.packetProcessed();
    }

    @Override
    public void userRemoved(BareJID serviceJid) {
        this.nodesModifications.get().offer(new Element("user-removed", new String[]{"service-jid"}, new String[]{serviceJid.toString()}));
    }

    private boolean a(BareJID bareJID) {
        JID jID = this.getNodeForHashCode(bareJID.hashCode());
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "NodeJIDhandleLocally, jid: {0}, nodeJid: {1}", new Object[]{bareJID, jID});
        }
        return this.localNodeJid.equals((Object)jID);
    }
}

