/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.pubsub.cluster.AbstractStrategy;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.server.Packet;
import tigase.util.TimerTask;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class PartitionedStrategy
extends AbstractStrategy
implements StrategyIfc {
    private static final Logger a = Logger.getLogger(PartitionedStrategy.class.getCanonicalName());
    private AbstractStrategy.NodeConfigRefreshCommand b = new AbstractStrategy.NodeConfigRefreshCommand();
    private long c = 60000L;
    private final ConcurrentMap<BareJID, TimerTask> d = new ConcurrentHashMap<BareJID, TimerTask>();

    @Override
    public boolean filterOutPacket(Packet packet) {
        return false;
    }

    public JID getNodeForServiceNode(JID serviceJid, String node) {
        int n = Math.abs((391 + serviceJid.hashCode()) * 23 + node.hashCode());
        return this.getNodeForHashCode(n);
    }

    @Override
    public List<JID> getNodesForPacket(Packet packet) {
        if (packet.getElemName() == "presence") {
            if (this.pubSubComponent != null && this.pubSubComponent.getName().equals(packet.getPacketFrom().getLocalpart())) {
                return Collections.singletonList(this.getLocalNodeJid());
            }
            return this.getAllNodes();
        }
        if (packet.getElemName() == "message") {
            return Collections.singletonList(this.getLocalNodeJid());
        }
        if (packet.getElemName() == "iq") {
            Element element;
            JID jID = packet.getStanzaTo();
            List list = packet.getElemChildrenStaticStr(PUBSUB_PATH);
            Element element2 = element = list != null && !list.isEmpty() ? (Element)list.get(0) : null;
            if (element == null) {
                return Collections.singletonList(this.getLocalNodeJid());
            }
            String string = element.getAttributeStaticStr("node");
            if (string == null || this.isNodeConfigure(element)) {
                JID jID2 = this.getNodeForServiceJid(jID);
                return Collections.singletonList(jID2);
            }
            JID jID3 = this.getNodeForServiceNode(jID, string);
            return Collections.singletonList(jID3);
        }
        a.log(Level.SEVERE, "received unknown packet = {0}", packet);
        return null;
    }

    @Override
    public boolean isLocalNode(BareJID serviceJid, String node) {
        return this.getLocalNodeJid().equals((Object)this.getNodeForServiceNode(JID.jidInstance((BareJID)serviceJid), node));
    }

    @Override
    public boolean isOnlineLocally(JID jid) {
        return true;
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        if (this.cl_controller != null) {
            this.cl_controller.removeCommandListener((CommandListener)this.b);
        }
        super.setClusterController(cl_controller);
        this.cl_controller.setCommandListener((CommandListener)this.b);
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        if (props.containsKey("refresh-cmd-delay")) {
            this.c = (Long)props.get("refresh-cmd-delay");
        }
    }

    @Override
    public void nodeConfigurationChanged(final BareJID serviceJid, final String nodeName) {
        JID jID;
        JID jID2 = jID = nodeName == null ? this.getNodeForServiceJid(JID.jidInstance((BareJID)serviceJid)) : this.getNodeForServiceNode(JID.jidInstance((BareJID)serviceJid), nodeName);
        if (this.getLocalNodeJid().equals((Object)jID)) {
            return;
        }
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "notifying cluster node {0} that node {1} changed configuration", new Object[]{jID, nodeName});
        }
        if (nodeName == null) {
            TimerTask timerTask;
            TimerTask timerTask2;
            if (!this.d.containsKey(serviceJid) && (timerTask2 = this.d.putIfAbsent(serviceJid, timerTask = new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        Map<String, String> map = PartitionedStrategy.this.prepareCommandData(serviceJid, nodeName);
                        PartitionedStrategy.this.cl_controller.sendToNodes("node-config-refresh-pubsub-cmd", map, PartitionedStrategy.this.getLocalNodeJid(), new JID[]{jID});
                    }
                    finally {
                        PartitionedStrategy.this.d.remove(serviceJid, (Object)this);
                    }
                }
            })) == null) {
                this.pubSubComponent.addTimerTask(timerTask, this.c);
            }
        } else {
            Map<String, String> map = this.prepareCommandData(serviceJid, nodeName);
            this.cl_controller.sendToNodes("node-config-refresh-pubsub-cmd", map, this.getLocalNodeJid(), new JID[]{jID});
        }
    }
}

