/*
 * Decompiled with CFR 0.152.
 */
package tigase.http.rest;

import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.http.AbstractModule;
import tigase.http.DeploymentInfo;
import tigase.http.HttpServer;
import tigase.http.ServletInfo;
import tigase.http.rest.ReloadHandlersCmd;
import tigase.http.rest.RestExtServlet;
import tigase.http.rest.RestServlet;
import tigase.http.rest.ServiceImpl;
import tigase.http.util.StaticFileServlet;

public class RestModule
extends AbstractModule {
    private static final Logger log = Logger.getLogger(RestModule.class.getCanonicalName());
    private static final String DEF_SCRIPTS_DIR_VAL = "scripts/rest";
    private static final String SCRIPTS_DIR_KEY = "rest-scripts-dir";
    private static final String NAME = "rest";
    private final ReloadHandlersCmd reloadHandlersCmd = new ReloadHandlersCmd(this);
    private String contextPath = null;
    private HttpServer httpServer = null;
    private DeploymentInfo httpDeployment = null;
    private String scriptsDir = "scripts/rest";
    private String[] vhosts = null;
    private final String uuid = UUID.randomUUID().toString();
    private static final ConcurrentHashMap<String, RestModule> modules = new ConcurrentHashMap();

    public static RestModule getModuleByUUID(String uuid) {
        return modules.get(uuid);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getDescription() {
        return "REST support - handles HTTP REST access using scripts";
    }

    @Override
    public void start() {
        File scriptsDirFile;
        File[] scriptDirFiles;
        if (this.httpDeployment != null) {
            this.stop();
        }
        modules.put(this.uuid, this);
        super.start();
        this.httpDeployment = HttpServer.deployment().setClassLoader(this.getClass().getClassLoader()).setContextPath(this.contextPath).setService(new ServiceImpl(this));
        if (this.vhosts != null) {
            this.httpDeployment.setVHosts(this.vhosts);
        }
        if ((scriptDirFiles = (scriptsDirFile = new File(this.scriptsDir)).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !"static".equals(file.getName());
            }
        })) != null) {
            File[] fileArray = scriptDirFiles;
            int n = scriptDirFiles.length;
            int n2 = 0;
            while (n2 < n) {
                File dirFile = fileArray[n2];
                try {
                    this.startRestServletForDirectory(this.httpDeployment, dirFile);
                }
                catch (IOException ex) {
                    log.log(Level.FINE, "Exception while scanning for scripts to load", ex);
                }
                ++n2;
            }
        }
        ServletInfo servletInfo = HttpServer.servlet("StaticServlet", StaticFileServlet.class);
        servletInfo.addInitParam("directory", new File(scriptsDirFile, "static").getAbsolutePath()).addMapping("/static/*");
        this.httpDeployment.addServlets(servletInfo);
        this.httpServer.deploy(this.httpDeployment);
    }

    @Override
    public void stop() {
        if (this.httpDeployment != null) {
            this.httpServer.undeploy(this.httpDeployment);
            this.httpDeployment = null;
            modules.remove(this.uuid, this);
        }
        super.stop();
    }

    @Override
    public Map<String, Object> getDefaults() {
        Map<String, Object> props = super.getDefaults();
        props.put("context-path", "/" + this.getName());
        props.put(SCRIPTS_DIR_KEY, DEF_SCRIPTS_DIR_VAL);
        return props;
    }

    @Override
    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        if (props.containsKey("context-path")) {
            this.contextPath = (String)props.get("context-path");
        }
        if (props.containsKey("http-server")) {
            this.httpServer = (HttpServer)props.get("http-server");
        }
        if (props.containsKey(SCRIPTS_DIR_KEY)) {
            this.scriptsDir = (String)props.get(SCRIPTS_DIR_KEY);
        }
        this.vhosts = (String[])props.get("vhosts");
        this.commandManager.registerCmd(this.reloadHandlersCmd);
    }

    private void startRestServletForDirectory(DeploymentInfo httpDeployment, File scriptsDirFile) throws IOException {
        File[] scriptFiles = RestModule.getGroovyFiles(scriptsDirFile);
        if (scriptFiles != null) {
            ServletInfo servletInfo = HttpServer.servlet("RestServlet", RestExtServlet.class);
            servletInfo.addInitParam(RestServlet.REST_MODULE_KEY, this.uuid).addInitParam(RestServlet.SCRIPTS_DIR_KEY, scriptsDirFile.getCanonicalPath()).addMapping("/" + scriptsDirFile.getName() + "/*");
            httpDeployment.addServlets(servletInfo);
        }
    }

    public static File[] getGroovyFiles(File scriptsDirFile) {
        return scriptsDirFile.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String s) {
                return s.endsWith("groovy");
            }
        });
    }
}

