/*
 * Decompiled with CFR 0.152.
 */
package tigase.socks5;

import java.io.IOException;
import java.net.ProtocolException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.net.IOService;
import tigase.net.SocketThread;
import tigase.socks5.Socks5ConnectionManager;
import tigase.socks5.Socks5ConnectionType;
import tigase.socks5.Stream;
import tigase.xmpp.JID;

public class Socks5IOService<RefObject>
extends IOService<RefObject> {
    private static final Logger log = Logger.getLogger(Socks5IOService.class.getCanonicalName());
    private State state = State.Welcome;
    private Stream stream;
    private Socks5ConnectionType connectionType;
    private Socks5ConnectionManager manager;
    private ByteBuffer buf = null;
    private int bytesReceived = 0;
    private int bytesSent = 0;

    public boolean activate() {
        this.state = State.Active;
        return true;
    }

    public void setConnectionManager(Socks5ConnectionManager manager) {
        this.manager = manager;
    }

    public void setStream(Stream stream) {
        this.stream = stream;
    }

    public JID getJID() {
        if (this.stream == null) {
            return null;
        }
        return this.connectionType == Socks5ConnectionType.Requester ? this.stream.getRequester() : this.stream.getTarget();
    }

    public State getState() {
        return this.state;
    }

    public void setSocks5ConnectionType(Socks5ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public Socks5ConnectionType getSocks5ConnectionType() {
        return this.connectionType;
    }

    public int getBytesReceived() {
        return this.bytesReceived;
    }

    public int getBytesSent() {
        return this.bytesSent;
    }

    public void processWaitingPackets() throws IOException {
    }

    public boolean waitingToRead() {
        return super.isInputBufferEmpty();
    }

    public IOService<?> call() throws IOException {
        Socks5IOService secondServ;
        IOService serv = super.call();
        if (this.isConnected() && !this.waitingToSend() && this.stream != null && (secondServ = this.stream.getSecondConnection(this)) != null) {
            secondServ.clearBuffer();
            SocketThread.addSocketService((IOService)secondServ);
        }
        return serv;
    }

    protected ByteBuffer readBytes() throws IOException {
        this.buf = super.readBytes();
        if (this.buf != null) {
            this.bytesReceived += this.buf.remaining();
        }
        return this.buf;
    }

    public void writeBytes(ByteBuffer buf) {
        if (buf != null) {
            this.bytesSent += buf.remaining();
        }
        super.writeBytes(buf);
    }

    public void clearBuffer() {
        if (this.buf != null && !this.buf.hasRemaining()) {
            this.buf.clear();
        }
    }

    public void forceStop() {
        if (this.state != State.Closed) {
            this.state = State.Closed;
            if (this.stream != null) {
                this.stream.close();
            }
        }
        super.forceStop();
    }

    public int hashCode() {
        return Math.abs(this.stream != null ? this.stream.hashCodeForStream() : super.hashCode());
    }

    protected void processSocketData() throws IOException {
        if (this.state == State.Ready) {
            return;
        }
        if (!this.isConnected()) {
            super.forceStop();
            return;
        }
        ByteBuffer buffer = this.readBytes();
        if (buffer != null && buffer.hasRemaining()) {
            if (this.state != State.Active) {
                ByteBuffer buf = ByteBuffer.allocate(buffer.remaining());
                buf.put(buffer);
                buf.flip();
                try {
                    switch (this.state) {
                        case Welcome: {
                            this.handleWelcome(buf);
                            break;
                        }
                        case Auth: {
                            this.handleCommand(buf);
                            break;
                        }
                    }
                    buffer.clear();
                }
                catch (BufferUnderflowException ex) {
                    buffer.compact();
                }
                return;
            }
            if (this.stream != null) {
                try {
                    this.stream.proxy(buffer, this);
                    if (!buffer.hasRemaining()) {
                        buffer.clear();
                    }
                }
                catch (IOException ex) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, "stopping service after exception " + ex.getMessage(), ex);
                    }
                    this.forceStop();
                }
            }
        }
        this.manager.socketDataProcessed(this);
    }

    protected int receivedPackets() {
        return 0;
    }

    private void handleWelcome(ByteBuffer buf) throws IOException {
        byte ver = buf.get();
        if (ver != 5) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, "stopping service {0} after detecting unsupported protocol", this.toString());
            }
            this.forceStop();
            return;
        }
        int count = buf.get();
        boolean ok = false;
        for (int i = 0; i < count; ++i) {
            if (buf.get() != 0) continue;
            ok = true;
            break;
        }
        buf.clear();
        this.state = State.Auth;
        if (ok) {
            this.writeBytes(ByteBuffer.wrap(new byte[]{ver, 0}));
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "stopping service {0} after failure during WELCOME step", this.toString());
            }
            this.forceStop();
        }
    }

    private void handleCommand(ByteBuffer in) throws IOException {
        byte ver = in.get();
        if (ver != 5) {
            throw new ProtocolException("Bad protocol version");
        }
        byte cmd = in.get();
        in.get();
        byte atype = in.get();
        if (ver == 5 && cmd == 1 && atype == 3) {
            byte len = in.get();
            byte[] data = new byte[len];
            in.get(data);
            in.clear();
            ByteBuffer tmp = ByteBuffer.allocate(len + 7);
            tmp.put(ver);
            tmp.put((byte)0);
            tmp.put((byte)0);
            tmp.put(atype);
            tmp.put(len);
            tmp.put(data);
            tmp.put((byte)0);
            tmp.put((byte)0);
            tmp.flip();
            this.manager.registerStream(new String(data), this);
            this.state = State.Ready;
            this.writeBytes(tmp);
        } else {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "stopping service {0} after failure during AUTHENTICATION step, version = {1}, cmd = {2}, atype = {3}", new Object[]{this.toString(), ver, cmd, atype});
            }
            this.forceStop();
        }
    }

    public static enum State {
        Welcome,
        Auth,
        Ready,
        Active,
        Closed;

    }
}

