/*
 * Decompiled with CFR 0.152.
 */
package tigase.server.cluster.strategy;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.SessionManagerClusteredIfc;
import tigase.cluster.strategy.ClusteringStrategyIfc;
import tigase.cluster.strategy.DefaultClusteringStrategyAbstract;
import tigase.licence.LicenceChecker;
import tigase.licence.LicenceCheckerUpdateCallbackImplACS;
import tigase.server.Packet;
import tigase.server.cluster.strategy.CacheContenerIfc;
import tigase.server.cluster.strategy.CacheContenerV2;
import tigase.server.cluster.strategy.ConnectionRecordExt;
import tigase.server.cluster.strategy.cmd.RequestSyncOnlineCmd;
import tigase.server.cluster.strategy.cmd.RespondSyncOnlineCmd;
import tigase.server.cluster.strategy.cmd.TrafficStatisticsCmd;
import tigase.server.cluster.strategy.cmd.UserConnectedCmd;
import tigase.server.cluster.strategy.cmd.UserDisconnectedCmd;
import tigase.server.cluster.strategy.cmd.UserPresenceCmd;
import tigase.stats.StatisticsList;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;

public class OnlineUsersCachingStrategy
extends DefaultClusteringStrategyAbstract<ConnectionRecordExt> {
    public static final String ONLINE_PRESENCE_CACHE_PROP_KEY = "cluster-strategy-presence-cache";
    public static final String REQUEST_SYNCONLINE_CMD = "req-sync-online-sm-cmd";
    public static final String RESPOND_SYNCONLINE_CMD = "resp-sync-online-sm-cmd";
    public static final String STRATEGY_STATS_CMD = "strategy-statistics";
    public static final String USER_CONNECTED_CMD = "user-connected-sm-cmd";
    public static final String USER_DISCONNECTED_CMD = "user-disconnected-sm-cmd";
    public static final String USER_PRESENCE_CMD = "user-presence-sm-cmd";
    private static final String a = "auth-time";
    private static final String b = "cluster-initial-presence";
    private static final String c = "update";
    private static final String d = "acs";
    private static final Logger e = Logger.getLogger(OnlineUsersCachingStrategy.class.getName());
    private boolean f = false;
    private CacheContenerV2 g = new CacheContenerV2();
    protected static LicenceChecker licenceChecker;

    public OnlineUsersCachingStrategy() {
        this.addCommandListener((CommandListener)new RequestSyncOnlineCmd(REQUEST_SYNCONLINE_CMD, this));
        this.addCommandListener((CommandListener)new RespondSyncOnlineCmd(RESPOND_SYNCONLINE_CMD, this));
        this.addCommandListener((CommandListener)new UserConnectedCmd(USER_CONNECTED_CMD, this));
        this.addCommandListener((CommandListener)new UserDisconnectedCmd(USER_DISCONNECTED_CMD, this));
        this.addCommandListener((CommandListener)new UserPresenceCmd(USER_PRESENCE_CMD, this));
        this.addCommandListener((CommandListener)new TrafficStatisticsCmd(STRATEGY_STATS_CMD, this));
        LicenceCheckerUpdateCallbackImplACS licenceCheckerUpdateCallbackImplACS = new LicenceCheckerUpdateCallbackImplACS(d, (ClusteringStrategyIfc<ConnectionRecordExt>)this);
        licenceChecker = LicenceChecker.getLicenceChecker(d, licenceCheckerUpdateCallbackImplACS);
    }

    public boolean containsJid(BareJID jid) {
        return this.g.containsJid(jid);
    }

    public void handleLocalPacket(Packet packet, XMPPResourceConnection conn) {
        if (packet.getElemName() == "presence") {
            try {
                List<JID> list;
                boolean bl = conn.getSessionData(b) == null;
                Map<String, String> map = this.prepareConnectionParams(conn);
                if (bl) {
                    conn.putSessionData(b, (Object)b);
                    map.put("pres-type", "initial");
                } else {
                    map.put("pres-type", c);
                }
                Element element = conn.getPresence();
                if (element == null) {
                    element = packet.getElement();
                }
                if ((list = this.getNodesForPacketForward(this.sm.getComponentId(), null, Packet.packetInstance((Element)element))) != null && list.size() > 0) {
                    this.cluster.sendToNodes(USER_PRESENCE_CMD, map, element, this.sm.getComponentId(), null, list.toArray(new JID[list.size()]));
                }
            }
            catch (TigaseStringprepException | NoConnectionIdException | NotAuthorizedException throwable) {
                e.log(Level.WARNING, "Problem with broadcast user presence for: " + conn, throwable);
            }
        }
    }

    public void handleLocalUserLogout(BareJID userId, XMPPResourceConnection conn) {
        try {
            Map<String, String> map = this.prepareConnectionParams(conn);
            List<JID> list = this.getNodesForUserDisconnect(conn.getJID());
            this.cluster.sendToNodes(USER_DISCONNECTED_CMD, map, this.sm.getComponentId(), list.toArray(new JID[list.size()]));
        }
        catch (NotAuthorizedException notAuthorizedException) {
            e.log(Level.INFO, "NotAuthorizedException: This should really not happen as it is called for authenticated users, maybe the session was removed in the meantime. BareJID: {0}, conn: {1}", new Object[]{userId, conn});
        }
        catch (NoConnectionIdException noConnectionIdException) {
            e.log(Level.INFO, "NoConnectionIdException: This really should not happen. BareJID: {0}, conn: {1}", new Object[]{userId, conn});
        }
    }

    public void handleLocalResourceBind(XMPPResourceConnection conn) {
        try {
            Map<String, String> map = this.prepareConnectionParams(conn);
            List<JID> list = this.getNodesForUserConnect(conn.getJID());
            this.cluster.sendToNodes(USER_CONNECTED_CMD, map, this.sm.getComponentId(), list.toArray(new JID[list.size()]));
        }
        catch (NoConnectionIdException | NotAuthorizedException throwable) {
            e.log(Level.WARNING, "Problem with broadcast user presence for: " + conn, throwable);
        }
    }

    public void nodeConnected(JID node) {
        super.nodeConnected(node);
        this.requestSync(node);
    }

    public void nodeDisconnected(JID node) {
        super.nodeDisconnected(node);
        this.g.removeAllForNode(node);
    }

    public void presenceUpdate(Element presence, ConnectionRecordExt rec) {
        if (this.f) {
            this.g.updatePresence(presence, rec);
        }
    }

    public String toString() {
        return this.getInfo();
    }

    public void userDisconnected(ConnectionRecordExt rec) {
        this.g.userDisconnected(rec);
    }

    public void usersConnected(ConnectionRecordExt ... recs) {
        this.g.usersConnected(recs);
    }

    public List<JID> getAllNodes() {
        return super.getAllNodes();
    }

    public ClusterControllerIfc getCluster() {
        return this.cluster;
    }

    public JID[] getConnectionIdsForJid(BareJID jid) {
        return this.g.getConnectionIdsForJid(jid);
    }

    public ConnectionRecordExt getConnectionRecord(JID jid) {
        return this.g.getConnectionRecord(jid);
    }

    public ConnectionRecordExt getConnectionRecordInstance() {
        return new ConnectionRecordExt();
    }

    public Set<ConnectionRecordExt> getConnectionRecords(BareJID bareJID) {
        return this.g.getConnectionRecords(bareJID);
    }

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        return super.getDefaults(params);
    }

    public String getInfo() {
        return "acs-online-cache strategy";
    }

    @Deprecated
    public Object getInternalCacheData() {
        return this.g.getInternalData();
    }

    public CacheContenerIfc getCacheContener() {
        return this.g;
    }

    public List<JID> getNodesForPacketForward(JID fromNode, Set<JID> visitedNodes, Packet packet) {
        if (visitedNodes != null) {
            return null;
        }
        List<JID> list = null;
        JID jID = packet.getStanzaTo();
        boolean bl = false;
        if (packet.getElemName() == "presence" && packet.getType() != StanzaType.error && packet.getStanzaFrom() != null && packet.getStanzaTo() == null) {
            bl = true;
            jID = packet.getStanzaFrom();
        }
        if (bl || this.isSuitableForForward(packet)) {
            if (bl && this.f) {
                list = this.getAllNodes();
                if (e.isLoggable(Level.FINEST)) {
                    e.log(Level.FINEST, "Presence update and cachePresences on, selecting all nodes: {0}, for packet: {1}", new Object[]{list, packet});
                }
            } else {
                list = this.g.getNodesForJid(jID);
                if (e.isLoggable(Level.FINEST)) {
                    e.log(Level.FINEST, "Selected nodes: {0}, for packet: {1}", new Object[]{list, packet});
                }
            }
        } else if (e.isLoggable(Level.FINEST)) {
            e.log(Level.FINEST, "Packet not suitable for forwarding: {0}", new Object[]{packet});
        }
        return list;
    }

    public List<JID> getNodesForUserConnect(JID jid) {
        return this.getAllNodes();
    }

    public List<JID> getNodesForUserDisconnect(JID jid) {
        return this.getAllNodes();
    }

    public SessionManagerClusteredIfc getSM() {
        return this.sm;
    }

    public void getStatistics(StatisticsList list) {
        super.getStatistics(list);
        list.add("cl-caching-strat", "Cached JIDs", this.g.connectionsSize(), Level.INFO);
        list.add("cl-caching-strat", "Cached conns", this.g.mapSize(), Level.INFO);
    }

    public boolean hasCompleteJidsInfo() {
        return this.g.hasCompleteJidsInfo();
    }

    public void setProperties(Map<String, Object> props) {
        super.setProperties(props);
        String string = (String)props.get(ONLINE_PRESENCE_CACHE_PROP_KEY);
        if (string != null) {
            this.f = Boolean.parseBoolean(string);
        }
        e.log(Level.CONFIG, "Presence caching is set to: {0}", this.f);
    }

    protected Map<String, String> prepareConnectionParams(XMPPResourceConnection conn) throws NotAuthorizedException, NoConnectionIdException {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("userId", conn.getBareJID().toString());
        linkedHashMap.put("resource", conn.getResource());
        linkedHashMap.put("connId", conn.getConnectionId().toString());
        linkedHashMap.put("xmppSessId", conn.getSessionId());
        linkedHashMap.put(a, "" + conn.getAuthTime());
        linkedHashMap.put("creation-t", "" + conn.getCreationTime());
        linkedHashMap.put("login_t", "" + conn.getAuthTime());
        if (e.isLoggable(Level.FINEST)) {
            e.log(Level.FINEST, "Called for conn: {0}, result: ", new Object[]{conn, linkedHashMap});
        }
        return linkedHashMap;
    }

    protected boolean presenceStatusUpdate(Packet packet) {
        return packet.getElemName() == "presence" && packet.getType() != StanzaType.error && packet.getStanzaFrom() != null && packet.getStanzaTo() == null;
    }

    protected void requestSync(JID node) {
        this.g.setSync(false);
        this.cluster.sendToNodes(REQUEST_SYNCONLINE_CMD, this.sm.getComponentId(), new JID[]{node});
    }
}

