/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import tigase.component2.PacketWriter;
import tigase.component2.eventbus.Event;
import tigase.component2.eventbus.EventHandler;
import tigase.component2.eventbus.EventType;
import tigase.criteria.Criteria;
import tigase.criteria.ElementCriteria;
import tigase.pubsub.AbstractPubSubModule;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.CapsModule;
import tigase.server.Packet;
import tigase.server.Presence;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;
import tigase.xmpp.impl.PresenceCapabilitiesManager;

public class PresenceCollectorModule
extends AbstractPubSubModule {
    private static final Criteria CRIT = ElementCriteria.name((String)"presence");
    private static final String[] EMPTY_CAPS = new String[0];
    private static final ConcurrentMap<String, String[]> CAPS_MAP = new ConcurrentHashMap<String, String[]>();
    private final ConcurrentMap<BareJID, ConcurrentMap<BareJID, Map<String, String[]>>> presenceByService = new ConcurrentHashMap<BareJID, ConcurrentMap<BareJID, Map<String, String[]>>>();
    private final CapsModule capsModule;

    public PresenceCollectorModule(PubSubConfig config, PacketWriter packetWriter, CapsModule capsModule) {
        super(config, packetWriter);
        this.capsModule = capsModule;
    }

    public void addBuddyVisibilityHandler(BuddyVisibilityHandler handler) {
        this.config.getEventBus().addHandler(BuddyVisibilityHandler.BuddyVisibilityEvent.TYPE, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addJid(BareJID serviceJid, JID jid, String[] caps) {
        ConcurrentHashMap tmp;
        if (jid == null) {
            return false;
        }
        if (caps == null || caps.length == 0) {
            caps = EMPTY_CAPS;
        } else {
            StringBuilder sb = new StringBuilder();
            for (String item : caps) {
                sb.append(item);
            }
            String key = sb.toString();
            String[] cachedCaps = CAPS_MAP.putIfAbsent(key, caps);
            if (cachedCaps != null) {
                caps = cachedCaps;
            }
        }
        boolean added = false;
        BareJID bareJid = jid.getBareJID();
        String resource = jid.getResource();
        ConcurrentHashMap presenceByUser = (ConcurrentHashMap)this.presenceByService.get(serviceJid);
        if (presenceByUser == null && (presenceByUser = (ConcurrentMap)this.presenceByService.putIfAbsent(serviceJid, tmp = new ConcurrentHashMap())) == null) {
            presenceByUser = tmp;
        }
        if (resource != null) {
            Object[] oldCaps;
            HashMap<String, String[]> tmp2;
            HashMap<String, String[]> resources = (HashMap<String, String[]>)presenceByUser.get(bareJid);
            if (resources == null && (resources = (Map)presenceByUser.putIfAbsent(bareJid, tmp2 = new HashMap<String, String[]>())) == null) {
                resources = tmp2;
            }
            HashMap<String, String[]> hashMap = resources;
            synchronized (hashMap) {
                oldCaps = resources.put(resource, caps);
                added = oldCaps == null;
            }
            this.log.finest("for service " + serviceJid + " - Contact " + jid + " is collected.");
            if (this.config.isPepPeristent() && this.config.isSendLastPublishedItemOnPresence() && serviceJid.getLocalpart() != null && oldCaps != caps && caps != null) {
                String[] features;
                HashSet<String> newFeatures = new HashSet<String>();
                for (String string : caps) {
                    if (oldCaps != null && Arrays.binarySearch(oldCaps, string) >= 0 || (features = PresenceCapabilitiesManager.getNodeFeatures((String)string)) == null) continue;
                    for (String feature : features) {
                        newFeatures.add(feature);
                    }
                }
                if (oldCaps != null) {
                    for (String string : oldCaps) {
                        if (Arrays.binarySearch(caps, string) >= 0 || (features = PresenceCapabilitiesManager.getNodeFeatures((String)string)) == null) continue;
                        for (String feature : features) {
                            newFeatures.remove(feature);
                        }
                    }
                }
                if (!newFeatures.isEmpty()) {
                    this.config.getEventBus().fire(new CapsChangeHandler.CapsChangeEvent(serviceJid, jid, caps, (String[])oldCaps, newFeatures));
                }
            }
        }
        return added;
    }

    public void addPresenceChangeHandler(PresenceChangeHandler handler) {
        this.config.getEventBus().addHandler(PresenceChangeHandler.PresenceChangeEvent.TYPE, handler);
    }

    private void firePresenceChangeEvent(Packet packet) {
        PresenceChangeHandler.PresenceChangeEvent event = new PresenceChangeHandler.PresenceChangeEvent(packet);
        this.config.getEventBus().fire(event);
    }

    public List<JID> getAllAvailableJids(BareJID serviceJid) {
        ArrayList<JID> result = new ArrayList<JID>();
        ConcurrentMap presenceByUser = (ConcurrentMap)this.presenceByService.get(serviceJid);
        if (presenceByUser != null) {
            for (Map.Entry entry : presenceByUser.entrySet()) {
                for (String reource : ((Map)entry.getValue()).keySet()) {
                    JID jid = JID.jidInstanceNS((BareJID)((BareJID)entry.getKey()), (String)reource);
                    if (!this.isAvailableLocally(jid)) continue;
                    result.add(jid);
                }
            }
        }
        return result;
    }

    public List<JID> getAllAvailableResources(BareJID serviceJid, BareJID bareJid) {
        ArrayList<JID> result = new ArrayList<JID>();
        ConcurrentMap presenceByUser = (ConcurrentMap)this.presenceByService.get(serviceJid);
        if (presenceByUser == null) {
            return result;
        }
        Map jid_resources = (Map)presenceByUser.get(bareJid);
        if (jid_resources != null) {
            for (String reource : jid_resources.keySet()) {
                JID jid = JID.jidInstanceNS((BareJID)bareJid, (String)reource);
                if (!this.isAvailableLocally(jid)) continue;
                result.add(jid);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<JID> getAllAvailableJidsWithFeature(BareJID serviceJid, String feature) {
        ArrayList<JID> result = new ArrayList<JID>();
        ConcurrentMap presenceByUser = (ConcurrentMap)this.presenceByService.get(serviceJid);
        if (presenceByUser == null) {
            return result;
        }
        Set nodesWithFeature = PresenceCapabilitiesManager.getNodesWithFeature((String)feature);
        for (Map.Entry pe : presenceByUser.entrySet()) {
            Map jid_resources = (Map)pe.getValue();
            if (jid_resources == null) continue;
            Map map = jid_resources;
            synchronized (map) {
                for (Map.Entry e : jid_resources.entrySet()) {
                    JID jid;
                    String[] caps = (String[])e.getValue();
                    boolean match = false;
                    for (String node : caps) {
                        match |= nodesWithFeature.contains(node);
                    }
                    if (!match || !this.isAvailableLocally(jid = JID.jidInstanceNS((BareJID)((BareJID)pe.getKey()), (String)((String)e.getKey())))) continue;
                    result.add(jid);
                }
            }
        }
        return result;
    }

    @Override
    public String[] getFeatures() {
        return new String[]{"http://jabber.org/protocol/pubsub#presence-notifications"};
    }

    @Override
    public Criteria getModuleCriteria() {
        return CRIT;
    }

    protected boolean isAvailableLocally(JID jid) {
        return true;
    }

    public boolean isJidAvailable(BareJID serviceJid, BareJID bareJid) {
        ConcurrentMap presenceByUser = (ConcurrentMap)this.presenceByService.get(serviceJid);
        if (presenceByUser == null) {
            return false;
        }
        Map resources = (Map)presenceByUser.get(bareJid);
        return resources != null && resources.size() > 0;
    }

    private Packet preparePresence(Packet presence, StanzaType type) {
        JID to = presence.getTo();
        JID from = presence.getStanzaFrom();
        if (from != null && to != null && !from.getBareJID().equals((Object)to.getBareJID())) {
            JID jid = from.copyWithoutResource();
            Element p = new Element("presence", new String[]{"to", "from", "xmlns"}, new String[]{jid.toString(), to.toString(), "jabber:client"});
            if (type != null) {
                p.setAttribute("type", type.toString());
            }
            return new Presence(p, to, from);
        }
        return null;
    }

    @Override
    public void process(Packet packet) throws PubSubException {
        StanzaType type = packet.getType();
        JID jid = packet.getStanzaFrom();
        JID toJid = packet.getStanzaTo();
        if (type == null || type == StanzaType.available) {
            String[] caps = this.config.isPepPeristent() ? this.capsModule.processPresence(packet) : null;
            boolean added = this.addJid(toJid.getBareJID(), jid, caps);
            this.firePresenceChangeEvent(packet);
            if (added && packet.getStanzaTo().getLocalpart() == null) {
                Presence p = new Presence(new Element("presence", new String[]{"to", "from", "xmlns"}, new String[]{jid.toString(), toJid.toString(), "jabber:client"}), toJid, jid);
                this.packetWriter.write((Packet)p);
            }
        } else if (StanzaType.unavailable == type) {
            this.removeJid(toJid.getBareJID(), jid);
            this.firePresenceChangeEvent(packet);
            if (packet.getStanzaTo().getLocalpart() == null) {
                Presence p = new Presence(new Element("presence", new String[]{"to", "from", "type", "xmlns"}, new String[]{jid.toString(), toJid.toString(), StanzaType.unavailable.toString(), "jabber:client"}), toJid, jid);
                this.packetWriter.write((Packet)p);
            }
        } else if (StanzaType.subscribe == type) {
            this.log.finest("Contact " + jid + " wants to subscribe PubSub");
            Packet presence = this.preparePresence(packet, StanzaType.subscribed);
            if (presence != null) {
                this.packetWriter.write(presence);
            }
            if ((presence = this.preparePresence(packet, StanzaType.subscribe)) != null) {
                this.packetWriter.write(presence);
            }
        } else if (StanzaType.unsubscribe == type || StanzaType.unsubscribed == type) {
            this.log.finest("Contact " + jid + " wants to unsubscribe PubSub");
            Packet presence = this.preparePresence(packet, StanzaType.unsubscribed);
            if (presence != null) {
                this.packetWriter.write(presence);
            }
            if ((presence = this.preparePresence(packet, StanzaType.unsubscribe)) != null) {
                this.packetWriter.write(presence);
            }
        }
    }

    public void removeBuddyVisibilityHandler(BuddyVisibilityHandler handler) {
        this.config.getEventBus().remove(BuddyVisibilityHandler.BuddyVisibilityEvent.TYPE, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean removeJid(BareJID serviceJid, JID jid) {
        if (jid == null) {
            return false;
        }
        BareJID bareJid = jid.getBareJID();
        String resource = jid.getResource();
        boolean removed = false;
        ConcurrentMap presenceByUser = (ConcurrentMap)this.presenceByService.get(serviceJid);
        if (presenceByUser == null) {
            return false;
        }
        if (resource == null) {
            presenceByUser.remove(bareJid);
            BuddyVisibilityHandler.BuddyVisibilityEvent event = new BuddyVisibilityHandler.BuddyVisibilityEvent(bareJid, false);
            this.config.getEventBus().fire(event);
        } else {
            Map resources = (Map)presenceByUser.get(bareJid);
            if (resources != null) {
                Map map = resources;
                synchronized (map) {
                    removed = resources.remove(resource) != null;
                    this.log.finest("for service " + serviceJid + " - Contact " + jid + " is removed from collection.");
                    if (resources.isEmpty()) {
                        presenceByUser.remove(bareJid);
                        BuddyVisibilityHandler.BuddyVisibilityEvent event = new BuddyVisibilityHandler.BuddyVisibilityEvent(bareJid, false);
                        this.config.getEventBus().fire(event);
                    }
                }
            }
        }
        return removed;
    }

    public void removePresenceChangeHandler(PresenceChangeHandler handler) {
        this.config.getEventBus().remove(PresenceChangeHandler.PresenceChangeEvent.TYPE, handler);
    }

    public static interface PresenceChangeHandler
    extends EventHandler {
        public void onPresenceChange(Packet var1);

        public static class PresenceChangeEvent
        extends Event<PresenceChangeHandler> {
            public static final EventType<PresenceChangeHandler> TYPE = new EventType();
            private Packet packet;

            public PresenceChangeEvent(Packet packet) {
                super(TYPE);
                this.packet = packet;
            }

            @Override
            protected void dispatch(PresenceChangeHandler handler) {
                handler.onPresenceChange(this.packet);
            }
        }
    }

    public static interface CapsChangeHandler
    extends EventHandler {
        public void onCapsChange(BareJID var1, JID var2, String[] var3, String[] var4, Set<String> var5);

        public static class CapsChangeEvent
        extends Event<CapsChangeHandler> {
            public static final EventType<CapsChangeHandler> TYPE = new EventType();
            private final BareJID serviceJid;
            private final JID buddyJid;
            private final String[] newCaps;
            private final String[] oldCaps;
            private final Set<String> newFeatures;

            public CapsChangeEvent(BareJID serviceJid, JID buddyJid, String[] newCaps, String[] oldCaps, Set<String> newFeatures) {
                super(TYPE);
                this.serviceJid = serviceJid;
                this.buddyJid = buddyJid;
                this.newCaps = newCaps;
                this.oldCaps = oldCaps;
                this.newFeatures = newFeatures;
            }

            @Override
            protected void dispatch(CapsChangeHandler handler) {
                handler.onCapsChange(this.serviceJid, this.buddyJid, this.newCaps, this.oldCaps, this.newFeatures);
            }
        }
    }

    public static interface BuddyVisibilityHandler
    extends EventHandler {
        public void onBuddyVisibilityChange(BareJID var1, boolean var2);

        public static class BuddyVisibilityEvent
        extends Event<BuddyVisibilityHandler> {
            public static final EventType<BuddyVisibilityHandler> TYPE = new EventType();
            private final boolean becomeOnline;
            private final BareJID buddyJID;

            public BuddyVisibilityEvent(BareJID buddyJID, boolean becomeOnline) {
                super(TYPE);
                this.buddyJID = buddyJID;
                this.becomeOnline = becomeOnline;
            }

            @Override
            protected void dispatch(BuddyVisibilityHandler handler) {
                handler.onBuddyVisibilityChange(this.buddyJID, this.becomeOnline);
            }
        }
    }
}

