/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.snmp.mpm;

import com.sun.jdmk.internal.ClassLogger;
import com.sun.management.internal.snmp.SnmpDecryptedPdu;
import com.sun.management.internal.snmp.SnmpIncomingRequest;
import com.sun.management.internal.snmp.SnmpIncomingResponse;
import com.sun.management.internal.snmp.SnmpModelImpl;
import com.sun.management.internal.snmp.SnmpMsgProcessingModel;
import com.sun.management.internal.snmp.SnmpMsgProcessingSubSystem;
import com.sun.management.internal.snmp.SnmpOutgoingRequest;
import com.sun.management.internal.snmp.SnmpSecuritySubSystem;
import com.sun.management.internal.snmp.SnmpSubSystem;
import com.sun.management.snmp.BerDecoder;
import com.sun.management.snmp.BerEncoder;
import com.sun.management.snmp.BerException;
import com.sun.management.snmp.SnmpEngineId;
import com.sun.management.snmp.SnmpPdu;
import com.sun.management.snmp.SnmpPduFactory;
import com.sun.management.snmp.SnmpScopedPduBulk;
import com.sun.management.snmp.SnmpScopedPduPacket;
import com.sun.management.snmp.SnmpScopedPduRequest;
import com.sun.management.snmp.SnmpSecurityParameters;
import com.sun.management.snmp.SnmpStatusException;
import com.sun.management.snmp.SnmpTooBigException;
import com.sun.management.snmp.SnmpV3Message;
import com.sun.management.snmp.manager.SnmpParams;
import com.sun.management.snmp.manager.SnmpV3Parameters;
import com.sun.management.snmp.mpm.SnmpIncomingRequestImpl;
import com.sun.management.snmp.mpm.SnmpIncomingResponseImpl;
import com.sun.management.snmp.mpm.SnmpMsgTranslator;
import com.sun.management.snmp.mpm.SnmpMsgTranslatorV3;
import com.sun.management.snmp.mpm.SnmpOutgoingRequestImpl;

public class SnmpMsgProcessingModelV3
extends SnmpModelImpl
implements SnmpMsgProcessingModel {
    private int bufferSize = 1024;
    private SnmpMsgTranslator translator = null;
    private static final ClassLogger logger = new ClassLogger("com.sun.jdmk.snmp.runtime", "SnmpMsgProcessingModelV3");
    String dbgTag = "SnmpMsgProcessingModelV3";

    public synchronized void setMsgTranslator(SnmpMsgTranslator translator) {
        this.translator = translator;
    }

    public synchronized SnmpMsgTranslator getMsgTranslator() {
        return this.translator;
    }

    private SnmpMsgTranslator createMsgTranslator(SnmpSubSystem sys) {
        return new SnmpMsgTranslatorV3();
    }

    public SnmpMsgProcessingModelV3(SnmpMsgProcessingSubSystem sys, SnmpMsgTranslator translat) {
        super(sys, "Snmp V3");
        this.translator = translat == null ? this.createMsgTranslator(sys) : translat;
        sys.addModel(3, this);
    }

    public SnmpIncomingRequest getIncomingRequest(SnmpPduFactory factory) {
        SnmpSecuritySubSystem secure = ((SnmpMsgProcessingSubSystem)this.getSubSystem()).getSecuritySubSystem();
        return new SnmpIncomingRequestImpl(secure, factory, new SnmpV3Message(), new SnmpV3Message(), this.getMsgTranslator());
    }

    public SnmpOutgoingRequest getOutgoingRequest(SnmpPduFactory factory) {
        SnmpSecuritySubSystem secure = ((SnmpMsgProcessingSubSystem)this.getSubSystem()).getSecuritySubSystem();
        return new SnmpOutgoingRequestImpl(secure, factory, new SnmpV3Message(), this.getMsgTranslator());
    }

    public SnmpIncomingResponse getIncomingResponse(SnmpPduFactory factory) {
        SnmpSecuritySubSystem secure = ((SnmpMsgProcessingSubSystem)this.getSubSystem()).getSecuritySubSystem();
        return new SnmpIncomingResponseImpl(secure, factory, new SnmpV3Message(), this.getMsgTranslator());
    }

    public SnmpPdu getRequestPdu(SnmpParams p, int command) throws SnmpStatusException {
        SnmpScopedPduPacket reqpdu = null;
        SnmpV3Parameters params = (SnmpV3Parameters)p;
        if (command == 165) {
            SnmpScopedPduBulk bulkPdu;
            reqpdu = bulkPdu = new SnmpScopedPduBulk();
        } else {
            SnmpScopedPduRequest simplePdu = new SnmpScopedPduRequest();
            reqpdu = simplePdu;
            reqpdu.type = command;
        }
        reqpdu.version = params.getProtocolVersion();
        reqpdu.contextEngineId = params.getContextEngineId();
        reqpdu.contextName = params.getContextName();
        reqpdu.msgFlags = (byte)params.getSecurityLevel();
        reqpdu.msgMaxSize = params.getMsgMaxSize();
        reqpdu.msgSecurityModel = params.getMsgSecurityModel();
        reqpdu.securityParameters = params.getSecurityParameters();
        return reqpdu;
    }

    byte[] encodeParameters(SnmpSecurityParameters params) throws SnmpTooBigException {
        byte[] res = null;
        try {
            byte[] encoded = new byte[this.bufferSize];
            int len = 0;
            len = params.encode(encoded);
            res = new byte[len];
            for (int i = 0; i < len; ++i) {
                res[i] = encoded[i];
            }
        }
        catch (IndexOutOfBoundsException e) {
            throw new SnmpTooBigException();
        }
        return res;
    }

    public int encodePriv(int version, int msgId, int msgMaxSize, byte msgFlags, int msgSecurityModel, SnmpSecurityParameters params, byte[] encryptedPdu, byte[] outputBytes) throws SnmpTooBigException {
        BerEncoder benc = null;
        boolean authLength = false;
        benc = new BerEncoder(outputBytes);
        int encodingLength = 0;
        benc.openSequence();
        benc.putOctetString(encryptedPdu);
        byte[] securityParams = this.encodeParameters(params);
        benc.putOctetString(securityParams);
        benc.openSequence();
        benc.putInteger(msgSecurityModel);
        byte[] b = new byte[]{msgFlags};
        benc.putOctetString(b);
        benc.putInteger(msgMaxSize);
        benc.putInteger(msgId);
        benc.closeSequence();
        benc.putInteger(version);
        benc.closeSequence();
        encodingLength = benc.trim();
        return encodingLength;
    }

    public int encode(int version, int msgId, int msgMaxSize, byte msgFlags, int msgSecurityModel, SnmpSecurityParameters params, byte[] contextEngineId, byte[] contextName, byte[] data, int dataLength, byte[] outputBytes) throws SnmpTooBigException {
        if (logger.finestOn()) {
            logger.finest("encode", "Version: " + version + ", msgId: " + msgId + ", msgMaxSize: " + msgMaxSize + ", msgFlags: " + msgFlags + ", msgSecurityModel: " + msgSecurityModel + ", params: " + params + ", contextEngineId: " + (contextEngineId == null ? null : SnmpEngineId.createEngineId(contextEngineId)) + ", contextName: " + (contextName == null ? null : new String(contextName)) + ", data len: " + dataLength);
        }
        BerEncoder benc = null;
        benc = new BerEncoder(outputBytes);
        int encodingLength = 0;
        benc.openSequence();
        benc.openSequence();
        benc.putAny(data, dataLength);
        benc.putOctetString(contextName != null ? contextName : new byte[]{});
        benc.putOctetString(contextEngineId != null ? contextEngineId : new byte[]{});
        benc.closeSequence();
        byte[] securityParams = this.encodeParameters(params);
        benc.putOctetString(securityParams);
        benc.openSequence();
        benc.putInteger(msgSecurityModel);
        byte[] b = new byte[]{msgFlags};
        benc.putOctetString(b);
        benc.putInteger(msgMaxSize);
        benc.putInteger(msgId);
        benc.closeSequence();
        benc.putInteger(version);
        benc.closeSequence();
        encodingLength = benc.trim();
        return encodingLength;
    }

    public SnmpDecryptedPdu decode(byte[] buff) throws SnmpStatusException {
        SnmpDecryptedPdu pdu = new SnmpDecryptedPdu();
        try {
            BerDecoder bdec = new BerDecoder(buff);
            bdec.openSequence();
            pdu.contextEngineId = bdec.fetchOctetString();
            pdu.contextName = bdec.fetchOctetString();
            pdu.data = bdec.fetchAny();
            bdec.closeSequence();
        }
        catch (BerException x) {
            throw new SnmpStatusException("Invalid encoding : " + x.toString());
        }
        return pdu;
    }

    public int encode(SnmpDecryptedPdu pdu, byte[] outputBytes) throws SnmpTooBigException {
        if (logger.finestOn()) {
            logger.finest("encode", "pdu: " + pdu + ", output bytes: " + outputBytes);
        }
        BerEncoder bencPdu = new BerEncoder(outputBytes);
        bencPdu.openSequence();
        bencPdu.putAny(pdu.data, pdu.dataLength);
        bencPdu.putOctetString(pdu.contextName != null ? pdu.contextName : new byte[]{});
        bencPdu.putOctetString(pdu.contextEngineId != null ? pdu.contextEngineId : new byte[]{});
        bencPdu.closeSequence();
        return bencPdu.trim();
    }
}

