/*
 * Decompiled with CFR 0.152.
 */
package tigase.muc;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.muc.MUCComponent;
import tigase.muc.Room;
import tigase.muc.modules.PresenceModule;
import tigase.server.Packet;
import tigase.server.ReceiverTimeoutHandler;
import tigase.util.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class Ghostbuster2 {
    private static long idCounter;
    private static final Set<String> intReasons;
    public static final Set<String> R;
    protected Logger log = Logger.getLogger(this.getClass().getName());
    protected final Map<JID, MonitoredObject> monitoredObjects = new ConcurrentHashMap<JID, MonitoredObject>();
    private final MUCComponent mucComponent;
    private final ReceiverTimeoutHandler pingHandler;
    private PresenceModule presenceModule;

    public Ghostbuster2(MUCComponent mucComponent) {
        this.mucComponent = mucComponent;
        this.pingHandler = new ReceiverTimeoutHandler(){

            public void responseReceived(Packet data, Packet response) {
                block2: {
                    try {
                        Ghostbuster2.this.onPingReceived(response);
                    }
                    catch (Exception e) {
                        if (!Ghostbuster2.this.log.isLoggable(Level.WARNING)) break block2;
                        Ghostbuster2.this.log.log(Level.WARNING, "Problem on handling ping response", e);
                    }
                }
            }

            public void timeOutExpired(Packet data) {
                block3: {
                    try {
                        if (Ghostbuster2.this.log.isLoggable(Level.FINEST)) {
                            Ghostbuster2.this.log.finest("Received ping timeout for ping " + data.getElement().getAttributeStaticStr("id"));
                        }
                        Ghostbuster2.this.onPingTimeout(data.getStanzaTo());
                    }
                    catch (Exception e) {
                        if (!Ghostbuster2.this.log.isLoggable(Level.WARNING)) break block3;
                        Ghostbuster2.this.log.log(Level.WARNING, "Problem on handling ping timeout", e);
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(JID occupantJid, Room room) {
        try {
            MonitoredObject o = this.monitoredObjects.get(occupantJid);
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(occupantJid + " registered in room " + room.getRoomJID());
            }
            if (o == null) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Start observing " + occupantJid);
                }
                o = new MonitoredObject(occupantJid);
                o.lastActivity = System.currentTimeMillis();
                this.monitoredObjects.put(occupantJid, o);
            }
            HashSet hashSet = o.rooms;
            synchronized (hashSet) {
                o.rooms.add(room.getRoomJID());
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Problem on registering occupant", e);
        }
    }

    private String checkError(Packet packet) {
        String type = packet.getElement().getAttributeStaticStr("type");
        if (type == null || !type.equals("error")) {
            return null;
        }
        Element errorElement = packet.getElement().getChild("error");
        if (errorElement == null) {
            return null;
        }
        for (Element reason : errorElement.getChildren()) {
            if (reason.getXMLNS() == null || !reason.getXMLNS().equals("urn:ietf:params:xml:ns:xmpp-stanzas") || !R.contains(reason.getName())) continue;
            return reason.getName();
        }
        return null;
    }

    public PresenceModule getPresenceModule() {
        return this.presenceModule;
    }

    protected void onPingReceived(Packet packet) throws TigaseStringprepException {
        this.update(packet);
    }

    protected void onPingTimeout(JID stanzaTo) throws TigaseStringprepException {
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Timeouted ping to: " + stanzaTo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ping() throws TigaseStringprepException {
        if (this.log.isLoggable(Level.FINE)) {
            this.log.log(Level.FINE, "Pinging up to 1000 known JIDs with 1h of inactivity");
        }
        int c = 0;
        long now = System.currentTimeMillis();
        long border = now - 3600000L;
        Iterator<MonitoredObject> it = this.monitoredObjects.values().iterator();
        while (it.hasNext() && c < 1000) {
            MonitoredObject entry = it.next();
            if (entry.lastActivity >= border) continue;
            ++c;
            BareJID r = null;
            HashSet hashSet = entry.rooms;
            synchronized (hashSet) {
                if (!entry.rooms.isEmpty()) {
                    r = (BareJID)entry.rooms.iterator().next();
                }
            }
            if (r == null) continue;
            this.ping(r, entry.source);
        }
    }

    private void ping(BareJID room, JID occupantJID) throws TigaseStringprepException {
        String id = "png-" + ++idCounter;
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, "Pinging " + occupantJID + ". id=" + id);
        }
        Element ping = new Element("iq", new String[]{"type", "id", "from", "to"}, new String[]{"get", id, room.toString(), occupantJID.toString()});
        ping.addChild((XMLNodeIfc)new Element("ping", new String[]{"xmlns"}, new String[]{"urn:xmpp:ping"}));
        Packet packet = Packet.packetInstance((Element)ping);
        packet.setXMLNS("jabber:client");
        this.mucComponent.addOutPacketWithTimeout(packet, this.pingHandler, 1L, TimeUnit.MINUTES);
        if (this.log.isLoggable(Level.FINER)) {
            this.log.log(Level.FINER, "Pinged " + occupantJID);
        }
    }

    private void processError(MonitoredObject obj, Packet packet) throws TigaseStringprepException {
        if (this.presenceModule == null || this.mucComponent.getMucRepository() == null) {
            return;
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("Forced removal last activity of " + obj.source);
        }
        this.monitoredObjects.remove(obj);
        for (Room r : this.mucComponent.getMucRepository().getActiveRooms().values()) {
            if (!obj.rooms.contains(r.getRoomJID()) || !r.isOccupantInRoom(obj.source)) continue;
            this.presenceModule.doQuit(r, obj.source);
        }
    }

    public void remove(Collection<JID> occupantJids, Room room) {
        for (JID jid : occupantJids) {
            this.remove(jid, room);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(JID occupantJid, Room room) {
        try {
            MonitoredObject o = this.monitoredObjects.get(occupantJid);
            if (o == null) {
                return;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine(occupantJid + " unregisterd from room " + room.getRoomJID());
            }
            HashSet hashSet = o.rooms;
            synchronized (hashSet) {
                o.rooms.remove(room.getRoomJID());
                if (o.rooms.isEmpty()) {
                    if (this.log.isLoggable(Level.FINE)) {
                        this.log.fine("Stop observing " + occupantJid);
                    }
                    this.monitoredObjects.remove(o);
                }
            }
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Problem on unregistering occupant", e);
        }
    }

    public void setPresenceModule(PresenceModule presenceModule) {
        this.presenceModule = presenceModule;
    }

    public void update(Packet packet) throws TigaseStringprepException {
        if (packet.getStanzaFrom() == null) {
            return;
        }
        MonitoredObject o = this.monitoredObjects.get(packet.getStanzaFrom());
        if (o == null) {
            return;
        }
        if (this.checkError(packet) != null) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Received presence error: " + packet.getElement().toString());
            }
            this.processError(o, packet);
        } else {
            if (this.log.isLoggable(Level.FINER)) {
                this.log.finer("Update activity of " + o.source);
            }
            o.lastActivity = System.currentTimeMillis();
        }
    }

    static {
        intReasons = new HashSet<String>(){
            private static final long serialVersionUID = 1L;
            {
                this.add("gone");
                this.add("item-not-found");
                this.add("recipient-unavailable");
                this.add("redirect");
                this.add("remote-server-not-found");
                this.add("remote-server-timeout");
            }
        };
        R = Collections.unmodifiableSet(intReasons);
    }

    private class MonitoredObject {
        private long lastActivity;
        private HashSet<BareJID> rooms = new HashSet();
        private final JID source;

        public MonitoredObject(JID occupantJid) {
            this.source = occupantJid;
        }
    }
}

