/*
 * Decompiled with CFR 0.152.
 */
package nextplane.xmpp.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Command;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPProcessorIfc;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.Presence;

public class PresenceNextPlane
extends XMPPProcessor
implements Presence.ExtendedPresenceProcessorIfc,
XMPPProcessorIfc,
XMPPPacketFilterIfc {
    private static final String ID = "pep-nextplane-adhoc";
    private static final Logger log = Logger.getLogger(PresenceNextPlane.class.getName());
    protected static final String[] INTERNAL_ELEMENT = new String[]{"iq", "command", "x", "field"};
    protected static final String[] GEOLOC_ELEMENT = new String[]{"iq", "command", "x", "field", "value", "item", "geoloc"};
    protected static final String[][] ELEMENTS = new String[][]{GEOLOC_ELEMENT};
    protected static final String[] XMLNSS = new String[]{"http://jabber.org/protocol/geoloc"};
    private static final String idPrefix = "nextplane-cmd-";
    private static long cnt = 0L;
    final String pepinternal = "pep-internal";

    public String id() {
        return ID;
    }

    public String[][] supElementNamePaths() {
        return ELEMENTS;
    }

    public String[] supNamespaces() {
        return XMLNSS;
    }

    public void process(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results, Map<String, Object> settings) throws XMPPException {
        block4: {
            if (session != null) {
                Element geolocEl;
                String resource = packet.getStanzaTo().getResource();
                if (packet.getStanzaTo() != null && resource != null && session.getResource().equals(resource) && (geolocEl = packet.getElement().findChild(GEOLOC_ELEMENT)) != null) {
                    session.putSessionData("user-geolocation", (Object)geolocEl);
                    try {
                        Presence.rebroadcastPresence((XMPPResourceConnection)session, results);
                    }
                    catch (TigaseDBException | NotAuthorizedException ex) {
                        if (!log.isLoggable(Level.FINEST)) break block4;
                        log.log(Level.FINEST, "Error rebroadcasting presence after ad-hoc", ex);
                    }
                }
            }
        }
    }

    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (session != null) {
            Iterator it = results.iterator();
            while (it.hasNext()) {
                List fields;
                Element pubsubInternal;
                Packet res = (Packet)it.next();
                if (res.getStanzaTo() == null || res.getType() == null || res.getType().equals((Object)StanzaType.set)) continue;
                Element geolocEl = res.getElement().findChild(GEOLOC_ELEMENT);
                if (geolocEl != null) {
                    it.remove();
                }
                if ((pubsubInternal = res.getElement().findChild(INTERNAL_ELEMENT)) != null && pubsubInternal.getAttributeStaticStr("var").equals("tigase-pubsub#internal") && pubsubInternal.getChild("value").getCData().equals("pep-internal")) {
                    it.remove();
                }
                if ((fields = res.getElement().getChildren(new String[]{"iq", "command", "x"})) == null || fields.isEmpty() || !res.getType().equals((Object)StanzaType.error)) continue;
                for (Element children : fields) {
                    if (children.getAttributeStaticStr("var") == null || !children.getAttributeStaticStr("var").equals("tigase-pubsub#internal") || children.getChild("value") == null || children.getChild("value").getCData() == null || !children.getChild("value").getCData().equals("pep-internal")) continue;
                    it.remove();
                }
            }
        }
    }

    public Element extend(XMPPResourceConnection session, Queue<Packet> results) {
        Element element = (Element)session.getSessionData("user-geolocation");
        if (element != null) {
            return element;
        }
        if (session.getSessionData("user-geolocation-loaded") == null) {
            block4: {
                try {
                    JID jid = session.getJID();
                    JID pubsub = JID.jidInstanceNS((String)("pubsub." + jid.getDomain()));
                    Element createIqCommand = Command.createIqCommand((JID)jid, (JID)pubsub, (StanzaType)StanzaType.set, (String)(idPrefix + ++cnt), (String)"retrieve-items", (Command.DataType)Command.DataType.submit);
                    Packet result = Iq.packetInstance((Element)createIqCommand, (JID)jid, (JID)pubsub);
                    Command.addFieldValue((Packet)result, (String)"tigase-pubsub#service-name", (String)jid.getBareJID().toString());
                    Command.addFieldValue((Packet)result, (String)"tigase-pubsub#node-name", (String)"http://jabber.org/protocol/geoloc");
                    Command.addFieldValue((Packet)result, (String)"tigase-pubsub#item-id", (String)jid.getResource());
                    Command.addFieldValue((Packet)result, (String)"tigase-pubsub#internal", (String)"pep-internal");
                    result.setPacketFrom(jid);
                    result.setPacketTo(pubsub);
                    results.offer(result);
                }
                catch (NotAuthorizedException ex) {
                    if (!log.isLoggable(Level.FINEST)) break block4;
                    log.log(Level.FINEST, "User not authenticated", ex);
                }
            }
            session.putSessionData("user-geolocation-loaded", (Object)"user-geolocation-loaded");
        }
        return null;
    }
}

