/*
 * Decompiled with CFR 0.152.
 */
package nextplane.xmpp.impl;

import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.TigaseDBException;
import tigase.pubsub.PepPlugin;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.impl.Presence;

public class PepNextPlanePlugin
extends PepPlugin {
    private static final Logger log = Logger.getLogger(PepNextPlanePlugin.class.getCanonicalName());
    private static final String ID = "pep-nextplane";
    protected static boolean retractEmptyGeoloc = false;
    protected static final String[] PUBLISH_PATH = new String[]{"pubsub", "publish"};
    protected static final String[] PUBLISH_ITEM_PATH = new String[]{"iq", "pubsub", "publish", "item"};
    protected static final String PEP_RETRACT_EMPTY_GEOLOC_KEY = "pep-retract-empty-geoloc";
    protected static final String USER_GEOLOCATION_KEY = "user-geolocation";
    protected static final String USER_GEOLOCATION_LOADED_KEY = "user-geolocation-loaded";

    public String id() {
        return ID;
    }

    public void init(Map<String, Object> settings) throws TigaseDBException {
        super.init(settings);
        if (settings.containsKey(PEP_RETRACT_EMPTY_GEOLOC_KEY)) {
            retractEmptyGeoloc = Boolean.parseBoolean((String)settings.get(PEP_RETRACT_EMPTY_GEOLOC_KEY));
        }
    }

    protected void processIq(Packet packet, XMPPResourceConnection session, Queue<Packet> results) throws NotAuthorizedException {
        Packet result;
        if (session != null && session.isServerSession()) {
            return;
        }
        Element pubsubEl = packet.getElement().findChildStaticStr(Iq.IQ_PUBSUB_PATH);
        if (pubsubEl != null && this.simplePepEnabled) {
            List children = pubsubEl.getChildren();
            boolean simple = false;
            for (Element child : children) {
                String node = child.getAttributeStaticStr("node");
                simple |= this.simpleNodes.contains(node);
            }
            if (simple) {
                return;
            }
        }
        if (packet.getStanzaTo() != null && packet.getStanzaTo().getResource() != null) {
            if (pubsubEl != null && pubsubEl.getXMLNS() == "http://jabber.org/protocol/pubsub") {
                result = packet.copyElementOnly();
                if (session != null) {
                    XMPPResourceConnection con = session.getParentSession().getResourceForResource(packet.getStanzaTo().getResource());
                    try {
                        result.setPacketTo(con.getConnectionId());
                    }
                    catch (NoConnectionIdException ex) {
                        return;
                    }
                }
                results.offer(result);
            }
            return;
        }
        if (session != null && packet.getStanzaTo() != null && !session.isUserId(packet.getStanzaTo().getBareJID())) {
            results.offer(packet.copyElementOnly());
            return;
        }
        if (packet.getStanzaTo() == null) {
            if (pubsubEl == null || pubsubEl.getXMLNS() != "http://jabber.org/protocol/pubsub") {
                log.log(Level.FINEST, "got <iq/> packet with no 'to' attribute = {0}", packet);
                return;
            }
        } else if (packet.getStanzaTo().getResource() == null && packet.getType() == StanzaType.error) {
            return;
        }
        result = packet.copyElementOnly();
        JID stanzaTo = packet.getStanzaTo();
        JID stanzaFrom = packet.getStanzaFrom();
        if (packet.getStanzaTo() == null && session != null || session != null && stanzaTo != null && stanzaFrom != null && session.isUserId(stanzaFrom.getBareJID()) && session.isUserId(stanzaTo.getBareJID())) {
            JID userJid = JID.jidInstance((BareJID)session.getBareJID());
            Element resultEl = result.getElement();
            Element item = resultEl.findChildStaticStr(PUBLISH_ITEM_PATH);
            if (item != null) {
                Element geoloc;
                String itemId = item.getAttributeStaticStr("id");
                if (result.getType().equals((Object)StanzaType.set) && itemId == null) {
                    item.addAttribute("id", session.getResource());
                }
                if ((geoloc = item.findChildStaticStr(new String[]{"item", "geoloc"})) != null) {
                    if (geoloc.getChildren() == null || geoloc.getChildren().size() == 0) {
                        session.removeSessionData(USER_GEOLOCATION_KEY);
                    } else {
                        session.putSessionData(USER_GEOLOCATION_KEY, (Object)geoloc);
                        try {
                            Presence.rebroadcastPresence((XMPPResourceConnection)session, results);
                        }
                        catch (TigaseDBException ex) {
                            log.log(Level.FINEST, "Error rebroadcasting presence after publication", ex);
                        }
                    }
                }
            }
            result.initVars(packet.getStanzaFrom() != null ? packet.getStanzaFrom() : session.getJID(), userJid);
        }
        result.setPacketTo(this.pubsubJid);
        results.offer(result);
    }
}

