/*
 * Decompiled with CFR 0.152.
 */
package nextplane.db;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import nextplane.xmpp.impl.VCard4_XEP0292;
import tigase.db.DBInitException;
import tigase.db.DataRepository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.db.UserNotFoundException;
import tigase.db.jdbc.JDBCRepository;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.BareJID;

public class Repository
extends JDBCRepository {
    private static final String VCARD4_UPDATE = "{ call TigVCard4UpdateVCard(?,?,?,?,?,?,?) }";
    private static final String VCARD4_REMOVE = "{ call TigVCard4RemoveVCard(?) }";
    private static final String VCARD4_RETRIEVE = "{ call TigVCard4RetrieveVCard(?) }";
    private static final String VCARD4_FIND = "{ call TigVCard4FindVCard(?,?,?,?,?,?,?,?,?) }";
    private static final String VCARD4_FIND_JIDS = "{ call TigVCard4FindJids(?,?,?,?,?,?,?,?,?) }";
    private static final String VCARD4_EMAILS_CLEAR = "{ call TigVCard4RemoveEmails(?) }";
    private static final String VCARD4_EMAIL_ADD = "{ call TigVCard4AddEmail(?,?) }";
    private static final String VCARD4_PHONES_CLEAR = "{ call TigVCard4RemovePhones(?) }";
    private static final String VCARD4_PHONE_ADD = "{ call TigVCard4AddPhone(?,?) }";
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private DataRepository data_repo;

    public void initRepository(String connection_str, Map<String, String> params) throws DBInitException {
        super.initRepository(connection_str, params);
        try {
            this.data_repo = RepositoryFactory.getDataRepository(null, (String)connection_str, params);
            this.data_repo.initPreparedStatement(VCARD4_UPDATE, VCARD4_UPDATE);
            this.data_repo.initPreparedStatement(VCARD4_REMOVE, VCARD4_REMOVE);
            this.data_repo.initPreparedStatement(VCARD4_RETRIEVE, VCARD4_RETRIEVE);
            this.data_repo.initPreparedStatement(VCARD4_FIND, VCARD4_FIND);
            this.data_repo.initPreparedStatement(VCARD4_FIND_JIDS, VCARD4_FIND_JIDS);
            this.data_repo.initPreparedStatement(VCARD4_EMAILS_CLEAR, VCARD4_EMAILS_CLEAR);
            this.data_repo.initPreparedStatement(VCARD4_EMAIL_ADD, VCARD4_EMAIL_ADD);
            this.data_repo.initPreparedStatement(VCARD4_PHONES_CLEAR, VCARD4_PHONES_CLEAR);
            this.data_repo.initPreparedStatement(VCARD4_PHONE_ADD, VCARD4_PHONE_ADD);
        }
        catch (Exception ex) {
            throw new DBInitException("Problem initializing jdbc connection: " + connection_str, (Throwable)ex);
        }
    }

    public String getData(BareJID user_id, String subnode, String key, String def) throws UserNotFoundException, TigaseDBException {
        if (subnode != null && subnode.endsWith("vcard-xep-0292")) {
            String result = this.retrieveVCard4Str(user_id);
            if (result == null) {
                result = def;
            }
            return result;
        }
        return super.getData(user_id, subnode, key, def);
    }

    public void setData(BareJID user_id, String subnode, String key, String value) throws UserNotFoundException, TigaseDBException {
        if (subnode != null && subnode.endsWith("vcard-xep-0292")) {
            Element vcard = null;
            if (value != null) {
                vcard = Repository.parseXml(value).poll();
            }
            this.updateVCard4(user_id, vcard);
            return;
        }
        super.setData(user_id, subnode, key, value);
    }

    public void removeData(BareJID user_id, String subnode, String key) throws UserNotFoundException, TigaseDBException {
        if (subnode != null && subnode.endsWith("vcard-xep-0292")) {
            this.removeVCard4(user_id);
            return;
        }
        super.removeData(user_id, subnode, key);
    }

    public void updateVCard4(BareJID user_id, Element vcard) throws TigaseDBException, UserNotFoundException {
        String name = null;
        String title = null;
        String company = null;
        String department = null;
        ArrayList<String> emails = new ArrayList<String>();
        ArrayList<String> phones = new ArrayList<String>();
        String summary = null;
        if (vcard != null) {
            name = vcard.getChildCDataStaticStr(VCard4_XEP0292.FULLNAME_PATH);
            title = vcard.getChildCDataStaticStr(VCard4_XEP0292.TITLE_PATH);
            company = vcard.getChildCDataStaticStr(VCard4_XEP0292.COMPANY_PATH);
            department = vcard.getChildCDataStaticStr(VCard4_XEP0292.DEPARTMENT_PATH);
            summary = vcard.getChildCDataStaticStr(VCard4_XEP0292.SUMMARY_PATH);
            for (Element child : vcard.getChildren()) {
                String email = child.getChildCDataStaticStr(VCard4_XEP0292.EMAIL_SUBPATH);
                String phone = child.getChildCDataStaticStr(VCard4_XEP0292.PHONE_SUBPATH);
                if (email != null && !email.isEmpty()) {
                    emails.add(email);
                }
                if (phone == null || phone.isEmpty()) continue;
                phones.add(phone);
            }
        }
        this.updateVCard4(user_id, name, title, company, department, emails.toArray(new String[emails.size()]), phones.toArray(new String[phones.size()]), summary, vcard);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateVCard4(BareJID user_id, String name, String title, String company, String department, String[] emails, String[] phones, String summary, Element vcard) throws TigaseDBException, UserNotFoundException {
        block21: {
            long uid = this.getUserUID(user_id);
            if (uid == -1L) {
                throw new UserNotFoundException("User does not exist: " + user_id);
            }
            try {
                PreparedStatement stmt;
                String vcardStr = vcard.toString();
                PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(user_id, VCARD4_UPDATE);
                synchronized (preparedStatement) {
                    stmt.setLong(1, uid);
                    stmt.setString(2, name);
                    stmt.setString(3, title);
                    stmt.setString(4, company);
                    stmt.setString(5, department);
                    stmt.setString(6, summary);
                    stmt.setString(7, vcardStr);
                    stmt.execute();
                }
                preparedStatement = stmt = this.data_repo.getPreparedStatement(user_id, VCARD4_EMAILS_CLEAR);
                synchronized (preparedStatement) {
                    stmt.setLong(1, uid);
                    stmt.execute();
                }
                if (emails != null) {
                    preparedStatement = stmt = this.data_repo.getPreparedStatement(user_id, VCARD4_EMAIL_ADD);
                    synchronized (preparedStatement) {
                        for (String email : emails) {
                            stmt.setLong(1, uid);
                            stmt.setString(2, email);
                            stmt.addBatch();
                        }
                        stmt.executeBatch();
                    }
                }
                preparedStatement = stmt = this.data_repo.getPreparedStatement(user_id, VCARD4_PHONES_CLEAR);
                synchronized (preparedStatement) {
                    stmt.setLong(1, uid);
                    stmt.execute();
                }
                if (phones == null) break block21;
                preparedStatement = stmt = this.data_repo.getPreparedStatement(user_id, VCARD4_PHONE_ADD);
                synchronized (preparedStatement) {
                    for (String phone : phones) {
                        stmt.setLong(1, uid);
                        stmt.setString(2, phone);
                        stmt.addBatch();
                    }
                    stmt.executeBatch();
                }
            }
            catch (SQLException ex) {
                throw new TigaseDBException("Problem with update of vcard for user " + user_id, (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVCard4(BareJID user_id) throws UserNotFoundException, TigaseDBException {
        long uid = this.getUserUID(user_id);
        if (uid == -1L) {
            throw new UserNotFoundException("User does not exist: " + user_id);
        }
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(user_id, VCARD4_REMOVE);
            synchronized (preparedStatement) {
                stmt.setLong(1, uid);
                stmt.execute();
            }
        }
        catch (SQLException ex) {
            throw new TigaseDBException("Problem with removing vcard for user " + user_id, (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public String retrieveVCard4Str(BareJID user_id) throws TigaseDBException, UserNotFoundException {
        Object object;
        ResultSet rs;
        block9: {
            long uid = this.getUserUID(user_id);
            if (uid == -1L) {
                throw new UserNotFoundException("User does not exist: " + user_id);
            }
            rs = null;
            PreparedStatement stmt = this.data_repo.getPreparedStatement(user_id, VCARD4_RETRIEVE);
            object = stmt;
            // MONITORENTER : object
            stmt.setLong(1, uid);
            rs = stmt.executeQuery();
            if (rs.next()) break block9;
            String string = null;
            // MONITOREXIT : object
            this.data_repo.release(null, rs);
            return string;
        }
        try {
            String vcardStr = rs.getString(1);
            // MONITOREXIT : object
            object = vcardStr;
        }
        catch (SQLException ex) {
            try {
                throw new TigaseDBException("Problem with retrieving vcard for user " + user_id, (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
        }
        this.data_repo.release(null, rs);
        return object;
    }

    public Element retrieveVCard4(BareJID user_id) throws TigaseDBException, UserNotFoundException {
        String vcardStr = this.retrieveVCard4Str(user_id);
        Queue<Element> elems = Repository.parseXml(vcardStr);
        if (elems == null) {
            return null;
        }
        return elems.poll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Element> findVCard4s(BareJID user_id, String name, String title, String company, String department, String email, String phone, String summary, int limit, int offset) throws TigaseDBException {
        ResultSet rs = null;
        ArrayList<Element> result = new ArrayList<Element>();
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(user_id, VCARD4_FIND);
            synchronized (preparedStatement) {
                stmt.setString(1, name);
                stmt.setString(2, title);
                stmt.setString(3, company);
                stmt.setString(4, department);
                stmt.setString(5, email);
                stmt.setString(6, phone);
                stmt.setString(7, summary);
                stmt.setInt(8, limit);
                stmt.setInt(9, offset);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    Element elem;
                    String vcardStr = rs.getString(1);
                    String jid = rs.getString(2);
                    Queue<Element> vcardElems = Repository.parseXml(vcardStr);
                    if (vcardElems == null) continue;
                    while ((elem = vcardElems.poll()) != null) {
                        elem.setAttribute("jid", jid);
                        result.add(elem);
                    }
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new TigaseDBException("Problem with searching for vcard by user " + user_id, (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
        }
        this.data_repo.release(null, rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BareJID> findUsersByVCard4s(BareJID user_id, String name, String title, String company, String department, String email, String phone, String summary, int limit, int offset) throws TigaseDBException {
        ResultSet rs = null;
        ArrayList<BareJID> result = new ArrayList<BareJID>();
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.data_repo.getPreparedStatement(user_id, VCARD4_FIND_JIDS);
            synchronized (preparedStatement) {
                stmt.setString(1, name);
                stmt.setString(2, title);
                stmt.setString(3, company);
                stmt.setString(4, department);
                stmt.setString(5, email);
                stmt.setString(6, phone);
                stmt.setString(7, summary);
                stmt.setInt(8, limit);
                stmt.setInt(9, offset);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String jid = rs.getString(1);
                    result.add(BareJID.bareJIDInstanceNS((String)jid));
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new TigaseDBException("Problem with searching for user jids by vcards by user " + user_id, (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.data_repo.release(null, rs);
                throw throwable;
            }
        }
        this.data_repo.release(null, rs);
        return result;
    }

    private static Queue<Element> parseXml(String data) {
        if (data == null) {
            return null;
        }
        DomBuilderHandler domHandler = new DomBuilderHandler();
        char[] arr = data.toCharArray();
        parser.parse((SimpleHandler)domHandler, arr, 0, arr.length);
        return domHandler.getParsedElements();
    }
}

