/*
 * Decompiled with CFR 0.152.
 */
package nextplane.auth;

import com.onelogin.AccountSettings;
import com.onelogin.saml.Response;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.SaslException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import nextplane.auth.VerifySamlResponseCallback;
import org.xml.sax.SAXException;
import tigase.auth.XmppSaslException;
import tigase.auth.mechanisms.AbstractSasl;

public class SaslSAML
extends AbstractSasl {
    private String certificate;
    private String destinationURL;
    protected Logger log = Logger.getLogger(((Object)((Object)this)).getClass().getName());

    public static byte[] decompress(byte[] data) throws IOException, DataFormatException {
        Inflater inflater = new Inflater(true);
        inflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[1024];
        while (!inflater.finished()) {
            int count = inflater.inflate(buffer);
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] output = outputStream.toByteArray();
        return output;
    }

    protected SaslSAML(Map<? super String, ?> props, CallbackHandler callbackHandler) {
        super(props, callbackHandler);
        this.destinationURL = (String)props.get("saml-destination-url");
        this.certificate = (String)props.get("saml-certificate");
    }

    public byte[] evaluateResponse(byte[] response) throws SaslException {
        try {
            String samlResponseData = new String(SaslSAML.decompress(response));
            AccountSettings as = new AccountSettings();
            as.setCertificate(this.certificate);
            Response resp = new Response(as);
            resp.setDestinationUrl(this.destinationURL);
            resp.loadXml(samlResponseData);
            VerifySamlResponseCallback vsrc = new VerifySamlResponseCallback(resp);
            this.handleCallbacks(new Callback[]{vsrc});
            if (!vsrc.isVerified()) {
                throw new XmppSaslException(XmppSaslException.SaslError.not_authorized, "SAML Response not verified");
            }
            String authcid = resp.getAttribute("urn:oid:0.9.2342.19200300.100.1.1").split("[\\]\\[]")[1];
            NameCallback nc = new NameCallback("Authentication identity", authcid);
            this.handleCallbacks(new Callback[]{nc});
            String authorizationJID = nc.getName();
            AuthorizeCallback ac = new AuthorizeCallback(nc.getName(), authorizationJID);
            this.handleCallbacks(new Callback[]{ac});
            if (!ac.isAuthorized()) {
                throw new XmppSaslException(XmppSaslException.SaslError.invalid_authzid, "SAML: " + authcid + " is not authorized to act as " + authorizationJID);
            }
            this.authorizedId = ac.getAuthorizedID();
            this.complete = true;
            return null;
        }
        catch (IOException | CertificateException | DataFormatException | ParserConfigurationException | XPathExpressionException | SAXException e) {
            if (this.log.isLoggable(Level.FINE)) {
                this.log.log(Level.FINE, "problem during processing SAML Response", e);
            }
            throw new XmppSaslException(XmppSaslException.SaslError.not_authorized, "SAML Response not verified");
        }
    }

    public String getAuthorizationID() {
        return this.authorizedId;
    }

    public String getMechanismName() {
        return "X-SAML";
    }

    public byte[] unwrap(byte[] incoming, int offset, int len) throws SaslException {
        return null;
    }

    public byte[] wrap(byte[] outgoing, int offset, int len) throws SaslException {
        return null;
    }
}

