/*
 * Decompiled with CFR 0.152.
 */
package nextplane.auth;

import com.onelogin.saml.Response;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.logging.Level;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import nextplane.auth.VerifySamlResponseCallback;
import tigase.auth.impl.AuthRepoPlainCallbackHandler;
import tigase.db.DataRepository;
import tigase.db.RepositoryFactory;
import tigase.db.TigaseDBException;
import tigase.xml.DomBuilderHandler;
import tigase.xml.Element;
import tigase.xml.SimpleHandler;
import tigase.xml.SimpleParser;
import tigase.xml.SingletonFactory;
import tigase.xmpp.BareJID;

public class NextplaneSASLCallbacksHandler
extends AuthRepoPlainCallbackHandler {
    private static final String JIDBYEMAIL_SQL = "select tig_users.uid, tig_users.user_id,tig_pairs.pval from tig_users, tig_pairs where tig_users.uid = tig_pairs.uid and tig_pairs.pkey = 'email' and tig_pairs.pval like ?";
    private static final SimpleParser parser = SingletonFactory.getParserInstance();
    private static final String VCARD4_FIND = "{ call TigVCard4FindVCard(?,?,?,?,?,?,?,?,?) }";
    private DataRepository dataRepository;

    private static Queue<Element> parseXml(String data) {
        if (data == null) {
            return null;
        }
        DomBuilderHandler domHandler = new DomBuilderHandler();
        char[] arr = data.toCharArray();
        parser.parse((SimpleHandler)domHandler, arr, 0, arr.length);
        return domHandler.getParsedElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<BareJID> findBareJIDByEmail(String email) throws TigaseDBException {
        if (this.getDataRepo() == null) {
            return null;
        }
        ResultSet rs = null;
        ArrayList<BareJID> result = new ArrayList<BareJID>();
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.getDataRepo().getPreparedStatement(null, JIDBYEMAIL_SQL);
            synchronized (preparedStatement) {
                stmt.setString(1, email);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    String jid = rs.getString(2);
                    result.add(BareJID.bareJIDInstanceNS((String)jid));
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new TigaseDBException("Problem with searching for vcard by something ", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.getDataRepo().release(null, rs);
                throw throwable;
            }
        }
        this.getDataRepo().release(null, rs);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Element> findVCard4s(String email, int limit, int offset) throws TigaseDBException {
        if (this.getDataRepo() == null) {
            return null;
        }
        ResultSet rs = null;
        ArrayList<Element> result = new ArrayList<Element>();
        try {
            PreparedStatement stmt;
            PreparedStatement preparedStatement = stmt = this.getDataRepo().getPreparedStatement(null, VCARD4_FIND);
            synchronized (preparedStatement) {
                stmt.setString(1, null);
                stmt.setString(2, null);
                stmt.setString(3, null);
                stmt.setString(4, null);
                stmt.setString(5, email);
                stmt.setString(6, null);
                stmt.setString(7, null);
                stmt.setInt(8, limit);
                stmt.setInt(9, offset);
                rs = stmt.executeQuery();
                while (rs.next()) {
                    Element elem;
                    String vcardStr = rs.getString(1);
                    String jid = rs.getString(2);
                    Queue<Element> vcardElems = NextplaneSASLCallbacksHandler.parseXml(vcardStr);
                    if (vcardElems == null) continue;
                    while ((elem = vcardElems.poll()) != null) {
                        elem.setAttribute("jid", jid);
                        result.add(elem);
                    }
                }
            }
        }
        catch (SQLException ex) {
            try {
                throw new TigaseDBException("Problem with searching for vcard by something ", (Throwable)ex);
            }
            catch (Throwable throwable) {
                this.getDataRepo().release(null, rs);
                throw throwable;
            }
        }
        this.getDataRepo().release(null, rs);
        return result;
    }

    private DataRepository getDataRepo() {
        if (this.dataRepository != null) {
            return this.dataRepository;
        }
        String uri = System.getProperty("user-db-uri");
        if (uri != null) {
            try {
                this.dataRepository = RepositoryFactory.getDataRepository(null, (String)uri, new HashMap());
                if (null == this.dataRepository.getPreparedStatement(null, JIDBYEMAIL_SQL)) {
                    this.dataRepository.initPreparedStatement(JIDBYEMAIL_SQL, JIDBYEMAIL_SQL);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.dataRepository;
    }

    protected void handleAuthorizeCallback(AuthorizeCallback authCallback) {
        String authenId = authCallback.getAuthenticationID();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "AuthorizeCallback: authenId: {0}", authenId);
        }
        String authorId = authCallback.getAuthorizationID();
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "AuthorizeCallback: authorId: {0}", authorId);
        }
        if (authenId.equals(authorId)) {
            authCallback.setAuthorized(true);
        }
    }

    protected void handleCallback(Callback callback) throws UnsupportedCallbackException, IOException {
        if (callback instanceof VerifySamlResponseCallback) {
            this.handlerVerifySamlResponseCallback((VerifySamlResponseCallback)callback);
        } else {
            super.handleCallback(callback);
        }
    }

    protected void handleNameCallback(NameCallback nc) throws IOException {
        String user_name = nc.getDefaultName();
        this.jid = user_name.contains("@") ? this.resolve(user_name) : BareJID.bareJIDInstanceNS((String)user_name, (String)this.domain);
        nc.setName(this.jid.toString());
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.log(Level.FINEST, "NameCallback: {0}", user_name);
        }
    }

    protected void handlerVerifySamlResponseCallback(VerifySamlResponseCallback callback) {
        try {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "VerifySamlResponseCallback");
            }
            Response samlResponse = callback.getSamlResponse();
            callback.setVerified(samlResponse.isValid());
            callback.setVerified(true);
        }
        catch (Exception e) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.log(Level.FINEST, "SAML Response verification failed", e);
            }
            callback.setVerified(false);
        }
    }

    private BareJID resolve(String userName) throws IOException {
        try {
            List<BareJID> jids = this.findBareJIDByEmail(userName);
            if (jids != null && jids.size() == 1) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Using JID from database");
                }
                BareJID jid = jids.get(0);
                return jid;
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Using given username as JID");
            }
            return BareJID.bareJIDInstanceNS((String)userName);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Unable to resolve JID", e);
            throw new IOException("Can't resolve JID for username " + userName, e);
        }
    }

    private BareJID resolveUsingVCards(String userName) throws IOException {
        try {
            List<Element> vcards = this.findVCard4s(userName, 2, 0);
            if (vcards != null && vcards.size() == 1) {
                if (this.log.isLoggable(Level.FINE)) {
                    this.log.fine("Using JID from VCard");
                }
                Element elem = vcards.get(0);
                String jid = elem.getAttributeStaticStr("jid");
                return BareJID.bareJIDInstanceNS((String)jid);
            }
            if (this.log.isLoggable(Level.FINE)) {
                this.log.fine("Using given username as JID");
            }
            return BareJID.bareJIDInstanceNS((String)userName);
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "Unable to resolve JID", e);
            throw new IOException("Can't resolve JID for username " + userName, e);
        }
    }
}

