/*
 * Decompiled with CFR 0.152.
 */
package nextplane.auditlog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import nextplane.auditlog.Entry;
import nextplane.auditlog.LogRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SLF4JRepository
implements LogRepository {
    private static final Logger log = LoggerFactory.getLogger(SLF4JRepository.class);

    @Override
    public void initRepository(Map<String, Object> params) {
    }

    @Override
    public void append(Entry entry) {
        String json;
        if (log.isDebugEnabled() && (json = this.toJson(entry)) != null) {
            log.debug(json);
        }
    }

    @Override
    public List<Entry> getCachedEntries(int offset, int limit) {
        return null;
    }

    protected String toJson(Entry entry) {
        StringBuilder sb = new StringBuilder();
        Map<String, String> values = entry.getValues();
        ArrayList<String> keys = new ArrayList<String>(values.keySet());
        Collections.sort(keys);
        sb.append("{ ");
        boolean first = true;
        for (String key : keys) {
            String value = values.get(key);
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            key = SLF4JRepository.escapeJsonString(key);
            value = SLF4JRepository.escapeJsonString(value);
            sb.append("'").append(key).append("'").append(":");
            if (value != null) {
                sb.append("'").append(value).append("'");
                continue;
            }
            sb.append("null");
        }
        sb.append(" }");
        return sb.toString();
    }

    protected static String escapeJsonString(String str) {
        if (str == null) {
            return null;
        }
        return str.replaceAll("'", "\\'");
    }
}

