/*
 * Decompiled with CFR 0.152.
 */
package nextplane.auditlog;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import nextplane.auditlog.Entry;
import nextplane.auditlog.LogRepository;

public class MemoryRepository
implements LogRepository {
    private final LinkedList<Entry> cache = new LinkedList();
    private int limit = 10000;

    @Override
    public void initRepository(Map<String, Object> params) {
        if (params.containsKey("limit")) {
            this.limit = (Integer)params.get("limit");
        }
    }

    @Override
    public synchronized void append(Entry entry) {
        this.cache.offer(entry);
        if (this.cache.size() > this.limit) {
            this.cache.poll();
        }
    }

    @Override
    public synchronized List<Entry> getCachedEntries(int offset, int limit) {
        offset = this.cache.size() - offset;
        if (offset < 0) {
            offset = 0;
        }
        if (offset - limit < 0) {
            limit = offset;
        }
        return new ArrayList<Entry>(this.cache.subList(offset - limit, offset));
    }
}

