/*
 * Decompiled with CFR 0.152.
 */
package nextplane.auditlog;

import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.db.NonAuthUserRepository;
import tigase.db.TigaseDBException;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.util.DNSResolver;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPPacketFilterIfc;
import tigase.xmpp.XMPPProcessor;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPStopListenerIfc;

public class AuditLogProcessor
extends XMPPProcessor
implements XMPPPacketFilterIfc,
XMPPStopListenerIfc {
    private static final Logger log = Logger.getLogger(AuditLogProcessor.class.getCanonicalName());
    private static final String ID = "audit-log";
    private static final String XMLNS = "http://tigase.org/protocol/auditlog";
    private static final String ONLY_USER_PACKETS_KEY = "only-user-packets";
    private static final String ONLY_FROM_USER_CONNECTION_KEY = "only-from-user-connection";
    private static final String AUTH_EL_NAME = "auth";
    private static final String CHALLENGE_EL_NAME = "challenge";
    private static final String RESPONSE_EL_NAME = "response";
    private static final String SUCCESS_EL_NAME = "success";
    private static final String FAILURE_EL_NAME = "failure";
    private static final String USER = "user";
    private static final String TYPE = "type";
    private static final String FROM = "from";
    private static final String TO = "to";
    private static final String[] JINGLE_PATH = new String[]{"iq", "jingle"};
    private static final String JINGLE_XMLNS = "urn:xmpp:jingle:1";
    private static final String[] MESSAGE_THREAD_PATH = new String[]{"message", "thread"};
    private static final String[] VCARD_PATH1 = new String[]{"iq", "vCard"};
    private static final String[] VCARD_PATH2 = new String[]{"iq", "VCARD"};
    private static final String VCARD_XMLNS = "vcard-temp";
    private static final String[] VCARD4_PATH = new String[]{"iq", "vcard"};
    private static final String VCARD4_XMLNS = "urn:ietf:params:xml:ns:vcard-4.0";
    private static final Set<String> ALLOW_ERRORS;
    private final SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private JID componentJid = null;
    private boolean onlyFromUserConnection = true;
    private boolean onlyUserPackets = true;

    public String id() {
        return ID;
    }

    public void init(Map<String, Object> settings) throws TigaseDBException {
        super.init(settings);
        String componentJidStr = (String)settings.get("component-jid");
        if (componentJidStr != null) {
            this.componentJid = JID.jidInstanceNS((String)componentJidStr);
        } else {
            String defHost = DNSResolver.getDefaultHostname();
            this.componentJid = JID.jidInstanceNS((String)ID, (String)defHost, null);
        }
        if (settings.containsKey(ONLY_USER_PACKETS_KEY)) {
            this.onlyUserPackets = (Boolean)settings.get(ONLY_USER_PACKETS_KEY);
        }
        if (settings.containsKey(ONLY_FROM_USER_CONNECTION_KEY)) {
            this.onlyFromUserConnection = (Boolean)settings.get(ONLY_FROM_USER_CONNECTION_KEY);
        }
        this.formatter.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    public void filter(Packet packet, XMPPResourceConnection session, NonAuthUserRepository repo, Queue<Packet> results) {
        if (packet == null) {
            return;
        }
        if (session == null) {
            return;
        }
        if (this.onlyUserPackets) {
            try {
                if (session == null || session.isServerSession()) {
                    return;
                }
                JID connectionId = session.getConnectionId();
                if (!connectionId.equals((Object)packet.getPacketFrom()) && packet.getStanzaTo() != null && !session.isUserId(packet.getStanzaTo().getBareJID())) {
                    return;
                }
                if (this.onlyFromUserConnection && !connectionId.equals((Object)packet.getPacketFrom())) {
                    return;
                }
            }
            catch (NoConnectionIdException ex) {
                log.log(Level.WARNING, "This should not happen, this is not a server session and still connection id is not set: " + session + ", packet: " + packet, ex);
                return;
            }
            catch (NotAuthorizedException ex) {
                log.log(Level.WARNING, "Packet to a user session which is not yet authenticated: " + session + ", packet: " + packet);
                return;
            }
        }
        switch (packet.getElemName()) {
            case "auth": 
            case "challenge": {
                this.logAuth(packet, session, results);
                break;
            }
            default: {
                this.logPacket(packet, session, results);
            }
        }
    }

    private void logAuth(Packet packet, XMPPResourceConnection session, Queue<Packet> results) {
        String mechanism = null;
        switch (packet.getElemName()) {
            case "auth": {
                mechanism = packet.getAttributeStaticStr("mechanism");
                break;
            }
            case "challenge": {
                mechanism = session != null ? (String)session.getSessionData("audit-log#mechanism") : null;
            }
        }
        ArrayDeque<EntryPacket> toSent = null;
        for (Packet result : results) {
            switch (result.getElemName()) {
                case "failure": 
                case "success": {
                    try {
                        EntryPacket entry = this.newEntryPacket(session, "auth." + result.getElemName(), null);
                        Element text = result.getElement().getChild("text");
                        if (text != null) {
                            entry.put("cause", text.getCData());
                        }
                        if (toSent == null) {
                            toSent = new ArrayDeque<EntryPacket>();
                        }
                        toSent.offer(entry);
                    }
                    catch (Exception ex) {
                        log.log(Level.SEVERE, "exception during creation of auditlog entry", ex);
                    }
                    break;
                }
                case "response": {
                    if (session != null) {
                        session.putSessionData("audit-log#mechanism", (Object)mechanism);
                        break;
                    }
                    log.log(Level.FINE, "authorization packet without session, should not happen: {0}", packet.toString());
                    break;
                }
            }
        }
        if (toSent != null) {
            results.addAll(toSent);
        }
    }

    private void logPacket(Packet packet, XMPPResourceConnection session, Queue<Packet> results) {
        if (results.isEmpty()) {
            return;
        }
        String type = this.getEntryTypeFromPacket(packet);
        EntryPacket entry = this.newEntryPacket(session, type, packet.getAttributeStaticStr("id"));
        if (packet.getStanzaFrom() != null) {
            entry.put(FROM, packet.getStanzaFrom().toString());
        }
        if (packet.getStanzaTo() != null) {
            entry.put(TO, packet.getStanzaTo().toString());
        }
        switch (type) {
            case "message": {
                entry.put("callId", packet.getElemCDataStaticStr(MESSAGE_THREAD_PATH));
                break;
            }
            case "jingle": {
                entry.put("callId", packet.getAttributeStaticStr(JINGLE_PATH, "sid"));
                break;
            }
        }
        if (packet.getType() != StanzaType.error) {
            for (Packet result : results) {
                if (!this.logErrorInfo(entry, packet)) continue;
                break;
            }
        }
        results.offer((Packet)entry);
    }

    private boolean logErrorInfo(EntryPacket entry, Packet packet) {
        Element errorEl = packet.getElement().getChild("error");
        if (errorEl == null) {
            return false;
        }
        String condition = null;
        String text = null;
        List children = errorEl.getChildren();
        if (children != null) {
            for (Element cond : children) {
                if (!cond.getName().equals("text")) {
                    if (condition != null) continue;
                    condition = cond.getName();
                    continue;
                }
                if (text != null) continue;
                text = cond.getCData();
            }
        }
        if (condition != null && ALLOW_ERRORS.contains(condition)) {
            entry.put("allowed", "false");
        }
        if (errorEl.getChild(Authorization.INTERNAL_SERVER_ERROR.getCondition()) != null) {
            entry.put("internalError", "true");
        }
        entry.put("errorCondition", condition);
        entry.put("errorCode", errorEl.getAttributeStaticStr("code"));
        entry.put("errorMessage", text);
        return true;
    }

    public void stopped(XMPPResourceConnection session, Queue<Packet> results, Map<String, Object> settings) {
        EntryPacket entry = this.newEntryPacket(session, "auth.disconnected", null);
        results.offer((Packet)entry);
    }

    protected String getEntryTypeFromPacket(Packet packet) {
        String type = packet.getElemName();
        if (type == "presence" && packet.getType() != null) {
            switch (packet.getType()) {
                case subscribe: 
                case subscribed: 
                case unsubscribe: 
                case unsubscribed: {
                    type = "subscribe";
                    break;
                }
            }
        }
        if (packet.isXMLNSStaticStr(VCARD_PATH1, VCARD_XMLNS) || packet.isXMLNSStaticStr(VCARD_PATH2, VCARD_XMLNS) || packet.isXMLNSStaticStr(VCARD4_PATH, VCARD4_XMLNS)) {
            type = "vcard";
        } else if (packet.isXMLNSStaticStr(JINGLE_PATH, JINGLE_XMLNS)) {
            type = "jingle";
        }
        return type;
    }

    protected String mapType(String type) {
        return type;
    }

    private EntryPacket newEntryPacket(XMPPResourceConnection session, String type, String id) {
        EntryPacket packet = new EntryPacket(this.componentJid);
        if (session != null) {
            try {
                if (session.isAuthorized()) {
                    try {
                        packet.put(USER, session.getJID().toString());
                    }
                    catch (NotAuthorizedException ex) {
                        log.log(Level.SEVERE, "should not happen", ex);
                    }
                }
                packet.put("connection", session.getConnectionId().toString());
            }
            catch (NoConnectionIdException ex) {
                log.log(Level.SEVERE, "should not happen", ex);
            }
        }
        if (id != null) {
            packet.put("stanzaId", id);
        }
        type = this.mapType(type);
        packet.put(TYPE, type);
        packet.put("serverName", this.componentJid.getDomain());
        packet.put("allowed", "true");
        return packet;
    }

    static {
        CopyOnWriteArraySet<String> tmp = new CopyOnWriteArraySet<String>();
        tmp.add(Authorization.NOT_AUTHORIZED.getCondition());
        tmp.add(Authorization.FORBIDDEN.getCondition());
        tmp.add(Authorization.NOT_ALLOWED.getCondition());
        tmp.add(Authorization.PAYMENT_REQUIRED.getCondition());
        tmp.add(Authorization.POLICY_VIOLATION.getCondition());
        tmp.add(Authorization.RESOURCE_CONSTRAINT.getCondition());
        tmp.add(Authorization.SUBSCRIPTION_REQUIRED.getCondition());
        ALLOW_ERRORS = Collections.unmodifiableSet(tmp);
    }

    private class EntryPacket
    extends Iq {
        private final Element entry;

        private EntryPacket() {
            super(new Element("iq", new String[]{AuditLogProcessor.TYPE}, new String[]{"set"}), null, AuditLogProcessor.this.componentJid);
            this.entry = new Element("entry");
            this.init();
        }

        private EntryPacket(JID componentJid) {
            this();
            this.setPacketTo(componentJid);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init() {
            Element append = new Element("append", new String[]{"xmlns"}, new String[]{AuditLogProcessor.XMLNS});
            append.addChild((XMLNodeIfc)this.entry);
            this.getElement().addChild((XMLNodeIfc)append);
            String timestamp = null;
            SimpleDateFormat simpleDateFormat = AuditLogProcessor.this.formatter;
            synchronized (simpleDateFormat) {
                timestamp = AuditLogProcessor.this.formatter.format(new Date());
            }
            this.put("when", timestamp);
        }

        public void put(String name, String value) {
            if (value == null) {
                return;
            }
            this.entry.addChild((XMLNodeIfc)new Element(name, value));
        }
    }
}

