/*
 * Decompiled with CFR 0.152.
 */
package nextplane.auditlog;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import nextplane.auditlog.Entry;
import nextplane.auditlog.LogRepository;
import nextplane.auditlog.SLF4JRepository;
import tigase.conf.ConfigurationException;
import tigase.osgi.ModulesManagerImpl;
import tigase.server.AbstractMessageReceiver;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.PacketErrorTypeException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPException;

public class AuditLogComponent
extends AbstractMessageReceiver {
    private static final Logger log = Logger.getLogger(AuditLogComponent.class.getCanonicalName());
    protected static final String REPOSITORY_CLASSES_KEY = "repository-classes";
    private static final String[] DEF_REPOSITORY_CLASSES_VAL = new String[]{SLF4JRepository.class.getCanonicalName()};
    private static final String XMLNS = "http://tigase.org/protocol/auditlog";
    private List<LogRepository> repos = new CopyOnWriteArrayList<LogRepository>();

    public AuditLogComponent() {
        this.setName("audit-log");
    }

    public void processPacket(Packet packet) {
        try {
            boolean handled = false;
            if ("iq" == packet.getElemName()) {
                for (Element child : packet.getElement().getChildren()) {
                    if (XMLNS != child.getXMLNS()) continue;
                    try {
                        handled |= this.processAction(packet, child);
                    }
                    catch (XMPPException ex) {
                        Packet result = Authorization.INTERNAL_SERVER_ERROR.getResponseMessage(packet, null, true);
                        this.addOutPacket(result);
                    }
                }
            }
            if (!handled) {
                Packet result = Authorization.FEATURE_NOT_IMPLEMENTED.getResponseMessage(packet, null, true);
                this.addOutPacket(result);
            }
        }
        catch (PacketErrorTypeException ex) {
            log.log(Level.FINEST, "could not send ''error'' result for ''error'' type packet = {0}", packet.toString());
        }
    }

    protected boolean processAction(Packet packet, Element actionEl) throws XMPPException {
        switch (actionEl.getName()) {
            case "append": {
                if (packet.getType() != StanzaType.set) {
                    return false;
                }
                for (Element entryEl : actionEl.getChildren()) {
                    Entry entry = Entry.fromElement(entryEl);
                    if (entry == null) continue;
                    for (LogRepository repo : this.repos) {
                        repo.append(entry);
                    }
                }
                return true;
            }
            case "retrieve": {
                LogRepository repo;
                if (packet.getType() != StanzaType.get) {
                    return false;
                }
                if (!this.isAdmin(packet.getStanzaFrom())) {
                    this.addOutPacket(Authorization.FORBIDDEN.getResponseMessage(packet, null, true));
                    return true;
                }
                String offsetStr = actionEl.getAttributeStaticStr("offset");
                String limitStr = actionEl.getAttributeStaticStr("limit");
                int offset = offsetStr != null ? Integer.parseInt(offsetStr) : 0;
                int limit = limitStr != null ? Integer.parseInt(limitStr) : Integer.MAX_VALUE;
                Packet result = null;
                List<Entry> entries = null;
                Iterator<LogRepository> iterator = this.repos.iterator();
                while (iterator.hasNext() && (entries = (repo = iterator.next()).getCachedEntries(offset, limit)) == null) {
                }
                if (entries != null) {
                    Element entriesEl = new Element("entries", new String[]{"xmlns", "offset", "limit"}, new String[]{XMLNS, String.valueOf(offset), String.valueOf(limit)});
                    for (Entry entry : entries) {
                        entriesEl.addChild((XMLNodeIfc)entry.toElement());
                    }
                    result = packet.okResult(entriesEl, 0);
                } else {
                    result = Authorization.ITEM_NOT_FOUND.getResponseMessage(packet, null, true);
                }
                if (packet != null) {
                    this.addOutPacket(result);
                }
                return true;
            }
        }
        return false;
    }

    public String getDiscoDescription() {
        return "Audit Log Component";
    }

    public Map<String, Object> getDefaults(Map<String, Object> params) {
        Map defs = super.getDefaults(params);
        defs.put(REPOSITORY_CLASSES_KEY, DEF_REPOSITORY_CLASSES_VAL);
        return defs;
    }

    public void setProperties(Map<String, Object> props) throws ConfigurationException {
        super.setProperties(props);
        if (props.size() == 1) {
            return;
        }
        if (props.containsKey(REPOSITORY_CLASSES_KEY)) {
            CopyOnWriteArrayList<LogRepository> tmp_repos = new CopyOnWriteArrayList<LogRepository>();
            String[] classes = (String[])props.get(REPOSITORY_CLASSES_KEY);
            if (classes != null) {
                for (String clsName : classes) {
                    try {
                        Class cls = ModulesManagerImpl.getInstance().forName(clsName);
                        LogRepository repo = (LogRepository)cls.newInstance();
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        String prefix = "" + cls.getSimpleName() + "/";
                        for (Map.Entry<String, Object> e : props.entrySet()) {
                            if (!e.getKey().startsWith(prefix)) continue;
                            String key = e.getKey().substring(prefix.length());
                            params.put(key, e.getValue());
                        }
                        repo.initRepository(params);
                        tmp_repos.add(repo);
                    }
                    catch (Exception ex) {
                        log.log(Level.WARNING, "could initiate LogRepository instance for name " + clsName, ex);
                    }
                }
            }
            this.repos = tmp_repos;
        }
    }

    protected Collection<LogRepository> getRepositories() {
        return Collections.unmodifiableCollection(this.repos);
    }
}

