/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.strategy.cmd;

import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.strategy.ConnectionRecordExt;
import tigase.cluster.strategy.OnlineUsersCachingStrategy;
import tigase.cluster.strategy.cmd.TrafficSyncCmdAbstract;
import tigase.server.Command;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.JID;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;
import tigase.xmpp.XMPPSession;

public class UserConnectedCmd
extends TrafficSyncCmdAbstract {
    private static final Logger a = Logger.getLogger(UserConnectedCmd.class.getName());

    public UserConnectedCmd(String name, OnlineUsersCachingStrategy strat) {
        super(name, strat);
    }

    public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
        XMPPResourceConnection xMPPResourceConnection;
        this.incSyncInTraffic();
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{fromNode, visitedNodes, data, packets});
        }
        ConnectionRecordExt connectionRecordExt = this.getConnectionRecord(fromNode, data);
        this.getStrategy().usersConnected(connectionRecordExt);
        XMPPSession xMPPSession = (XMPPSession)this.getStrategy().getSM().getXMPPSessions().get(connectionRecordExt.getUserJid().getBareJID());
        if (xMPPSession != null && (xMPPResourceConnection = xMPPSession.getResourceForResource(connectionRecordExt.getUserJid().getResource())) != null) {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "Duplicate resource connection, logingout the older connection: {0}", (Object)connectionRecordExt);
            }
            try {
                Packet packet = Command.CLOSE.getPacket(this.getStrategy().getSM().getComponentId(), xMPPResourceConnection.getConnectionId(), StanzaType.set, xMPPResourceConnection.nextStanzaId());
                Element element = new Element("conflict");
                element.setXMLNS("urn:ietf:params:xml:ns:xmpp-streams");
                packet.getElement().getChild("command").addChild((XMLNodeIfc)element);
                this.getStrategy().getSM().fastAddOutPacket(packet);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "User connected jid: {0}, fromNode: {1}", new Object[]{connectionRecordExt.getUserJid(), fromNode});
        }
    }
}

