/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.strategy.cmd;

import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.strategy.ConnectionRecordExt;
import tigase.cluster.strategy.OnlineUsersCachingStrategy;
import tigase.cluster.strategy.cmd.TrafficSyncCmdAbstract;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.JID;
import tigase.xmpp.XMPPSession;

public class UserPresenceCmd
extends TrafficSyncCmdAbstract {
    private static final Logger a = Logger.getLogger(UserPresenceCmd.class.getName());

    public UserPresenceCmd(String string, OnlineUsersCachingStrategy onlineUsersCachingStrategy) {
        super(string, onlineUsersCachingStrategy);
    }

    public void executeCommand(JID jID, Set object, Map map, Queue queue2) {
        this.incSyncInTraffic();
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Called fromNode: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{jID, object, map, queue2});
        }
        ConnectionRecordExt connectionRecordExt = this.getConnectionRecord(jID, map);
        XMPPSession xMPPSession = (XMPPSession)this.getStrategy().getSM().getXMPPSessions().get(connectionRecordExt.getUserJid().getBareJID());
        Element element = (Element)queue2.poll();
        this.getStrategy().presenceUpdate(element, connectionRecordExt);
        if (xMPPSession != null) {
            if (a.isLoggable(Level.FINEST)) {
                a.log(Level.FINEST, "User's {0} XMPPSession found: {1}", new Object[]{connectionRecordExt.getUserJid().getBareJID(), xMPPSession});
            }
            for (Queue queue2 : xMPPSession.getActiveResources()) {
                Exception exception;
                xMPPSession = queue2.getPresence();
                if (!queue2.isAuthorized() || !queue2.isResourceSet() || xMPPSession == null) continue;
                try {
                    exception = Packet.packetInstance((Element)element);
                    exception.setPacketTo(queue2.getConnectionId());
                    this.getStrategy().getSM().fastAddOutPacket((Packet)exception);
                    if (map == null || !"initial".equals(map.get("pres-type"))) continue;
                    exception = Packet.packetInstance((Element)xMPPSession);
                    exception.setPacketTo(connectionRecordExt.getConnectionId());
                    this.getStrategy().getSM().fastAddOutPacket((Packet)exception);
                }
                catch (Exception exception2) {
                    exception = exception2;
                    exception2.printStackTrace();
                }
            }
        } else if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "No user session for presence update: {0}, visitedNodes: {1}, data: {2}, packets: {3}", new Object[]{jID, object, map, queue2});
        }
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "User presence jid: {0}, fromNode: {1}", new Object[]{connectionRecordExt.getUserJid(), jID});
        }
    }
}

