/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.strategy;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.SessionManagerClusteredIfc;
import tigase.cluster.strategy.CacheContener;
import tigase.cluster.strategy.ConnectionRecordExt;
import tigase.cluster.strategy.DefaultClusteringStrategy;
import tigase.cluster.strategy.a;
import tigase.cluster.strategy.cmd.RequestSyncOnlineCmd;
import tigase.cluster.strategy.cmd.RespondSyncOnlineCmd;
import tigase.cluster.strategy.cmd.TrafficStatisticsCmd;
import tigase.cluster.strategy.cmd.UserConnectedCmd;
import tigase.cluster.strategy.cmd.UserDisconnectedCmd;
import tigase.cluster.strategy.cmd.UserPresenceCmd;
import tigase.licence.LicenceChecker;
import tigase.licence.LicenceCheckerUpdateCallback;
import tigase.server.Iq;
import tigase.server.Packet;
import tigase.stats.StatisticsList;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;
import tigase.xmpp.NoConnectionIdException;
import tigase.xmpp.NotAuthorizedException;
import tigase.xmpp.StanzaType;
import tigase.xmpp.XMPPResourceConnection;

public class OnlineUsersCachingStrategy
extends DefaultClusteringStrategy {
    public static final String ONLINE_PRESENCE_CACHE_PROP_KEY = "cluster-strategy-presence-cache";
    public static final String REQUEST_SYNCONLINE_CMD = "req-sync-online-sm-cmd";
    public static final String RESPOND_SYNCONLINE_CMD = "resp-sync-online-sm-cmd";
    public static final String STRATEGY_STATS_CMD = "strategy-statistics";
    public static final String USER_CONNECTED_CMD = "user-connected-sm-cmd";
    public static final String USER_DISCONNECTED_CMD = "user-disconnected-sm-cmd";
    public static final String USER_PRESENCE_CMD = "user-presence-sm-cmd";
    private static final Logger a = Logger.getLogger(OnlineUsersCachingStrategy.class.getName());
    private boolean b = false;
    private CacheContener c = new CacheContener();
    protected static LicenceChecker licenceChecker;

    public OnlineUsersCachingStrategy() {
        this.addCommandListener((CommandListener)new RequestSyncOnlineCmd(REQUEST_SYNCONLINE_CMD, this));
        this.addCommandListener((CommandListener)new RespondSyncOnlineCmd(RESPOND_SYNCONLINE_CMD, this));
        this.addCommandListener((CommandListener)new UserConnectedCmd(USER_CONNECTED_CMD, this));
        this.addCommandListener((CommandListener)new UserDisconnectedCmd(USER_DISCONNECTED_CMD, this));
        this.addCommandListener((CommandListener)new UserPresenceCmd(USER_PRESENCE_CMD, this));
        this.addCommandListener((CommandListener)new TrafficStatisticsCmd(STRATEGY_STATS_CMD, this));
        a a2 = new a(this);
        if (licenceChecker == null) {
            licenceChecker = new LicenceChecker("acs", (LicenceCheckerUpdateCallback)a2);
        }
    }

    public boolean containsJid(BareJID bareJID) {
        return this.c.containsJid(bareJID);
    }

    public void handleLocalPacket(Packet packet, XMPPResourceConnection xMPPResourceConnection) {
        Map map;
        Object object;
        if (packet.getElemName() == "presence") {
            try {
                boolean bl = xMPPResourceConnection.getSessionData("cluster-initial-presence") == null;
                object = this.prepareConnectionParams(xMPPResourceConnection);
                if (bl) {
                    xMPPResourceConnection.putSessionData("cluster-initial-presence", (Object)"cluster-initial-presence");
                    object.put("pres-type", "initial");
                } else {
                    object.put("pres-type", "update");
                }
                map = xMPPResourceConnection.getPresence();
                List list = this.getNodesForPacketForward(this.sm.getComponentId(), null, Packet.packetInstance((Element)map));
                if (list != null && list.size() > 0) {
                    this.cluster.sendToNodes(USER_PRESENCE_CMD, (Map)object, (Element)map, this.sm.getComponentId(), null, list.toArray(new JID[list.size()]));
                }
            }
            catch (Exception exception) {
                a.log(Level.WARNING, "Problem with broadcast user presence for: " + xMPPResourceConnection, exception);
            }
        }
        if (packet.isXMLNSStaticStr(Iq.IQ_BIND_RESOURCE_PATH, "urn:ietf:params:xml:ns:xmpp-bind")) {
            try {
                map = this.prepareConnectionParams(xMPPResourceConnection);
                object = this.getNodesForUserConnect(xMPPResourceConnection.getJID());
                this.cluster.sendToNodes(USER_CONNECTED_CMD, map, this.sm.getComponentId(), object.toArray(new JID[object.size()]));
                return;
            }
            catch (Exception exception) {
                a.log(Level.WARNING, "Problem with broadcast user presence for: " + xMPPResourceConnection, exception);
            }
        }
    }

    public void handleLocalUserLogout(BareJID bareJID, XMPPResourceConnection xMPPResourceConnection) {
        try {
            Map map = this.prepareConnectionParams(xMPPResourceConnection);
            List list = this.getNodesForUserDisconnect(xMPPResourceConnection.getJID());
            this.cluster.sendToNodes(USER_DISCONNECTED_CMD, map, this.sm.getComponentId(), list.toArray(new JID[list.size()]));
            return;
        }
        catch (NotAuthorizedException notAuthorizedException) {
            a.log(Level.INFO, "NotAuthorizedException: This should really not happen as it is called for authenticated users, maybe the session was removed in the meantime. BareJID: {0}, conn: {1}", new Object[]{bareJID, xMPPResourceConnection});
            return;
        }
        catch (NoConnectionIdException noConnectionIdException) {
            a.log(Level.INFO, "NoConnectionIdException: This really should not happen. BareJID: {0}, conn: {1}", new Object[]{bareJID, xMPPResourceConnection});
            return;
        }
    }

    public void nodeConnected(JID jID) {
        super.nodeConnected(jID);
        this.requestSync(jID);
    }

    public void nodeDisconnected(JID jID) {
        super.nodeDisconnected(jID);
        this.c.removeAllForNode(jID);
    }

    public void presenceUpdate(Element element, ConnectionRecordExt connectionRecordExt) {
        if (this.b) {
            this.c.updatePresence(element, connectionRecordExt);
        }
    }

    public void userDisconnected(ConnectionRecordExt connectionRecordExt) {
        this.c.userDisconnected(connectionRecordExt);
    }

    public void usersConnected(ConnectionRecordExt ... connectionRecordExtArray) {
        this.c.usersConnected(connectionRecordExtArray);
    }

    public List getAllNodes() {
        return super.getAllNodes();
    }

    public ClusterControllerIfc getCluster() {
        return this.cluster;
    }

    public JID[] getConnectionIdsForJid(BareJID bareJID) {
        return this.c.getConnectionIdsForJid(bareJID);
    }

    public ConnectionRecordExt getConnectionRecord(JID jID) {
        return this.c.getConnectionRecord(jID);
    }

    public Set getConnectionRecords(BareJID bareJID) {
        return this.c.getConnectionRecords(bareJID);
    }

    public Map getDefaults(Map map) {
        return super.getDefaults(map);
    }

    public String getInfo() {
        return "acs-online-cache strategy";
    }

    public Object getInternalCacheData() {
        return this.c.getInternalData();
    }

    public List getNodesForJid(JID jID) {
        return this.c.getNodesForJid(jID);
    }

    public List getNodesForPacketForward(JID object, Set set, Packet packet) {
        if (set != null) {
            return null;
        }
        object = null;
        set = packet.getStanzaTo();
        boolean bl = false;
        if (packet.getElemName() == "presence" && packet.getType() != StanzaType.error && packet.getStanzaFrom() != null && packet.getStanzaTo() == null) {
            bl = true;
            set = packet.getStanzaFrom();
        }
        if (bl || this.isSuitableForForward(packet)) {
            if (bl && this.b) {
                object = this.getAllNodes();
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "Presence update and cachePresences on, selecting all nodes: {0}, for packet: {1}", new Object[]{object, packet});
                }
            } else {
                object = this.c.getNodesForJid((JID)set);
                if (a.isLoggable(Level.FINEST)) {
                    a.log(Level.FINEST, "Selected nodes: {0}, for packet: {1}", new Object[]{object, packet});
                }
            }
        } else if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Packet not suitable for forwarding: {0}", new Object[]{packet});
        }
        return object;
    }

    public List getNodesForUserConnect(JID jID) {
        return this.getAllNodes();
    }

    public List getNodesForUserDisconnect(JID jID) {
        return this.getAllNodes();
    }

    public SessionManagerClusteredIfc getSM() {
        return this.sm;
    }

    public void getStatistics(StatisticsList statisticsList) {
        super.getStatistics(statisticsList);
        statisticsList.add("cl-caching-strat", "Cached JIDs", this.c.connectionsSize(), Level.INFO);
        statisticsList.add("cl-caching-strat", "Cached conns", this.c.mapSize(), Level.INFO);
    }

    public boolean hasCompleteJidsInfo() {
        return this.c.hasCompleteJidsInfo();
    }

    public void setProperties(Map object) {
        super.setProperties((Map)object);
        object = (String)object.get(ONLINE_PRESENCE_CACHE_PROP_KEY);
        if (object != null) {
            this.b = Boolean.parseBoolean((String)object);
        }
        a.log(Level.CONFIG, "Presence caching is set to: {0}", this.b);
    }

    protected Map prepareConnectionParams(XMPPResourceConnection xMPPResourceConnection) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        linkedHashMap.put("userId", xMPPResourceConnection.getBareJID().toString());
        linkedHashMap.put("resource", xMPPResourceConnection.getResource());
        linkedHashMap.put("connectionId", xMPPResourceConnection.getConnectionId().toString());
        linkedHashMap.put("xmppSessionId", xMPPResourceConnection.getSessionId());
        linkedHashMap.put("auth-time", "" + xMPPResourceConnection.getAuthTime());
        linkedHashMap.put("creation-t", "" + xMPPResourceConnection.getCreationTime());
        linkedHashMap.put("login_t", "" + xMPPResourceConnection.getAuthTime());
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Called for conn: {0}, result: ", new Object[]{xMPPResourceConnection, linkedHashMap});
        }
        return linkedHashMap;
    }

    protected boolean presenceStatusUpdate(Packet packet) {
        return packet.getElemName() == "presence" && packet.getType() != StanzaType.error && packet.getStanzaFrom() != null && packet.getStanzaTo() == null;
    }

    protected void requestSync(JID jID) {
        this.cluster.sendToNodes(REQUEST_SYNCONLINE_CMD, this.sm.getComponentId(), new JID[]{jID});
    }
}

