/*
 * Decompiled with CFR 0.152.
 */
package tigase.cluster.strategy;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.strategy.ConnectionRecord;
import tigase.cluster.strategy.ConnectionRecordExt;
import tigase.sys.OnlineJidsReporter;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class ClusteringMetadata
implements OnlineJidsReporter {
    private static final Logger a = Logger.getLogger(ClusteringMetadata.class.getName());
    private volatile int b = 0;
    private volatile int c = 0;
    protected final Map userConnections = new ConcurrentSkipListMap();
    private boolean d = false;

    public long connectionsSize() {
        return this.b;
    }

    public boolean containsJid(BareJID bareJID) {
        return this.userConnections.containsKey(bareJID);
    }

    public long mapSize() {
        return this.c;
    }

    public boolean needsSync() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void removeAllForNode(JID jID) {
        if (a.isLoggable(Level.FINEST)) {
            a.log(Level.FINEST, "Removing connections from cache for node: {0}", jID);
        }
        Iterator iterator = this.userConnections.values().iterator();
        while (iterator.hasNext()) {
            Object object = (Map)iterator.next();
            Map map = object;
            // MONITORENTER : object
            object = object.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                if (jID.equals((Object)((ConnectionRecordExt)((Object)entry.getValue())).getNode())) {
                    object.remove();
                    --this.b;
                    if (!a.isLoggable(Level.FINEST)) continue;
                    a.log(Level.FINEST, "Removed connection: {0}", entry.getValue());
                    continue;
                }
                if (!a.isLoggable(Level.FINEST)) continue;
                a.log(Level.FINEST, "Different node: {0}", entry.getValue());
            }
            // MONITOREXIT : map
        }
    }

    public void userDisconnected(Queue object, ConnectionRecordExt connectionRecordExt) {
        object = (Map)this.userConnections.get(connectionRecordExt.getUserJid().getBareJID());
        if (object != null) {
            Object object2 = object;
            synchronized (object2) {
                if (object.remove(connectionRecordExt.getConnectionId()) != null) {
                    --this.b;
                }
                return;
            }
        }
    }

    public void usersConnected(Queue connectionRecordExtArray, ConnectionRecordExt ... connectionRecordExtArray2) {
        connectionRecordExtArray = connectionRecordExtArray2;
        int n = connectionRecordExtArray2.length;
        for (int i = 0; i < n; ++i) {
            LinkedHashMap<JID, ConnectionRecordExt> linkedHashMap;
            ConnectionRecordExt connectionRecordExt = connectionRecordExtArray[i];
            LinkedHashMap<JID, ConnectionRecordExt> linkedHashMap2 = this.userConnections;
            synchronized (linkedHashMap2) {
                linkedHashMap = (LinkedHashMap<JID, ConnectionRecordExt>)this.userConnections.get(connectionRecordExt.getUserJid().getBareJID());
                if (linkedHashMap == null) {
                    linkedHashMap = new LinkedHashMap<JID, ConnectionRecordExt>(2);
                    this.userConnections.put(connectionRecordExt.getUserJid().getBareJID(), linkedHashMap);
                    ++this.c;
                }
            }
            linkedHashMap2 = linkedHashMap;
            synchronized (linkedHashMap2) {
                if (linkedHashMap.put(connectionRecordExt.getConnectionId(), connectionRecordExt) == null) {
                    ++this.b;
                }
                continue;
            }
        }
    }

    public JID[] getConnectionIdsForJid(BareJID object) {
        JID[] jIDArray = null;
        if ((object = (Map)this.userConnections.get(object)) != null) {
            Object object2 = object;
            synchronized (object2) {
                int n = object.size();
                if (n > 0) {
                    jIDArray = object.keySet().toArray(new JID[n]);
                }
            }
        }
        return jIDArray;
    }

    public ConnectionRecordExt getConnectionRecord(JID jID) {
        ConnectionRecordExt connectionRecordExt = null;
        Map map = (Map)this.userConnections.get(jID.getBareJID());
        if (map != null) {
            Map map2 = map;
            synchronized (map2) {
                for (ConnectionRecordExt connectionRecordExt2 : map.values()) {
                    if (!jID.equals((Object)connectionRecordExt2.getUserJid())) continue;
                    connectionRecordExt = connectionRecordExt2;
                    break;
                }
            }
        }
        return connectionRecordExt;
    }

    public Set getConnectionRecords(BareJID object) {
        LinkedHashSet linkedHashSet = null;
        if ((object = (Map)this.userConnections.get(object)) != null) {
            Object object2 = object;
            synchronized (object2) {
                linkedHashSet = new LinkedHashSet(object.values());
            }
        }
        return linkedHashSet;
    }

    public Object getInternalData() {
        return this.userConnections;
    }

    public List getNodesForJid(JID object) {
        ArrayList<JID> arrayList = null;
        if ((object = (Map)this.userConnections.get(object.getBareJID())) != null) {
            Object object2 = object;
            synchronized (object2) {
                int n = object.size();
                if (n > 0) {
                    arrayList = new ArrayList<JID>(n);
                    for (ConnectionRecord connectionRecord : object.values()) {
                        if (arrayList.contains(connectionRecord.getNode())) continue;
                        arrayList.add(connectionRecord.getNode());
                    }
                }
            }
        }
        return arrayList;
    }

    public boolean hasCompleteJidsInfo() {
        return false;
    }
}

