/*
 * Tigase ACS - PubSub Component - Tigase Advanced Clustering Strategy - PubSub Component
 * Copyright (C) 2013 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.pubsub.cluster;

import tigase.util.common.TimerTask;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 * @author andrzej
 */
public class PubSubCompontentClusteredTest
		implements PubSubComponentClusteredIfc {

	private List<JID> connectedNodes = new ArrayList<JID>();
	private JID localNodeJid;
	private StrategyIfc strategy;

	public PubSubCompontentClusteredTest(JID localNodeJid, StrategyIfc strategy) {
		this.localNodeJid = localNodeJid;
		this.strategy = strategy;
		nodeConnected(localNodeJid);
	}

	public void nodeConnected(JID jid) {
		connectedNodes.add(jid);
		Collections.sort(connectedNodes);
		strategy.nodeConnected(jid);
	}

	public void nodeDisconnected(JID jid) {
		connectedNodes.remove(jid);
		strategy.nodeDisconnected(jid);
	}

	@Override
	public String getName() {
		return "pubsub";
	}

	@Override
	public boolean isLocalDomain(String domain) {
		throw new UnsupportedOperationException("Not supported yet.");
	}

	@Override
	public BareJID getDefHostName() {
		return localNodeJid.getBareJID();
	}

	@Override
	public List<JID> getNodesConnected() {
		List<JID> tmp = new ArrayList<JID>(connectedNodes);
		tmp.remove(localNodeJid);
		return Collections.unmodifiableList(tmp);
	}

	@Override
	public List<JID> getNodesConnectedWithLocal() {
		return Collections.unmodifiableList(connectedNodes);
	}

	@Override
	public void addTimerTask(TimerTask task, long delay) {
		throw new UnsupportedOperationException("Not supported yet.");
	}

}
