/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.pubsub.cluster.PartitionedStrategy;
import tigase.pubsub.cluster.PubSubComponentClusteredIfc;
import tigase.pubsub.cluster.PubSubCompontentClusteredTest;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.server.Packet;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class PartitionedStrategyTest {
    private static final JID localNodeJid = JID.jidInstanceNS((String)"pubsub@node1.tigase.im");
    private PubSubCompontentClusteredTest pubsub;
    private PartitionedStrategy strategy;

    @Before
    public void init() {
        this.strategy = new PartitionedStrategy();
        this.strategy.setLocalNodeJid(localNodeJid);
        this.pubsub = new PubSubCompontentClusteredTest(localNodeJid, (StrategyIfc)this.strategy);
        this.strategy.setPubSubComponent((PubSubComponentClusteredIfc)this.pubsub);
    }

    @After
    public void destroy() {
        this.strategy = null;
    }

    @Test
    public void getAllNodesTest() {
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesConnectedWithLocal().toArray());
        JID newNode = JID.jidInstanceNS((String)"pubsub@node2.tigase.im");
        this.pubsub.nodeConnected(newNode);
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid, newNode}, (Object[])this.strategy.getNodesConnectedWithLocal().toArray());
        this.pubsub.nodeDisconnected(newNode);
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesConnectedWithLocal().toArray());
    }

    @Test
    public void isLocalNodeTest() {
        BareJID serviceJid = BareJID.bareJIDInstanceNS((String)"pubsub.tigase.im");
        String node = "test3";
        Assert.assertTrue((String)"checking if works for single node cluster - should be local as we have only 1 node", (boolean)this.strategy.isLocalNode(serviceJid, node));
        JID nodeJid = JID.jidInstanceNS((String)"pubsub@node2.tigase.im");
        this.pubsub.nodeConnected(nodeJid);
        Assert.assertTrue((String)"checking if works for two node cluster - should be other node", (!this.strategy.isLocalNode(serviceJid, node) ? 1 : 0) != 0);
    }

    @Test
    public void getNodeForServiceNodeTest() {
        JID serviceJid = JID.jidInstanceNS((String)"pubsub.tigase.im");
        String node = "test3";
        Assert.assertEquals((Object)localNodeJid, (Object)this.strategy.getNodeForServiceNode(serviceJid, node));
        JID newNode = JID.jidInstanceNS((String)"pubsub@node2.tigase.im");
        this.pubsub.nodeConnected(newNode);
        Assert.assertEquals((Object)newNode, (Object)this.strategy.getNodeForServiceNode(serviceJid, node));
        Assert.assertEquals((Object)newNode, (Object)this.strategy.getNodeForServiceNode(serviceJid, node));
    }

    @Test
    public void getNodeForServiceTest() {
        JID serviceJid = JID.jidInstanceNS((String)"pubsub.tigase.im");
        Assert.assertEquals((Object)localNodeJid, (Object)this.strategy.getNodeForServiceJid(serviceJid));
        JID newNode = JID.jidInstanceNS((String)"pubsub@node1.tigase.im");
        this.pubsub.nodeConnected(newNode);
        Assert.assertEquals((Object)newNode, (Object)this.strategy.getNodeForServiceJid(serviceJid));
        Assert.assertEquals((Object)newNode, (Object)this.strategy.getNodeForServiceJid(serviceJid));
    }

    @Test
    public void getNodesForPacketPresenceTest() throws TigaseStringprepException {
        Packet presence = Packet.packetInstance((String)"presence", (String)"test1@tigase.im", (String)"pubsub.tigase.im", (StanzaType)StanzaType.available);
        presence.setPacketFrom(JID.jidInstance((String)"test1@tigase.im"));
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesForPacket(presence).toArray());
        JID newNode = JID.jidInstanceNS((String)"pubsub@node2.tigase.im");
        this.pubsub.nodeConnected(newNode);
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid, newNode}, (Object[])this.strategy.getNodesForPacket(presence).toArray());
    }

    @Test
    public void getNodesForPacketPublishItemTest() throws TigaseStringprepException {
        Element iq = new Element("iq", new String[]{"from", "to"}, new String[]{"test1@tigase.im", "pubsub.tigase.im"});
        Element pubsub = new Element("pubsub");
        pubsub.setAttribute("xmlns", "http://jabber.org/protocol/pubsub");
        iq.addChild((XMLNodeIfc)pubsub);
        Element publish = new Element("publish");
        publish.setAttribute("node", "test3");
        pubsub.addChild((XMLNodeIfc)publish);
        Packet packet = Packet.packetInstance((Element)iq);
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
        JID newNode = JID.jidInstanceNS((String)"pubsub@node2.tigase.im");
        this.pubsub.nodeConnected(newNode);
        Assert.assertArrayEquals((Object[])new Object[]{newNode}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
    }

    @Test
    public void getNodesForPacketConfigureNodeTest() throws TigaseStringprepException {
        Element iq = new Element("iq", new String[]{"from", "to"}, new String[]{"test1@tigase.im", "pubsub.tigase.im"});
        Element pubsub = new Element("pubsub");
        pubsub.setAttribute("xmlns", "http://jabber.org/protocol/pubsub");
        iq.addChild((XMLNodeIfc)pubsub);
        Element publish = new Element("configure");
        publish.setAttribute("node", "test2");
        pubsub.addChild((XMLNodeIfc)publish);
        Packet packet = Packet.packetInstance((Element)iq);
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
        JID newNode = JID.jidInstanceNS((String)"pubsub@node1.tigase.im");
        this.pubsub.nodeConnected(newNode);
        Assert.assertArrayEquals((Object[])new Object[]{newNode}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
        publish.setAttribute("node", "test2");
        Assert.assertArrayEquals((Object[])new Object[]{newNode}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
    }

    @Test
    public void getNodesForPacketDiscoInfoCapsResult() throws TigaseStringprepException {
        Element iq = new Element("iq", new String[]{"from", "to", "type"}, new String[]{"test1@tigase.im", "pubsub.tigase.im", "result"});
        Element query = new Element("query");
        query.setAttribute("xmlns", "http://jabber.org/protocol/disco#info");
        query.setAttribute("node", "http://tigase.org/test#0.1");
        iq.addChild((XMLNodeIfc)query);
        Packet packet = Packet.packetInstance((Element)iq);
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
        JID newNode = JID.jidInstanceNS((String)"pubsub@node2.tigase.im");
        this.pubsub.nodeConnected(newNode);
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid, newNode}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
    }
}

