/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.Date;
import java.util.Queue;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import tigase.component.exceptions.RepositoryException;
import tigase.conf.ConfigurationException;
import tigase.db.DataSource;
import tigase.eventbus.EventBusFactory;
import tigase.kernel.beans.Inject;
import tigase.kernel.core.Kernel;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.NodeType;
import tigase.pubsub.PubSubComponent;
import tigase.pubsub.PubSubConfig;
import tigase.pubsub.cluster.CachedPubSubRepositoryClustered;
import tigase.pubsub.cluster.ClusteredNodeStrategy;
import tigase.pubsub.cluster.PubSubComponentClusteredIfc;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.exceptions.PubSubException;
import tigase.pubsub.modules.PublishItemModule;
import tigase.pubsub.modules.mam.Query;
import tigase.pubsub.repository.IAffiliations;
import tigase.pubsub.repository.IPubSubDAO;
import tigase.pubsub.repository.IPubSubRepository;
import tigase.pubsub.repository.NodeAffiliations;
import tigase.pubsub.repository.cached.CachedPubSubRepository;
import tigase.pubsub.repository.cached.Node;
import tigase.pubsub.repository.cached.NodeSubscriptions;
import tigase.server.Packet;
import tigase.util.common.TimerTask;
import tigase.util.stringprep.TigaseStringprepException;
import tigase.xml.Element;
import tigase.xml.XMLNodeIfc;
import tigase.xmpp.Authorization;
import tigase.xmpp.StanzaType;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

public class ClusteredNodeStrategyTest {
    private static final JID localNodeJid = JID.jidInstanceNS((String)"pubsub@node1.tigase.im");
    private static final JID smJid = JID.jidInstanceNS((String)"sm@node1.tigase.im");
    private Kernel kernel;
    private PubSubComponentClusteredIfcImpl pubsub;
    private ClusteredNodeStrategy strategy;

    @Before
    public void init() throws ConfigurationException {
        this.kernel = new Kernel();
        this.pubsub = new PubSubComponentClusteredIfcImpl();
        this.kernel.registerBean("service").asInstance((Object)this.pubsub).exec();
        this.pubsub.register(this.kernel);
        this.pubsub.getKernel().setForceAllowNull(true);
        this.pubsub.getKernel().registerBean("eventBus").asInstance((Object)EventBusFactory.getInstance()).exec();
        this.pubsub.getKernel().registerBean(PubSubConfig.class).exec();
        this.pubsub.getKernel().registerBean(PublishItemModule.class).exec();
        this.pubsub.getKernel().registerBean("strategy").asClass(ClusteredNodeStrategy.class).exec();
        this.pubsub.getKernel().registerBean("pubsubRepository").asClass(CachedPubSubRepositoryClusteredTest.class).exec();
        this.strategy = (ClusteredNodeStrategy)this.pubsub.getKernel().getInstance(ClusteredNodeStrategy.class);
        this.strategy.setLocalNodeJid(localNodeJid);
        this.strategy.setPubSubComponent((PubSubComponentClusteredIfc)this.pubsub);
        this.pubsub.nodeConnected(localNodeJid.getDomain());
    }

    @After
    public void destroy() {
        this.strategy = null;
    }

    @Test
    public void getAllNodesTest() {
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesConnectedWithLocal().toArray());
        JID newNode = JID.jidInstanceNS((String)"pubsub@node2.tigase.im");
        this.pubsub.nodeConnected(newNode.getDomain());
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid, newNode}, (Object[])this.strategy.getNodesConnectedWithLocal().toArray());
        this.pubsub.nodeDisconnected(newNode.getDomain());
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesConnectedWithLocal().toArray());
    }

    @Test
    public void isLocalNodeTest() {
        BareJID serviceJid = BareJID.bareJIDInstanceNS((String)"pubsub.tigase.im");
        String node = "test2";
        Assert.assertTrue((String)"checking if works for single node cluster - should be local as we have only 1 node", (boolean)this.strategy.isLocalNode(serviceJid, node));
        this.strategy.nodeConnected(JID.jidInstanceNS((String)"pubsub@node2.tigase.im"));
        Assert.assertTrue((String)"checking if works for two node cluster - should be always local node", (boolean)this.strategy.isLocalNode(serviceJid, node));
    }

    @Test
    public void getNodeForServiceTest() {
        JID serviceJid = JID.jidInstanceNS((String)"pubsub.tigase.im");
        Assert.assertEquals((Object)localNodeJid, (Object)this.strategy.getNodeForServiceJid(serviceJid));
        JID newNode = JID.jidInstanceNS((String)"pubsub@node1.tigase.im");
        this.pubsub.nodeConnected(newNode.getDomain());
        Assert.assertEquals((Object)newNode, (Object)this.strategy.getNodeForServiceJid(serviceJid));
        Assert.assertEquals((Object)newNode, (Object)this.strategy.getNodeForServiceJid(serviceJid));
    }

    @Test
    public void getNodesForPacketPresenceTest() throws TigaseStringprepException, PubSubException {
        Packet presence = Packet.packetInstance((String)"presence", (String)"test1@tigase.im", (String)"pubsub.tigase.im", (StanzaType)StanzaType.available);
        presence.setPacketFrom(smJid);
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesForPacket(presence).toArray());
        JID newNode = JID.jidInstanceNS((String)"pubsub@node2.tigase.im");
        this.pubsub.nodeConnected(newNode.getDomain());
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid, newNode}, (Object[])this.strategy.getNodesForPacket(presence).toArray());
    }

    @Test
    public void getNodesForPacketPublishItemTest() throws TigaseStringprepException, PubSubException {
        Element iq = new Element("iq", new String[]{"from", "to"}, new String[]{"test1@tigase.im", "pubsub.tigase.im"});
        Element pubsub = new Element("pubsub");
        pubsub.setAttribute("xmlns", "http://jabber.org/protocol/pubsub");
        iq.addChild((XMLNodeIfc)pubsub);
        Element publish = new Element("publish");
        publish.setAttribute("node", "test2");
        pubsub.addChild((XMLNodeIfc)publish);
        Packet packet = Packet.packetInstance((Element)iq);
        packet.setPacketFrom(smJid);
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
        JID newNode = JID.jidInstanceNS((String)"pubsub@node2.tigase.im");
        this.pubsub.nodeConnected(newNode.getDomain());
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
    }

    @Test
    public void getNodesForPacketConfigureNodeTest() throws TigaseStringprepException, PubSubException {
        Element iq = new Element("iq", new String[]{"from", "to"}, new String[]{"test1@tigase.im", "pubsub.tigase.im"});
        Element pubsub = new Element("pubsub");
        pubsub.setAttribute("xmlns", "http://jabber.org/protocol/pubsub");
        iq.addChild((XMLNodeIfc)pubsub);
        Element publish = new Element("configure");
        publish.setAttribute("node", "test2");
        pubsub.addChild((XMLNodeIfc)publish);
        Packet packet = Packet.packetInstance((Element)iq);
        packet.setPacketFrom(smJid);
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
        JID newNode = JID.jidInstanceNS((String)"pubsub@node1.tigase.im");
        this.pubsub.nodeConnected(newNode.getDomain());
        Assert.assertArrayEquals((Object[])new Object[]{newNode}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
        publish.setAttribute("node", "test2");
        Assert.assertArrayEquals((Object[])new Object[]{newNode}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
    }

    @Test
    public void getNodesForPacketPublishItemPepTest() throws TigaseStringprepException, PubSubException {
        Element iq = new Element("iq", new String[]{"from", "to"}, new String[]{"test1@tigase.im", "test1@tigase.im"});
        Element pubsub = new Element("pubsub");
        pubsub.setAttribute("xmlns", "http://jabber.org/protocol/pubsub");
        iq.addChild((XMLNodeIfc)pubsub);
        Element publish = new Element("publish");
        publish.setAttribute("node", "test2");
        pubsub.addChild((XMLNodeIfc)publish);
        Packet packet = Packet.packetInstance((Element)iq);
        packet.setPacketFrom(smJid);
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
        JID newNode = JID.jidInstanceNS((String)"pubsub@node2.tigase.im");
        this.pubsub.nodeConnected(newNode.getDomain());
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
        try {
            iq = new Element("iq", new String[]{"from", "to"}, new String[]{"test1@tigase.im", "test2@tigase.im"});
            iq.addChild((XMLNodeIfc)pubsub);
            packet = Packet.packetInstance((Element)iq);
            packet.setPacketFrom(smJid);
            this.strategy.getNodesForPacket(packet).toArray();
        }
        catch (Exception ex) {
            Assert.assertEquals(PubSubException.class, ex.getClass());
            Assert.assertEquals((Object)Authorization.FORBIDDEN, (Object)((PubSubException)ex).getErrorCondition());
        }
    }

    @Test
    public void getNodesForPacketPublishItemPepCheckSingleCreationTest() throws TigaseStringprepException, PubSubException, RepositoryException {
        Element iq = new Element("iq", new String[]{"from", "to"}, new String[]{"test1@tigase.im", "test1@tigase.im"});
        Element pubsub = new Element("pubsub");
        pubsub.setAttribute("xmlns", "http://jabber.org/protocol/pubsub");
        iq.addChild((XMLNodeIfc)pubsub);
        Element publish = new Element("publish");
        publish.setAttribute("node", "test2");
        pubsub.addChild((XMLNodeIfc)publish);
        Packet packet = Packet.packetInstance((Element)iq);
        packet.setPacketFrom(smJid);
        PublishItemModule publishItemModule = (PublishItemModule)this.pubsub.getKernel().getInstance(PublishItemModule.class);
        IPubSubRepository pubSubRepository = (IPubSubRepository)this.pubsub.getKernel().getInstance(IPubSubRepository.class);
        AbstractNodeConfig node = publishItemModule.ensurePepNode(packet.getStanzaTo().getBareJID(), "test2", packet.getStanzaFrom().getBareJID());
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
        System.out.println("expected = " + node + " got " + pubSubRepository.getNodeConfig(packet.getStanzaTo().getBareJID(), "test2"));
        Assert.assertTrue((node == pubSubRepository.getNodeConfig(packet.getStanzaTo().getBareJID(), "test2") ? 1 : 0) != 0);
        JID newNode = JID.jidInstanceNS((String)"pubsub@node2.tigase.im");
        this.pubsub.nodeConnected(newNode.getDomain());
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
        Assert.assertTrue((node == pubSubRepository.getNodeConfig(packet.getStanzaTo().getBareJID(), "test2") ? 1 : 0) != 0);
    }

    @Test
    public void getNodesForPacketDiscoInfoCapsResult() throws TigaseStringprepException, PubSubException {
        Element iq = new Element("iq", new String[]{"from", "to", "type"}, new String[]{"test1@tigase.im", "pubsub.tigase.im", "result"});
        Element query = new Element("query");
        query.setAttribute("xmlns", "http://jabber.org/protocol/disco#info");
        query.setAttribute("node", "http://tigase.org/test#0.1");
        iq.addChild((XMLNodeIfc)query);
        Packet packet = Packet.packetInstance((Element)iq);
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
        JID newNode = JID.jidInstanceNS((String)"pubsub@node2.tigase.im");
        this.pubsub.nodeConnected(newNode.getDomain());
        Assert.assertArrayEquals((Object[])new Object[]{localNodeJid, newNode}, (Object[])this.strategy.getNodesForPacket(packet).toArray());
    }

    public static class PubSubComponentClusteredIfcImpl
    extends PubSubComponent
    implements PubSubComponentClusteredIfc {
        @Inject
        private StrategyIfc strategy;

        public boolean isLocalDomain(String domain) {
            return true;
        }

        public String getName() {
            return "pubsub";
        }

        public JID getComponentId() {
            return localNodeJid;
        }

        public BareJID getDefHostName() {
            return localNodeJid.getBareJID();
        }

        public void addTimerTask(TimerTask task, long delay) {
        }

        public String getComponentVersion() {
            return "1";
        }

        public boolean isDiscoNonAdmin() {
            return true;
        }

        protected void registerModules(Kernel kernel) {
        }

        protected void onNodeConnected(JID jid) {
            super.onNodeConnected(jid);
            this.strategy.nodeConnected(jid);
        }

        protected void onNodeDisconnected(JID jid) {
            super.onNodeDisconnected(jid);
            this.strategy.nodeDisconnected(jid);
        }
    }

    public static class CachedPubSubRepositoryClusteredTest
    extends CachedPubSubRepositoryClustered<Integer> {
        public void addToRootCollection(BareJID serviceJid, String nodeName) {
        }

        public void createNode(BareJID serviceJid, String nodeName, BareJID ownerJid, AbstractNodeConfig nodeConfig, NodeType nodeType, String collection) throws RepositoryException {
            tigase.pubsub.repository.cached.NodeAffiliations nodeAffiliations = NodeAffiliations.create((Queue)null);
            NodeSubscriptions nodeSubscriptions = tigase.pubsub.repository.NodeSubscriptions.create();
            int nodeId = (serviceJid.toString() + nodeName).hashCode();
            Node node = new Node((Object)nodeId, serviceJid, nodeConfig, nodeAffiliations, nodeSubscriptions, ownerJid, new Date());
            CachedPubSubRepository.NodeKey key = this.createKey(serviceJid, nodeName);
            this.nodes.put(key, node);
        }

        public AbstractNodeConfig getNodeConfig(BareJID serviceJid, String nodeName) {
            Node node = this.getNode(serviceJid, nodeName);
            return node == null ? null : node.getNodeConfig();
        }

        public void update(BareJID serviceJid, String nodeName, IAffiliations nodeAffiliations) throws RepositoryException {
        }

        protected Node getNode(BareJID serviceJid, String nodeName) {
            CachedPubSubRepository.NodeKey key = this.createKey(serviceJid, nodeName);
            return (Node)this.nodes.get(key);
        }

        public void setDao(IPubSubDAO<Integer, DataSource, Query> dao) {
        }
    }
}

