/*
 * Decompiled with CFR 0.152.
 */
package tigase.pubsub.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.ClusterControllerIfc;
import tigase.cluster.api.CommandListener;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.pubsub.AbstractNodeConfig;
import tigase.pubsub.cluster.PubSubComponentClustered;
import tigase.pubsub.cluster.StrategyIfc;
import tigase.pubsub.modules.NodeConfigModule;
import tigase.pubsub.modules.NodeDeleteModule;
import tigase.pubsub.repository.RepositoryException;
import tigase.server.Packet;
import tigase.xml.Element;
import tigase.xmpp.BareJID;
import tigase.xmpp.JID;

public class PartitionedStrategy
implements StrategyIfc,
NodeConfigModule.NodeConfigurationChangedHandler,
NodeDeleteModule.NodeDeleteHandler {
    private static final Logger a = Logger.getLogger(PartitionedStrategy.class.getCanonicalName());
    private static final String b = "node";
    private static final String c = "node-config-refresh-pubsub-cmd";
    private static final String[] d = new String[]{"iq", "pubsub"};
    private final Set<String> e = new HashSet<String>();
    private a f = new a();
    private CopyOnWriteArrayList<JID> g = new CopyOnWriteArrayList();
    private ClusterControllerIfc h;
    private JID i;
    private PubSubComponentClustered j;

    public PartitionedStrategy() {
        this.e.add("create");
        this.e.add("configure");
        this.e.add("default");
        this.e.add("delete");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeConnected(JID nodeJid) {
        CopyOnWriteArrayList<JID> copyOnWriteArrayList = this.g;
        synchronized (copyOnWriteArrayList) {
            if (this.g.addIfAbsent(nodeJid)) {
                this.a(this.g);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void nodeDisconnected(JID nodeJid) {
        CopyOnWriteArrayList<JID> copyOnWriteArrayList = this.g;
        synchronized (copyOnWriteArrayList) {
            this.g.remove(nodeJid);
        }
    }

    public void onConfigurationChanged(Packet packet, String nodeName) {
        this.a(packet.getStanzaTo(), nodeName);
    }

    public void onNodeDeleted(Packet packet, String nodeName) {
        this.a(packet.getStanzaTo(), nodeName);
    }

    @Override
    public List<JID> getAllNodes() {
        return this.g;
    }

    @Override
    public JID getLocalNodeJid() {
        return this.i;
    }

    public JID getNodeForServiceJid(JID serviceJid) {
        int n = serviceJid.hashCode();
        return this.g.get(Math.abs(n % this.g.size()));
    }

    public JID getNodeForServiceNode(JID serviceJid, String node) {
        int n = Math.abs((391 + serviceJid.hashCode()) * 23 + node.hashCode());
        return this.g.get(Math.abs(n % this.g.size()));
    }

    @Override
    public List<JID> getNodesForPacket(Packet packet) {
        if (packet.getElemName() == "presence") {
            return new ArrayList<JID>(this.g);
        }
        if (packet.getElemName() == "message") {
            return Collections.singletonList(this.i);
        }
        if (packet.getElemName() == "iq") {
            String string;
            JID jID = packet.getStanzaTo();
            List list = packet.getElemChildrenStaticStr(d);
            Element element = list != null && !list.isEmpty() ? (Element)list.get(0) : null;
            String string2 = string = element != null ? element.getAttributeStaticStr(b) : null;
            if (string == null || element == null || this.a(element)) {
                JID jID2 = this.getNodeForServiceJid(jID);
                return Collections.singletonList(jID2);
            }
            JID jID3 = this.getNodeForServiceNode(jID, string);
            return Collections.singletonList(jID3);
        }
        a.log(Level.SEVERE, "received unknown packet = {0}", packet);
        return null;
    }

    @Override
    public boolean isLocalNode(BareJID serviceJid, String node) {
        return this.i.equals((Object)this.getNodeForServiceNode(JID.jidInstance((BareJID)serviceJid), node));
    }

    @Override
    public void setClusterController(ClusterControllerIfc cl_controller) {
        if (this.h != null) {
            this.h.removeCommandListener((CommandListener)this.f);
        }
        this.h = cl_controller;
        this.h.setCommandListener((CommandListener)this.f);
    }

    @Override
    public void setPubSubComponentClustered(PubSubComponentClustered pubSubComponent) {
        this.j = pubSubComponent;
        this.setLocalNodeJid(JID.jidInstance((BareJID)pubSubComponent.getDefHostName()));
    }

    protected void setLocalNodeJid(JID jid) {
        this.i = jid;
        this.nodeConnected(this.i);
    }

    private void a(JID jID, String string) {
        AbstractNodeConfig abstractNodeConfig;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("service-jid", jID.toString());
        hashMap.put(b, string);
        try {
            String string2;
            abstractNodeConfig = this.j.getPubSubRepository().getNodeConfig(jID.getBareJID(), string);
            if (abstractNodeConfig != null && (string2 = abstractNodeConfig.getCollection()) != null) {
                hashMap.put("new-collection", string2);
            }
        }
        catch (RepositoryException repositoryException) {
            a.log(Level.SEVERE, null, repositoryException);
        }
        abstractNodeConfig = this.getNodeForServiceNode(jID, string);
        this.h.sendToNodes(c, hashMap, this.i, new JID[]{abstractNodeConfig});
    }

    private void a(List<JID> list) {
        Object[] objectArray = list.toArray(new JID[list.size()]);
        Arrays.sort(objectArray);
        list.clear();
        list.addAll(Arrays.asList(objectArray));
    }

    private boolean a(Element element) {
        String string = element.getName();
        return this.e.contains(string);
    }

    private class a
    extends CommandListenerAbstract {
        public a() {
            super(PartitionedStrategy.c);
        }

        public void executeCommand(JID fromNode, Set<JID> visitedNodes, Map<String, String> data, Queue<Element> packets) throws ClusterCommandException {
            JID jID = JID.jidInstanceNS((String)data.get("service-jid"));
            String string = data.get(PartitionedStrategy.b);
            String string2 = data.get("new-collection");
            PartitionedStrategy.this.j.getPubSubRepository().refreshNodeConfig(jID.getBareJID(), string, string2);
        }
    }
}

