/*
 * Tigase ACS - Meet Component - Tigase Advanced Clustering Strategy - Meet Component
 * Copyright (C) 2021 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.meet.cluster.mix;

import tigase.component.exceptions.ComponentException;
import tigase.kernel.beans.Inject;
import tigase.meet.cluster.StrategyIfc;
import tigase.mix.cluster.ClusteredChannelsStrategy;
import tigase.pubsub.exceptions.PubSubException;
import tigase.server.Packet;
import tigase.xmpp.jid.JID;

import java.util.Collections;
import java.util.List;

public class MixStrategy extends ClusteredChannelsStrategy {

	@Inject
	private StrategyIfc strategy;

	@Override
	public List<JID> getNodesForPacket(Packet packet) throws PubSubException {
		if (packet.getStanzaTo() != null && packet.getStanzaTo().getResource() == null && packet.getStanzaFrom().getLocalpart() != null) {
			// packet is sent to Meet bare jid
			if (packet.getElemChild("jingle", "urn:xmpp:jingle:1") != null) {
				// this is a jingle packet, so we should process it
				try {
					return Collections.singletonList(strategy.getNodeForPacket(packet));
				} catch (ComponentException ex) {
					throw new PubSubException(ex.getErrorCondition(), ex.getMessage(), ex);
				}
			}
		}
		return super.getNodesForPacket(packet);
	}
}
