/*
 * Tigase ACS - Meet Component - Tigase Advanced Clustering Strategy - Meet Component
 * Copyright (C) 2021 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.meet.cluster.commands;

import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.meet.cluster.StrategyIfc;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

import java.util.Map;
import java.util.Queue;
import java.util.Set;

@Bean(name = "meetSyncResponseCommand", parent = StrategyIfc.class, active = true)
public class MeetSyncResponseCommand
		extends CommandListenerAbstract {

	public static final String MEET_SYNC_RESPONSE = "meet-sync-response";

	public static void respond(StrategyIfc strategyIfc, JID toNode, Queue<Element> elements) {
		strategyIfc.getClusterController()
				.sendToNodes(MEET_SYNC_RESPONSE, elements, strategyIfc.getLocalNodeJid(), null, new JID[]{toNode});
	}

	@Inject
	private StrategyIfc strategy;

	public MeetSyncResponseCommand() {
		super(MEET_SYNC_RESPONSE, Priority.HIGH);
	}

	@Override
	public void executeCommand(JID jid, Set<JID> set, Map<String, String> map, Queue<Element> queue)
			throws ClusterCommandException {
		Element el = null;
		while ((el = queue.poll()) != null) {
			if ("meet".equals(el.getName())) {
				String meetJidStr = el.getAttributeStaticStr("jid");
				if (meetJidStr != null) {
					strategy.setMeetToNodeMapping(BareJID.bareJIDInstanceNS(meetJidStr), jid);
				}
			}
		}
	}

	public enum Action {
		request,
		response
	}
}
