/*
 * Tigase ACS - Meet Component - Tigase Advanced Clustering Strategy - Meet Component
 * Copyright (C) 2021 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.meet.cluster.commands;

import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.meet.cluster.StrategyIfc;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xmpp.jid.JID;

import java.util.ArrayDeque;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

@Bean(name = "meetSyncRequestCommand", parent = StrategyIfc.class, active = true)
public class MeetSyncRequestCommand
		extends CommandListenerAbstract {

	public static final String MEET_SYNC_REQUEST = "meet-sync-request";

	public static void request(StrategyIfc strategyIfc, JID fromNode) {
		strategyIfc.getClusterController()
				.sendToNodes(MEET_SYNC_REQUEST, null, strategyIfc.getLocalNodeJid(), new JID[]{fromNode});
	}

	@Inject
	private StrategyIfc strategy;

	public MeetSyncRequestCommand() {
		super(MEET_SYNC_REQUEST, Priority.HIGH);
	}

	@Override
	public void executeCommand(JID jid, Set<JID> set, Map<String, String> map, Queue<Element> queue)
			throws ClusterCommandException {
		ArrayDeque<Element> response = new ArrayDeque<>();
		strategy.streamLocalMeets().map(node -> new Element("meet", new String[] { "jid" }, new String[] { node.toString() })).forEach(response::offer);
		MeetSyncResponseCommand.respond(strategy, jid, response);
	}

	public enum Action {
		request,
		response
	}
	
}
