/*
 * Tigase ACS - Meet Component - Tigase Advanced Clustering Strategy - Meet Component
 * Copyright (C) 2021 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.meet.cluster.commands;

import tigase.cluster.api.ClusterCommandException;
import tigase.cluster.api.CommandListenerAbstract;
import tigase.kernel.beans.Bean;
import tigase.kernel.beans.Inject;
import tigase.meet.cluster.StrategyIfc;
import tigase.server.Priority;
import tigase.xml.Element;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

import java.util.*;
import java.util.logging.Level;
import java.util.logging.Logger;

@Bean(name = "meetCreationLockCommand", parent = StrategyIfc.class, active = true)
public class MeetCreationLockCommand
		extends CommandListenerAbstract {

	public static final String MEET_CREATION_LOCK = "meet-creation-lock";

	public static void acquireLock(StrategyIfc strategy, BareJID meetJid, Collection<JID> toNodes, Long until) {
		executeAction(strategy, Action.acquire, meetJid, toNodes, until, null);
	}

	public static void acquiredLock(StrategyIfc strategy, BareJID meetJid, Collection<JID> toNodes, boolean result) {
		executeAction(strategy, Action.acquired, meetJid, toNodes, null, result);
	}

	public static void releaseLock(StrategyIfc strategy, BareJID meetJid, Collection<JID> toNodes, boolean success) {
		executeAction(strategy, Action.release, meetJid, toNodes, null, success);
	}

	private static void executeAction(StrategyIfc strategy, Action action, BareJID meetJid, Collection<JID> toNodes, Long until, Boolean result) {
		Map<String, String> data = new HashMap<>();
		data.put("action", action.name());
		data.put("meet", meetJid.toString());
		if (until != null) {
			data.put("until", String.valueOf(until));
		}
		if (result != null) {
			data.put("result", String.valueOf(result));
		}

		strategy.getClusterController().sendToNodes(MEET_CREATION_LOCK, data, strategy.getLocalNodeJid(), toNodes.toArray(JID[]::new));
	}

	private static final Logger log = Logger.getLogger(MeetCreationLockCommand.class.getCanonicalName());

	@Inject
	private StrategyIfc strategy;

	public MeetCreationLockCommand() {
		super(MEET_CREATION_LOCK, Priority.HIGH);
	}

	@Override
	public void executeCommand(JID jid, Set<JID> set, Map<String, String> map, Queue<Element> queue)
			throws ClusterCommandException {
		try {
			BareJID meetJid = BareJID.bareJIDInstance(map.get("meet"));
			Action action = Action.valueOf(map.get("action"));
			switch (action) {
				case acquire:
					long until = Long.parseLong(map.get("until"));
					boolean result = strategy.createMeetCreationLock(meetJid, until, jid);
					MeetCreationLockCommand.acquiredLock(strategy, meetJid, Collections.singletonList(jid), result);
					break;
				case acquired:
					boolean acquired = Boolean.parseBoolean(map.get("result"));
					strategy.acquiredMeetCreationLock(meetJid, jid, acquired);
					break;
				case release:
					boolean success = Boolean.parseBoolean(map.get("result"));
					strategy.releasedMeetCreationLock(meetJid, jid, success);
					break;
			}
		} catch (Throwable ex) {
			log.log(Level.WARNING, "Exception while processing cluster command", ex);
		}
	}

	public enum Action {
		acquire,
		acquired,
		release
	}
}
