/*
 * Tigase ACS - Meet Component - Tigase Advanced Clustering Strategy - Meet Component
 * Copyright (C) 2021 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.meet.cluster;

import tigase.cluster.api.ClusterControllerIfc;
import tigase.component.exceptions.ComponentException;
import tigase.server.Packet;
import tigase.xmpp.jid.BareJID;
import tigase.xmpp.jid.JID;

import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;

public interface StrategyIfc {

	void nodeConnected(JID nodeJid);
	void nodeDisconnected(JID nodeJid);
	
	JID getLocalNodeJid();

	/**
	 * Returns cluster node JID which should process this packet
	 * @param packet
	 * @return
	 * @throws ComponentException
	 */
	JID getNodeForPacket(Packet packet) throws ComponentException;

	/**
	 * Creates cluster-wide meet creation lock for bare jid
	 * @param meetJid
	 * @return
	 */
	CompletableFuture<Void> acquireMeetCreationLock(BareJID meetJid);

	/**
	 * Releases local meet creation lock and meet bare jid to node mapping on failure
	 * @param meetJid
	 * @param success
	 */
	void releaseMeetCreationLock(BareJID meetJid, boolean success);

	/**
	 * Method creates local meet creation lock
	 * @param meetJid
	 * @param time
	 * @param node
	 * @return
	 */
	boolean createMeetCreationLock(BareJID meetJid, long time, JID node);
	
	/**
	 * Method notify future that meet creation lock was acquired at particular node
	 * @param meetJid
	 * @param node
	 * @param result
	 */
	void acquiredMeetCreationLock(BareJID meetJid, JID node, boolean result);

	/**
	 * Method releases meet creation lock and removes mapping of meet bare jid to node on failure
	 * @param meetJid
	 * @param node
	 * @param success
	 */
	void releasedMeetCreationLock(BareJID meetJid, JID node, boolean success);

	/**
	 * Sets meet bare jid to cluster node mapping
	 * @param meetJid
	 * @param jid
	 */
	void setMeetToNodeMapping(BareJID meetJid, JID jid);
	
	/**
	 * Removes meet bare jid to cluster node mapping
	 * @param meetJid
	 * @param jid
	 */
	void removeMeetToNodeMapping(BareJID meetJid, JID jid);

	/**
	 * Method returns creation lock timeout
	 * @return
	 */
	long getCreationLockTimeout();

	ClusterControllerIfc getClusterController();

	/**
	 * Returns stream of bare jid's of local meets
	 * @return
	 */
	Stream<BareJID> streamLocalMeets();

	int getMeetsCount();
}
