/*
 * Licence Library - bootstrap configuration for all Tigase projects
 * Copyright (C) 2011 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.licence;

import tigase.util.log.LogFormatter;

import java.util.Arrays;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TestLogger {

	public static void configureLogger(Logger log, Level level) {
		log.setUseParentHandlers(false);
		log.setLevel(level);
		final Handler[] handlers = log.getHandlers();
		if (Arrays.stream(handlers).noneMatch(ConsoleHandler.class::isInstance)) {
			ConsoleHandler ch = new ConsoleHandler();
			ch.setLevel(level);
			ch.setFormatter(new LogFormatter());
			log.addHandler(ch);
		}
		for (Handler logHandler : handlers) {
			logHandler.setLevel(level);
		}
	}
}
