/*
 * Licence Library - bootstrap configuration for all Tigase projects
 * Copyright (C) 2011 Tigase, Inc. (office@tigase.com) - All Rights Reserved
 * Unauthorized copying of this file, via any medium is strictly prohibited
 * Proprietary and confidential
 */
package tigase.licence;

import org.junit.Assert;
import org.junit.Test;

/**
 * Created by bmalkow on 16.12.2016.
 */
public class TOTPTest {

	@Test
	public void testGenerate() throws Exception {
		TOTP totp = new TOTP();
		totp.setSecret("123456");
		Assert.assertEquals("VUJPEPFFHBU9911P882IGV7FDFFAUI0E", totp.generateTOTP(1));
		Assert.assertEquals("CK6MJE7MNGOE23UG4UUUGVR3VNJ90CD9", totp.generateTOTP(2));
		Assert.assertEquals("L2IRL3DUOM7K5AQRHQCG23OIM1K9IE9T", totp.generateTOTP(3));
		Assert.assertEquals("4C70HD9F4JOM0UBB03OBR399B6PF6OSB", totp.generateTOTP(10));
		Assert.assertEquals("E19TGORHA4VKS5KQD3FS6BJP0HDC61MT", totp.generateTOTP(100));
		Assert.assertEquals("K1HBCQOC1KTT9VEVN8RHQP2BETH4I7GP", totp.generateTOTP(1000));
		Assert.assertEquals("T842VH8KJEON5SVG2RSBU88VLGV6RCTB", totp.generateTOTP(10000));
		Assert.assertEquals("J4O2KR3EVVRML7U9JTI7S3NE2SQNH24F", totp.generateTOTP(10001));
	}

	@Test
	public void testGenerateVerify() throws Exception {
		TOTP totp = new TOTP();
		totp.setSecret("123456");
		Assert.assertTrue(totp.verify(totp.generateTOTP()));

		String x = totp.generateTOTP();
		totp.setSecret("123465");
		Assert.assertFalse(totp.verify(x));
	}

	@Test
	public void testVerify() throws Exception {
		TOTP totp = new TOTP();
		totp.setSecret("123456");

		Assert.assertFalse(totp.verify("4C70HD9F4JOM0UBB03OBR399B6PF6OSB", 8));
		Assert.assertTrue(totp.verify("4C70HD9F4JOM0UBB03OBR399B6PF6OSB", 9));
		Assert.assertTrue(totp.verify("4C70HD9F4JOM0UBB03OBR399B6PF6OSB", 10));
		Assert.assertTrue(totp.verify("4C70HD9F4JOM0UBB03OBR399B6PF6OSB", 11));
		Assert.assertFalse(totp.verify("4C70HD9F4JOM0UBB03OBR399B6PF6OSB", 12));
	}

}